/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import java.util.ArrayList;

public class OStringParser {
    public static final String WHITE_SPACE = " ";
    public static final String COMMON_JUMP = " \r\n";

    public static String[] getWords(String iRecord, String iSeparatorChars) {
        return OStringParser.getWords(iRecord, iSeparatorChars, false);
    }

    public static String[] getWords(String iRecord, String iSeparatorChars, boolean iIncludeStringSep) {
        return OStringParser.getWords(iRecord, iSeparatorChars, " \n\r\t", iIncludeStringSep);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] getWords(String iText, String iSeparatorChars, String iJumpChars, boolean iIncludeStringSep) {
        iText = iText.trim();
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder(64);
        int stringBeginChar = ' ';
        int openBraket = 0;
        int openGraph = 0;
        boolean escape = false;
        int i = 0;
        while (true) {
            block16: {
                char c;
                block25: {
                    boolean charFound;
                    block27: {
                        block31: {
                            block17: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block26: {
                                                block23: {
                                                    block24: {
                                                        block18: {
                                                            char nextChar;
                                                            block22: {
                                                                block21: {
                                                                    block20: {
                                                                        block19: {
                                                                            if (i >= iText.length()) break block17;
                                                                            c = iText.charAt(i);
                                                                            if (escape || c != '\\' || i + 1 >= iText.length()) break block18;
                                                                            nextChar = iText.charAt(i + 1);
                                                                            if (nextChar != 'u') break block19;
                                                                            i = OStringParser.readUnicode(iText, i + 2, buffer);
                                                                            break block16;
                                                                        }
                                                                        if (nextChar != 'n') break block20;
                                                                        buffer.append(stringBeginChar == 32 ? "\n" : "\\\n");
                                                                        ++i;
                                                                        break block16;
                                                                    }
                                                                    if (nextChar != 'r') break block21;
                                                                    buffer.append(stringBeginChar == 32 ? "\r" : "\\\r");
                                                                    ++i;
                                                                    break block16;
                                                                }
                                                                if (nextChar != 't') break block22;
                                                                buffer.append(stringBeginChar == 32 ? "\t" : "\\\t");
                                                                ++i;
                                                                break block16;
                                                            }
                                                            if (nextChar == 'f') {
                                                                buffer.append(stringBeginChar == 32 ? "\f" : "\\\f");
                                                                ++i;
                                                                break block16;
                                                            } else if (stringBeginChar != 32 && nextChar == '\'' || nextChar == '\"') {
                                                                buffer.append('\\');
                                                                buffer.append(nextChar);
                                                                ++i;
                                                                break block16;
                                                            } else {
                                                                buffer.append('\\');
                                                                escape = true;
                                                            }
                                                            break block16;
                                                        }
                                                        if (escape || c != '\'' && c != '\"') break block23;
                                                        if (stringBeginChar == 32) break block24;
                                                        if (stringBeginChar != c) break block25;
                                                        stringBeginChar = 32;
                                                        if (iIncludeStringSep) {
                                                            buffer.append(c);
                                                        }
                                                        break block16;
                                                    }
                                                    stringBeginChar = c;
                                                    if (iIncludeStringSep) {
                                                        buffer.append(c);
                                                    }
                                                    break block16;
                                                }
                                                if (stringBeginChar != 32) break block25;
                                                if (c != '[') break block26;
                                                ++openBraket;
                                                break block27;
                                            }
                                            if (c != ']') break block28;
                                            --openBraket;
                                            break block27;
                                        }
                                        if (c != 123) break block29;
                                        ++openGraph;
                                        break block27;
                                    }
                                    if (c != '}') break block30;
                                    --openGraph;
                                    break block27;
                                }
                                if (openBraket != 0 || openGraph != 0) break block27;
                                charFound = false;
                                break block31;
                            }
                            if (buffer.length() > 0) {
                                fields.add(buffer.toString());
                            }
                            String[] result = new String[fields.size()];
                            fields.toArray(result);
                            return result;
                        }
                        for (int sepIndex = 0; sepIndex < iSeparatorChars.length(); ++sepIndex) {
                            if (iSeparatorChars.charAt(sepIndex) != c) continue;
                            charFound = true;
                            if (buffer.length() <= 0) break;
                            fields.add(buffer.toString());
                            buffer.setLength(0);
                            break;
                        }
                        if (charFound) break block16;
                    }
                    if (stringBeginChar != 32) break block25;
                    charFound = false;
                    for (int jumpIndex = 0; jumpIndex < iJumpChars.length(); ++jumpIndex) {
                        if (iJumpChars.charAt(jumpIndex) != c) continue;
                        charFound = true;
                        break;
                    }
                    if (charFound) break block16;
                }
                buffer.append(c);
                if (escape) {
                    escape = false;
                }
            }
            ++i;
        }
    }

    public static String[] split(String iText, char iSplitChar, String iJumpChars) {
        iText = iText.trim();
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder(256);
        char stringChar = ' ';
        boolean escape = false;
        boolean jumpSplitChar = false;
        for (int i = 0; i < iText.length(); ++i) {
            char c = iText.charAt(i);
            if (!escape && c == '\\' && i + 1 < iText.length()) {
                if (iText.charAt(i + 1) == 'u') {
                    i = OStringParser.readUnicode(iText, i + 2, buffer);
                    continue;
                }
                escape = true;
                buffer.append(c);
                continue;
            }
            if (c == '\'' || c == '\"') {
                if (!jumpSplitChar) {
                    jumpSplitChar = true;
                    stringChar = c;
                } else if (!escape && c == stringChar) {
                    jumpSplitChar = false;
                }
            }
            if (c == iSplitChar && !jumpSplitChar) {
                fields.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (buffer.length() == 0) {
                boolean charFound = false;
                for (int jumpIndex = 0; jumpIndex < iJumpChars.length(); ++jumpIndex) {
                    if (iJumpChars.charAt(jumpIndex) != c) continue;
                    charFound = true;
                    break;
                }
                if (charFound) continue;
            }
            buffer.append(c);
            if (!escape) continue;
            escape = false;
        }
        if (buffer.length() > 0) {
            fields.add(buffer.toString());
            buffer.setLength(0);
        }
        String[] result = new String[fields.size()];
        fields.toArray(result);
        return result;
    }

    public static int indexOfOutsideStrings(String iText, char iToFind, int iFrom, int iTo) {
        if (iTo == -1) {
            iTo = iText.length() - 1;
        }
        if (iFrom == -1) {
            iFrom = iText.length() - 1;
        }
        char stringChar = ' ';
        boolean escape = false;
        StringBuilder buffer = new StringBuilder(1024);
        int i = iFrom;
        do {
            char c = iText.charAt(i);
            if (!escape && c == '\\' && i + 1 < iText.length()) {
                if (iText.charAt(i + 1) == 'u') {
                    i = OStringParser.readUnicode(iText, i + 2, buffer);
                    continue;
                }
                escape = true;
                continue;
            }
            if (c == '\'' || c == '\"') {
                if (stringChar == ' ') {
                    stringChar = c;
                } else if (!escape && c == stringChar) {
                    stringChar = ' ';
                }
            }
            if (c == iToFind && stringChar == ' ') {
                return i;
            }
            if (!escape) continue;
            escape = false;
        } while (!(iFrom < iTo ? ++i > iTo : --i < iFrom));
        return -1;
    }

    public static int jumpWhiteSpaces(CharSequence iText, int iCurrentPosition, int iMaxPosition) {
        return OStringParser.jump(iText, iCurrentPosition, iMaxPosition, COMMON_JUMP);
    }

    public static int jump(CharSequence iText, int iCurrentPosition, int iMaxPosition, String iJumpChars) {
        if (iCurrentPosition < 0) {
            return -1;
        }
        int size = iMaxPosition > -1 ? Math.min(iMaxPosition, iText.length()) : iText.length();
        int jumpCharSize = iJumpChars.length();
        boolean found = true;
        while (iCurrentPosition < size) {
            found = false;
            char c = iText.charAt(iCurrentPosition);
            for (int jumpIndex = 0; jumpIndex < jumpCharSize; ++jumpIndex) {
                if (iJumpChars.charAt(jumpIndex) != c) continue;
                found = true;
                break;
            }
            if (!found) break;
            ++iCurrentPosition;
        }
        return iCurrentPosition >= size ? -1 : iCurrentPosition;
    }

    public static int readUnicode(String iText, int position, StringBuilder buffer) {
        StringBuilder buff = new StringBuilder(64);
        int lastPos = position + 4;
        while (position < lastPos) {
            buff.append(iText.charAt(position));
            ++position;
        }
        buffer.append((char)Integer.parseInt(buff.toString(), 16));
        return position - 1;
    }

    public static int readUnicode(char[] iText, int position, StringBuilder buffer) {
        StringBuilder buff = new StringBuilder(64);
        int lastPos = position + 4;
        while (position < lastPos) {
            buff.append(iText[position]);
            ++position;
        }
        buffer.append((char)Integer.parseInt(buff.toString(), 16));
        return position - 1;
    }

    public static String replaceAll(String iText, String iToReplace, String iReplacement) {
        if (iText == null || iText.length() <= 0 || iToReplace == null || iToReplace.length() <= 0) {
            return iText;
        }
        int pos = iText.indexOf(iToReplace);
        int lastAppend = 0;
        StringBuffer buffer = new StringBuffer(1024);
        while (pos > -1) {
            buffer.append(iText.substring(lastAppend, pos));
            buffer.append(iReplacement);
            lastAppend = pos + iToReplace.length();
            pos = iText.indexOf(iToReplace, lastAppend);
        }
        buffer.append(iText.substring(lastAppend));
        return buffer.toString();
    }

    public static boolean startsWithIgnoreCase(String iText, String iToFind) {
        if (iText.length() < iToFind.length()) {
            return false;
        }
        return iText.substring(0, iToFind.length()).equalsIgnoreCase(iToFind);
    }
}

