/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.coll;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionMultiValueAbstract;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSQLFunctionSet
extends OSQLFunctionMultiValueAbstract<Set<Object>> {
    public static final String NAME = "set";

    public OSQLFunctionSet() {
        super(NAME, 1, -1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (iParams.length > 1) {
            this.context = new HashSet();
        }
        for (Object value : iParams) {
            if (value == null) continue;
            if (iParams.length == 1 && this.context == null) {
                this.context = new HashSet();
            }
            if (value instanceof ODocument) {
                ((Set)this.context).add(value);
                continue;
            }
            OMultiValue.add(this.context, value);
        }
        return this.prepareResult((Set)this.context);
    }

    @Override
    public String getSyntax() {
        return "set(<value>*)";
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return configuredParameters.length == 1;
    }

    @Override
    public Set<Object> getResult() {
        Set res = (Set)this.context;
        this.context = null;
        return this.prepareResult(res);
    }

    @Override
    public Object mergeDistributedResult(List<Object> resultsToMerge) {
        if (this.returnDistributedResult()) {
            HashSet result = new HashSet();
            for (Object iParameter : resultsToMerge) {
                Map container = (Map)((Collection)iParameter).iterator().next();
                result.addAll((Collection)container.get("context"));
            }
            return result;
        }
        return resultsToMerge.get(0);
    }

    protected Set<Object> prepareResult(Set<Object> res) {
        if (this.returnDistributedResult()) {
            HashMap<String, Object> doc = new HashMap<String, Object>();
            doc.put("node", this.getDistributedStorageId());
            doc.put("context", this.context);
            return Collections.singleton(doc);
        }
        return res;
    }
}

