/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;

public class OSQLFunctionEncode
extends OSQLFunctionAbstract {
    public static final String NAME = "encode";
    public static final String FORMAT_BASE64 = "base64";

    public OSQLFunctionEncode() {
        super(NAME, 2, 2);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        Object candidate = iParams[0];
        String format = iParams[1].toString();
        byte[] data = null;
        if (candidate instanceof byte[]) {
            data = (byte[])candidate;
        } else if (candidate instanceof ORecordId) {
            Object rec = ((ORecordId)candidate).getRecord();
            if (rec instanceof OBlob) {
                data = ((OBlob)rec).toStream();
            }
        } else if (candidate instanceof OSerializableStream) {
            data = ((OSerializableStream)candidate).toStream();
        }
        if (data == null) {
            return null;
        }
        if (FORMAT_BASE64.equalsIgnoreCase(format)) {
            return OBase64Utils.encodeBytes(data);
        }
        throw new ODatabaseException("unknowned format :" + format);
    }

    @Override
    public String getSyntax() {
        return "encode(<binaryfield>, <format>)";
    }
}

