/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.narayana.rest.integration;

import com.arjuna.ats.arjuna.common.Uid;
import org.jboss.jbossts.star.provider.HttpResponseException;
import org.jboss.jbossts.star.util.TxStatus;
import org.jboss.jbossts.star.util.TxSupport;
import org.jboss.logging.Logger;
import org.jboss.narayana.rest.integration.ParticipantInformation;
import org.jboss.narayana.rest.integration.ParticipantsContainer;
import org.jboss.narayana.rest.integration.RecoveryManager;
import org.jboss.narayana.rest.integration.api.HeuristicType;
import org.jboss.narayana.rest.integration.api.Participant;
import org.jboss.narayana.rest.integration.api.ParticipantDeserializer;
import org.jboss.narayana.rest.integration.api.ParticipantException;
import org.jboss.narayana.rest.integration.api.ParticipantsManager;
import org.jboss.narayana.rest.integration.api.VolatileParticipant;

public final class ParticipantsManagerImpl
implements ParticipantsManager {
    private static final Logger LOG = Logger.getLogger(ParticipantsManagerImpl.class);
    private String baseUrl;

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ParticipantsManagerImpl.setBaseUrl: baseUrl=" + baseUrl));
        }
        this.baseUrl = baseUrl;
    }

    @Override
    public String enlist(String applicationId, String participantEnlistmentURL, Participant participant) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ParticipantsManagerImpl.enlist: applicationId=" + applicationId + ", participantEnlistmentURL=" + participantEnlistmentURL + ", participant=" + participant));
        }
        if (this.baseUrl == null) {
            throw new IllegalStateException("Base URL was not defined.");
        }
        String participantId = new Uid().toString();
        String participantUrl = this.getParticipantUrl(participantId, this.baseUrl);
        String participantRecoveryURL = this.enlistParticipant(participantUrl, participantEnlistmentURL);
        ParticipantInformation participantInformation = new ParticipantInformation(participantId, applicationId, participantRecoveryURL, participant);
        participantInformation.setStatus(TxStatus.TransactionActive.name());
        ParticipantsContainer.getInstance().addParticipantInformation(participantId, participantInformation);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ParticipantsManagerImpl.enlist: participant enlisted. participantUrl=" + participantUrl + ", participantInformation=" + participantInformation));
        }
        return participantId;
    }

    @Override
    public void enlistVolatileParticipant(String volatileParticipantEnlistmentURL, VolatileParticipant volatileParticipant) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ParticipantsManagerImpl.enlistVolatileParticipant: volatileParticipantEnlistmentURL=" + volatileParticipantEnlistmentURL + ", volatileParticipant=" + volatileParticipant));
        }
        if (this.baseUrl == null) {
            throw new IllegalStateException("Base URL was not defined.");
        }
        String participantId = new Uid().toString();
        String participantUrl = this.getVolatileParticipantUrl(participantId, this.baseUrl);
        this.enlistVolatileParticipant(participantUrl, volatileParticipantEnlistmentURL);
        ParticipantsContainer.getInstance().addVolatileParticipant(participantId, volatileParticipant);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ParticipantsManagerImpl.enlistVolatileParticipant: participant enlisted. participantId=" + participantId + ", participantUrl=" + participantUrl));
        }
    }

    @Override
    public void registerDeserializer(String applicationId, ParticipantDeserializer deserializer) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ParticipantsManagerImpl.registerDeserializer: applicationId=" + applicationId + ", deserializer=" + deserializer));
        }
        RecoveryManager.getInstance().registerDeserializer(applicationId, deserializer);
    }

    @Override
    public void reportHeuristic(String participantId, HeuristicType heuristicType) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ParticipantsManagerImpl.reportHeuristic: participantId=" + participantId + ", heuristicType=" + (Object)((Object)heuristicType)));
        }
        ParticipantInformation participantInformation = ParticipantsContainer.getInstance().getParticipantInformation(participantId);
        switch (heuristicType) {
            case HEURISTIC_ROLLBACK: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicRollback.name());
                break;
            }
            case HEURISTIC_COMMIT: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicCommit.name());
                break;
            }
            case HEURISTIC_HAZARD: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicHazard.name());
                break;
            }
            case HEURISTIC_MIXED: {
                participantInformation.setStatus(TxStatus.TransactionHeuristicMixed.name());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown heuristic type");
            }
        }
        RecoveryManager.getInstance().persistParticipantInformation(participantInformation);
    }

    private String enlistParticipant(String participantUrl, String participantEnlistmentURL) {
        String recoveryUrl;
        TxSupport txSupport = new TxSupport();
        String participantLinkHeader = txSupport.makeTwoPhaseAwareParticipantLinkHeader(participantUrl, participantUrl);
        try {
            recoveryUrl = txSupport.enlistParticipant(participantEnlistmentURL, participantLinkHeader);
        }
        catch (HttpResponseException e) {
            throw new ParticipantException("Failed to enlist participant", e);
        }
        return recoveryUrl;
    }

    private void enlistVolatileParticipant(String participantUrl, String volatileParticipantEnlistmentURL) {
        StringBuilder linkHeader = new StringBuilder();
        linkHeader.append("<").append(participantUrl).append(">; rel=\"").append("volatile-participant").append("\"");
        String participantLinkHeader = linkHeader.toString();
        try {
            new TxSupport().enlistVolatileParticipant(volatileParticipantEnlistmentURL, participantLinkHeader);
        }
        catch (HttpResponseException e) {
            throw new ParticipantException("Failed to enlist volatile participant", e);
        }
    }

    private String getParticipantUrl(String participantId, String baseUrl) {
        if (!baseUrl.substring(baseUrl.length() - 1).equals("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl + "rest-at-participant" + "/" + participantId;
    }

    private String getVolatileParticipantUrl(String participantId, String baseUrl) {
        if (!baseUrl.substring(baseUrl.length() - 1).equals("/")) {
            baseUrl = baseUrl + "/";
        }
        return baseUrl + "volatile-rest-at-participant" + "/" + participantId;
    }
}

