/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import com.orientechnologies.orient.object.jpa.OJPAEntityTransaction;
import com.orientechnologies.orient.object.jpa.OJPAPersistenceProvider;
import com.orientechnologies.orient.object.jpa.OJPAProperties;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;

public class OJPAEntityManager
implements EntityManager {
    private static Logger logger = Logger.getLogger(OJPAPersistenceProvider.class.getName());
    private final EntityManagerFactory emFactory;
    private final OObjectDatabaseTx database;
    private final EntityTransaction transaction;
    private final OJPAProperties properties;
    private FlushModeType flushMode = FlushModeType.AUTO;

    OJPAEntityManager(EntityManagerFactory entityManagerFactory, OJPAProperties properties) {
        this.properties = properties;
        this.emFactory = entityManagerFactory;
        this.database = new OObjectDatabaseTx(properties.getURL());
        this.database.open(properties.getUser(), properties.getPassword());
        if (properties.isEntityClasses()) {
            this.database.getEntityManager().registerEntityClasses(properties.getEntityClasses());
        }
        this.transaction = new OJPAEntityTransaction(this.database);
        if (logger.isLoggable(Level.INFO)) {
            logger.info("EntityManager created for persistence unit : " + entityManagerFactory.toString());
        }
    }

    public void persist(Object entity) {
        this.database.save(entity);
    }

    public <T> T merge(T entity) {
        throw new UnsupportedOperationException("merge");
    }

    public void remove(Object entity) {
        this.database.delete(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        ORecordId rid;
        if (primaryKey instanceof ORecordId) {
            rid = (ORecordId)primaryKey;
        } else if (primaryKey instanceof String) {
            rid = new ORecordId((String)primaryKey);
        } else if (primaryKey instanceof Number) {
            OClass cls = this.database.getMetadata().getSchema().getClass(entityClass);
            if (cls == null) {
                throw new IllegalArgumentException("Class '" + entityClass + "' is not configured in the database");
            }
            rid = new ORecordId(cls.getDefaultClusterId(), ((Number)primaryKey).longValue());
        } else {
            throw new IllegalArgumentException("PrimaryKey '" + primaryKey + "' type (" + primaryKey.getClass() + ") is not supported");
        }
        return (T)this.database.load((ORID)rid);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        throw new UnsupportedOperationException("merge");
    }

    public void flush() {
        if (this.flushMode == FlushModeType.COMMIT) {
            this.database.commit();
            if (logger.isLoggable(Level.FINEST)) {
                logger.info("EntityManager flushed. " + this.toString());
            }
        }
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    public void lock(Object entity, LockModeType lockMode) {
        throw new UnsupportedOperationException("lock");
    }

    public void refresh(Object entity) {
        this.database.load(entity);
        if (logger.isLoggable(Level.FINEST)) {
            logger.info("EntityManager refreshed. " + this.toString());
        }
    }

    public void clear() {
        if (this.flushMode == FlushModeType.COMMIT) {
            this.database.rollback();
            if (logger.isLoggable(Level.FINEST)) {
                logger.info("EntityManager cleared. " + this.toString());
            }
        }
    }

    public boolean contains(Object entity) {
        return this.database.isManaged(entity);
    }

    public Query createQuery(String qlString) {
        throw new UnsupportedOperationException("createQuery");
    }

    public Query createNamedQuery(String name) {
        throw new UnsupportedOperationException("createNamedQuery");
    }

    public Query createNativeQuery(String sqlString) {
        throw new UnsupportedOperationException("createNativeQuery");
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        throw new UnsupportedOperationException("createNativeQuery");
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        throw new UnsupportedOperationException("createNativeQuery");
    }

    public void joinTransaction() {
        throw new UnsupportedOperationException("joinTransaction");
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        throw new UnsupportedOperationException("find(Class<T>, LockModeType, Map<String, Object>)");
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        throw new UnsupportedOperationException("find(Class<T>, Object, LockModeType");
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        throw new UnsupportedOperationException("find(Class<T>, Object, LockModeType, Map<String, Object>)");
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        throw new UnsupportedOperationException("lock");
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        throw new UnsupportedOperationException("refresh");
    }

    public void refresh(Object entity, LockModeType lockMode) {
        throw new UnsupportedOperationException("refresh");
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        throw new UnsupportedOperationException("refresh");
    }

    public void detach(Object entity) {
        throw new UnsupportedOperationException("detach");
    }

    public LockModeType getLockMode(Object entity) {
        throw new UnsupportedOperationException("getLockMode");
    }

    public void setProperty(String propertyName, Object value) {
        throw new UnsupportedOperationException("setProperty");
    }

    public Map<String, Object> getProperties() {
        return this.properties.getUnmodifiableProperties();
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        throw new UnsupportedOperationException("createQuery");
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        throw new UnsupportedOperationException("createQuery");
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        throw new UnsupportedOperationException("createNamedQuery");
    }

    public <T> T unwrap(Class<T> cls) {
        throw new UnsupportedOperationException("unwrap");
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.emFactory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        throw new UnsupportedOperationException("getCriteriaBuilder");
    }

    public Metamodel getMetamodel() {
        throw new UnsupportedOperationException("getMetamodel");
    }

    public Object getDelegate() {
        return this.database;
    }

    public EntityTransaction getTransaction() {
        return this.transaction;
    }

    public void close() {
        this.database.close();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("EntityManager closed. " + this.toString());
        }
    }

    public boolean isOpen() {
        return !this.database.isClosed();
    }

    public String toString() {
        return "EntityManager for User@Database:" + this.database.getUser() + "@" + this.database.getURL() + ", " + super.toString();
    }
}

