/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.stomp;

import io.netty.channel.ChannelPipeline;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.security.cert.X509Certificate;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompException;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolLogger;
import org.apache.activemq.artemis.core.protocol.stomp.ActiveMQStompProtocolMessageBundle;
import org.apache.activemq.artemis.core.protocol.stomp.StompConnection;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrame;
import org.apache.activemq.artemis.core.protocol.stomp.StompFrameInterceptor;
import org.apache.activemq.artemis.core.protocol.stomp.StompProtocolManagerFactory;
import org.apache.activemq.artemis.core.protocol.stomp.StompSession;
import org.apache.activemq.artemis.core.protocol.stomp.StompVersions;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyServerConnection;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.impl.ServerMessageImpl;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ConnectionEntry;
import org.apache.activemq.artemis.spi.core.protocol.MessageConverter;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.protocol.SessionCallback;
import org.apache.activemq.artemis.spi.core.remoting.Acceptor;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager2;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager3;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class StompProtocolManager
extends AbstractProtocolManager<StompFrame, StompFrameInterceptor, StompConnection> {
    private static final List<String> websocketRegistryNames = Arrays.asList("v10.stomp", "v11.stomp", "v12.stomp");
    private final ActiveMQServer server;
    private final StompProtocolManagerFactory factory;
    private final Executor executor;
    private final Map<String, StompSession> transactedSessions = new HashMap<String, StompSession>();
    private final Map<Object, StompSession> sessions = new HashMap<Object, StompSession>();
    private final List<StompFrameInterceptor> incomingInterceptors;
    private final List<StompFrameInterceptor> outgoingInterceptors;

    StompProtocolManager(StompProtocolManagerFactory factory, ActiveMQServer server, List<StompFrameInterceptor> incomingInterceptors, List<StompFrameInterceptor> outgoingInterceptors) {
        this.factory = factory;
        this.server = server;
        this.executor = server.getExecutorFactory().getExecutor();
        this.incomingInterceptors = incomingInterceptors;
        this.outgoingInterceptors = outgoingInterceptors;
    }

    public boolean acceptsNoHandshake() {
        return false;
    }

    public ProtocolManagerFactory<StompFrameInterceptor> getFactory() {
        return this.factory;
    }

    public void updateInterceptors(List<BaseInterceptor> incoming, List<BaseInterceptor> outgoing) {
        this.incomingInterceptors.clear();
        this.incomingInterceptors.addAll(this.getFactory().filterInterceptors(incoming));
        this.outgoingInterceptors.clear();
        this.outgoingInterceptors.addAll(this.getFactory().filterInterceptors(outgoing));
    }

    public MessageConverter getConverter() {
        return null;
    }

    public ConnectionEntry createConnectionEntry(Acceptor acceptorUsed, Connection connection) {
        Long ttl;
        StompConnection conn = new StompConnection(acceptorUsed, connection, this, this.server.getScheduledPool(), this.server.getExecutorFactory());
        String ttlStr = (String)acceptorUsed.getConfiguration().get("connectionTtl");
        Long l = ttl = ttlStr == null ? null : Long.valueOf(ttlStr);
        if (ttl != null) {
            if (ttl > 0L) {
                return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), ttl.longValue());
            }
            throw ActiveMQStompProtocolMessageBundle.BUNDLE.negativeConnectionTTL(ttl);
        }
        ttl = this.server.getConfiguration().getConnectionTTLOverride();
        if (ttl != -1L) {
            return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), ttl.longValue());
        }
        return new ConnectionEntry((RemotingConnection)conn, null, System.currentTimeMillis(), 60000L);
    }

    public void removeHandler(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleBuffer(RemotingConnection connection, ActiveMQBuffer buffer) {
        StompConnection conn = (StompConnection)connection;
        conn.setDataReceived();
        do {
            StompFrame request;
            try {
                request = conn.decode(buffer);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorDecodingPacket(e);
                return;
            }
            if (request == null) break;
            try {
                this.invokeInterceptors(this.incomingInterceptors, request, conn);
                conn.handleFrame(request);
            }
            finally {
                this.server.getStorageManager().clearContext();
            }
        } while (conn.hasBytes());
    }

    public void addChannelHandlers(ChannelPipeline pipeline) {
    }

    public boolean isProtocol(byte[] array) {
        String frameStart = new String(array, StandardCharsets.US_ASCII);
        return frameStart.startsWith("CONNECT") || frameStart.startsWith("STOMP");
    }

    public void handshake(NettyServerConnection connection, ActiveMQBuffer buffer) {
    }

    public List<String> websocketSubprotocolIdentifiers() {
        return websocketRegistryNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(StompConnection connection, StompFrame frame) {
        if (ActiveMQServerLogger.LOGGER.isTraceEnabled()) {
            ActiveMQServerLogger.LOGGER.trace((Object)("sent " + frame));
        }
        this.invokeInterceptors(this.outgoingInterceptors, frame, connection);
        StompConnection stompConnection = connection;
        synchronized (stompConnection) {
            if (connection.isDestroyed()) {
                ActiveMQStompProtocolLogger.LOGGER.connectionClosed(connection);
                return false;
            }
            try {
                connection.physicalSend(frame);
            }
            catch (Exception e) {
                ActiveMQStompProtocolLogger.LOGGER.errorSendingFrame(e, frame);
                return false;
            }
            return true;
        }
    }

    public StompSession getSession(StompConnection connection) throws Exception {
        StompSession stompSession = this.sessions.get(connection.getID());
        if (stompSession == null) {
            stompSession = new StompSession(connection, this, this.server.getStorageManager().newContext(this.server.getExecutorFactory().getExecutor()));
            String name = UUIDGenerator.getInstance().generateStringUUID();
            ServerSession session = this.server.createSession(name, connection.getLogin(), connection.getPasscode(), 102400, (RemotingConnection)connection, true, false, false, false, null, (SessionCallback)stompSession, true, this.server.newOperationContext());
            stompSession.setServerSession(session);
            this.sessions.put(connection.getID(), stompSession);
        }
        this.server.getStorageManager().setContext(stompSession.getContext());
        return stompSession;
    }

    public StompSession getTransactedSession(StompConnection connection, String txID) throws Exception {
        StompSession stompSession = this.transactedSessions.get(txID);
        if (stompSession == null) {
            stompSession = new StompSession(connection, this, this.server.getStorageManager().newContext(this.executor));
            String name = UUIDGenerator.getInstance().generateStringUUID();
            ServerSession session = this.server.createSession(name, connection.getLogin(), connection.getPasscode(), 102400, (RemotingConnection)connection, false, false, false, false, null, (SessionCallback)stompSession, true, this.server.newOperationContext());
            stompSession.setServerSession(session);
            this.transactedSessions.put(txID, stompSession);
        }
        this.server.getStorageManager().setContext(stompSession.getContext());
        return stompSession;
    }

    public void cleanup(final StompConnection connection) {
        connection.setValid(false);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                StompSession session = (StompSession)StompProtocolManager.this.sessions.remove(connection.getID());
                if (session != null) {
                    try {
                        session.getSession().stop();
                        session.getSession().rollback(true);
                        session.getSession().close(false);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorCleaningStompConn(e);
                    }
                }
                Iterator iterator = StompProtocolManager.this.transactedSessions.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (((StompSession)entry.getValue()).getConnection() != connection) continue;
                    ServerSession serverSession = ((StompSession)entry.getValue()).getSession();
                    try {
                        serverSession.rollback(true);
                        serverSession.close(false);
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorCleaningStompConn(e);
                    }
                    iterator.remove();
                }
            }
        });
    }

    public void sendReply(final StompConnection connection, final StompFrame frame) {
        this.server.getStorageManager().afterCompleteOperations(new IOCallback(){

            public void onError(int errorCode, String errorMessage) {
                ActiveMQServerLogger.LOGGER.errorProcessingIOCallback(Integer.valueOf(errorCode), errorMessage);
                ActiveMQStompException e = new ActiveMQStompException("Error sending reply", (Throwable)ActiveMQExceptionType.createException((int)errorCode, (String)errorMessage)).setHandler(connection.getFrameHandler());
                StompFrame error = e.getFrame();
                StompProtocolManager.this.send(connection, error);
            }

            public void done() {
                StompProtocolManager.this.send(connection, frame);
            }
        });
    }

    public String getSupportedVersionsAsString() {
        String versions = "";
        for (StompVersions version : StompVersions.values()) {
            versions = versions + " v" + (Object)((Object)version);
        }
        return versions.substring(1);
    }

    public String getSupportedVersionsAsErrorVersion() {
        String versions = "";
        for (StompVersions version : StompVersions.values()) {
            versions = versions + "," + (Object)((Object)version);
        }
        return versions.substring(1);
    }

    public String getVirtualHostName() {
        return "activemq";
    }

    public boolean validateUser(String login, String passcode, X509Certificate[] certificates) {
        boolean validated = true;
        ActiveMQSecurityManager sm = this.server.getSecurityManager();
        if (sm != null && this.server.getConfiguration().isSecurityEnabled()) {
            validated = sm instanceof ActiveMQSecurityManager3 ? ((ActiveMQSecurityManager3)sm).validateUser(login, passcode, certificates) != null : (sm instanceof ActiveMQSecurityManager2 ? ((ActiveMQSecurityManager2)sm).validateUser(login, passcode, certificates) : sm.validateUser(login, passcode));
        }
        return validated;
    }

    public ServerMessageImpl createServerMessage() {
        return new ServerMessageImpl(this.server.getStorageManager().generateID(), 512);
    }

    public void commitTransaction(StompConnection connection, String txID) throws Exception {
        StompSession session = this.getTransactedSession(connection, txID);
        if (session == null) {
            throw new ActiveMQStompException(connection, "No transaction started: " + txID);
        }
        this.transactedSessions.remove(txID);
        session.getSession().commit();
    }

    public void abortTransaction(StompConnection connection, String txID) throws Exception {
        StompSession session = this.getTransactedSession(connection, txID);
        if (session == null) {
            throw new ActiveMQStompException(connection, "No transaction started: " + txID);
        }
        this.transactedSessions.remove(txID);
        session.getSession().rollback(false);
    }

    public void createSubscription(StompConnection connection, String subscriptionID, String durableSubscriptionName, String destination, String selector, String ack, boolean noLocal) throws Exception {
        StompSession stompSession = this.getSession(connection);
        stompSession.setNoLocal(noLocal);
        if (stompSession.containsSubscription(subscriptionID)) {
            throw new ActiveMQStompException(connection, "There already is a subscription for: " + subscriptionID + ". Either use unique subscription IDs or do not create multiple subscriptions for the same destination");
        }
        long consumerID = this.server.getStorageManager().generateID();
        stompSession.addSubscription(consumerID, subscriptionID, connection.getClientID(), durableSubscriptionName, destination, selector, ack);
    }

    public void unsubscribe(StompConnection connection, String subscriptionID, String durableSubscriberName) throws Exception {
        StompSession stompSession = this.getSession(connection);
        boolean unsubscribed = stompSession.unsubscribe(subscriptionID, durableSubscriberName, connection.getClientID());
        if (!unsubscribed) {
            throw new ActiveMQStompException(connection, "Cannot unsubscribe as no subscription exists for id: " + subscriptionID);
        }
    }

    public void acknowledge(StompConnection connection, String messageID, String subscriptionID) throws Exception {
        StompSession stompSession = this.getSession(connection);
        stompSession.acknowledge(messageID, subscriptionID);
    }

    public void beginTransaction(StompConnection connection, String txID) throws Exception {
        ActiveMQServerLogger.LOGGER.stompBeginTX(txID);
        if (this.transactedSessions.containsKey(txID)) {
            ActiveMQServerLogger.LOGGER.stompErrorTXExists(txID);
            throw new ActiveMQStompException(connection, "Transaction already started: " + txID);
        }
        this.getTransactedSession(connection, txID);
    }

    public boolean destinationExists(String destination) {
        return this.server.getPostOffice().getAddresses().contains(SimpleString.toSimpleString((String)destination));
    }

    public ActiveMQServer getServer() {
        return this.server;
    }
}

