/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.mod_cluster.undertow.metric;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.LongAdder;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractSourceConduit;
import org.xnio.conduits.SourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public class BytesReceivedStreamSourceConduit
extends AbstractSourceConduit
implements StreamSourceConduit {
    private final StreamSourceConduit next;
    private static final LongAdder bytesReceived = new LongAdder();

    public BytesReceivedStreamSourceConduit(StreamSourceConduit next) {
        super((SourceConduit)next);
        this.next = next;
    }

    public BytesReceivedStreamSourceConduit(StreamSourceConduit next, long alreadyReceivedBytes) {
        super((SourceConduit)next);
        this.next = next;
        bytesReceived.add(alreadyReceivedBytes);
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long bytes = this.next.transferTo(position, count, target);
        bytesReceived.add(bytes);
        return bytes;
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long bytes = this.next.transferTo(count, throughBuffer, target);
        bytesReceived.add(bytes);
        return bytes;
    }

    public int read(ByteBuffer dst) throws IOException {
        int bytes = this.next.read(dst);
        bytesReceived.add(bytes);
        return bytes;
    }

    public long read(ByteBuffer[] dsts, int offs, int len) throws IOException {
        long bytes = this.next.read(dsts, offs, len);
        bytesReceived.add(bytes);
        return bytes;
    }

    public static long getBytesReceived() {
        return bytesReceived.longValue();
    }
}

