/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.MSCRunnable;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceName;

final class ServiceRegistrationImpl
implements Dependency {
    private final ServiceContainerImpl container;
    private final ServiceName name;
    private final IdentityHashSet<Dependent> dependents = new IdentityHashSet(0);
    private ServiceControllerImpl<?> instance;
    private int demandedByCount;

    ServiceRegistrationImpl(ServiceContainerImpl container, ServiceName name) {
        this.container = container;
        this.name = name;
    }

    IdentityHashSet<Dependent> getDependents() {
        return this.dependents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDependent(Dependent dependent) {
        boolean leavingRestState;
        ServiceControllerImpl<?> instance;
        Object object;
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(dependent));
        ArrayList<MSCRunnable> tasks = new ArrayList<MSCRunnable>();
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            object = this.dependents;
            synchronized (object) {
                if (this.dependents.contains(dependent)) {
                    throw new IllegalStateException("Dependent already exists on this registration");
                }
            }
            instance = this.instance;
            if (instance == null) {
                dependent.immediateDependencyUnavailable(this.name);
                object = this.dependents;
                synchronized (object) {
                    this.dependents.add(dependent);
                }
                return;
            }
            object = instance;
            synchronized (object) {
                leavingRestState = instance.isStableRestState();
                IdentityHashSet<Dependent> identityHashSet = this.dependents;
                synchronized (identityHashSet) {
                    this.dependents.add(dependent);
                }
                if (!instance.isInstallationCommitted()) {
                    dependent.immediateDependencyUnavailable(this.name);
                    return;
                }
                instance.newDependent(this.name, dependent);
                instance.addAsyncTasks(tasks.size() + 1);
                instance.updateStabilityState(leavingRestState);
            }
        }
        instance.doExecute(tasks);
        tasks.clear();
        serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            object = instance;
            synchronized (object) {
                leavingRestState = instance.isStableRestState();
                instance.removeAsyncTask();
                instance.transition(tasks);
                instance.addAsyncTasks(tasks.size());
                instance.updateStabilityState(leavingRestState);
            }
        }
        instance.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDependent(Dependent dependent) {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(dependent));
        IdentityHashSet<Dependent> identityHashSet = this.dependents;
        synchronized (identityHashSet) {
            this.dependents.remove(dependent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInstance(ServiceControllerImpl<?> instance) throws DuplicateServiceException {
        assert (instance != null);
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(instance));
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (this.instance != null) {
                throw new DuplicateServiceException(String.format("Service %s is already registered", this.name.getCanonicalName()));
            }
            this.instance = instance;
            if (this.demandedByCount > 0) {
                instance.addDemands(this.demandedByCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearInstance(ServiceControllerImpl<?> oldInstance) {
        assert (!Thread.holdsLock(this));
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            ServiceControllerImpl<?> instance = this.instance;
            if (instance != oldInstance) {
                return;
            }
            this.instance = null;
        }
    }

    ServiceContainerImpl getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependentStopped() {
        ServiceControllerImpl<?> instance;
        assert (!Thread.holdsLock(this));
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            instance = this.instance;
        }
        if (instance != null) {
            instance.dependentStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() throws IllegalStateException {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            ServiceControllerImpl<?> instance = this.instance;
            if (instance == null) {
                throw new IllegalStateException("Service is not installed");
            }
            return instance.getValue();
        }
    }

    @Override
    public ServiceName getName() {
        return this.name;
    }

    @Override
    public ServiceControllerImpl<?> getDependencyController() {
        return this.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependentStarted() {
        assert (!Thread.holdsLock(this));
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (this.instance != null) {
                this.instance.dependentStarted();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDemand() {
        ServiceControllerImpl<?> instance;
        assert (!Thread.holdsLock(this));
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            ++this.demandedByCount;
            instance = this.instance;
        }
        if (instance != null) {
            instance.addDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDemand() {
        ServiceControllerImpl<?> instance;
        assert (!Thread.holdsLock(this));
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            --this.demandedByCount;
            instance = this.instance;
        }
        if (instance != null) {
            instance.removeDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceControllerImpl<?> getInstance() {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            return this.instance;
        }
    }
}

