/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.wildfly.clustering.dispatcher.Command;
import org.wildfly.clustering.dispatcher.CommandDispatcher;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.Evictor;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.web.infinispan.logging.InfinispanWebLogger;
import org.wildfly.clustering.web.infinispan.session.Scheduler;
import org.wildfly.clustering.web.infinispan.session.SessionEvictionCommand;
import org.wildfly.clustering.web.infinispan.session.SessionEvictionContext;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;

public class SessionEvictionScheduler
implements Scheduler,
SessionEvictionContext {
    private final Set<String> evictionQueue = new LinkedHashSet<String>();
    private final Evictor<String> evictor;
    private final Batcher<TransactionBatch> batcher;
    private final CommandDispatcher<SessionEvictionContext> dispatcher;
    private final int maxSize;

    public SessionEvictionScheduler(String name, Evictor<String> evictor, Batcher<TransactionBatch> batcher, CommandDispatcherFactory dispatcherFactory, int maxSize) {
        this.evictor = evictor;
        this.batcher = batcher;
        this.dispatcher = dispatcherFactory.createCommandDispatcher((Object)name, (Object)this);
        this.maxSize = maxSize;
    }

    @Override
    public Evictor<String> getEvictor() {
        return this.evictor;
    }

    @Override
    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(String sessionId) {
        Set<String> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(String sessionId, ImmutableSessionMetaData metaData) {
        Set<String> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.add(sessionId);
            if (this.evictionQueue.size() > this.maxSize) {
                Iterator<String> sessions = this.evictionQueue.iterator();
                try {
                    this.dispatcher.submitOnCluster((Command)new SessionEvictionCommand(sessions.next()), new Node[0]);
                    sessions.remove();
                }
                catch (Exception e) {
                    InfinispanWebLogger.ROOT_LOGGER.failedToPassivateSession(e, sessionId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Locality locality) {
        Set<String> set = this.evictionQueue;
        synchronized (set) {
            Iterator<String> sessions = this.evictionQueue.iterator();
            while (sessions.hasNext() && !Thread.currentThread().isInterrupted()) {
                String sessionId = sessions.next();
                if (locality.isLocal((Object)sessionId)) continue;
                sessions.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Set<String> set = this.evictionQueue;
        synchronized (set) {
            this.evictionQueue.clear();
        }
        this.dispatcher.close();
    }
}

