/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.service;

import java.util.function.Consumer;
import org.infinispan.configuration.cache.Configuration;
import org.jboss.as.clustering.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.infinispan.spi.service.ConfigurationBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class TemplateConfigurationBuilder
implements CapabilityServiceBuilder<Configuration> {
    private final CapabilityServiceBuilder<Configuration> builder;
    private final String containerName;
    private final String templateCacheName;
    private volatile ValueDependency<Configuration> template;

    public TemplateConfigurationBuilder(ServiceName name, String containerName, String cacheName, String templateCacheName) {
        this(name, containerName, cacheName, templateCacheName, builder -> {});
    }

    public TemplateConfigurationBuilder(ServiceName name, String containerName, String cacheName, String templateCacheName, Consumer<org.infinispan.configuration.cache.ConfigurationBuilder> templateConsumer) {
        Consumer<org.infinispan.configuration.cache.ConfigurationBuilder> consumer = builder -> builder.read((Configuration)this.template.getValue());
        this.builder = new ConfigurationBuilder(name, containerName, cacheName, consumer.andThen(templateConsumer));
        this.containerName = containerName;
        this.templateCacheName = templateCacheName;
    }

    public ServiceName getServiceName() {
        return this.builder.getServiceName();
    }

    public Builder<Configuration> configure(CapabilityServiceSupport support) {
        this.template = new InjectedValueDependency(InfinispanCacheRequirement.CONFIGURATION.getServiceName(support, this.containerName, this.templateCacheName), Configuration.class);
        this.builder.configure(support);
        return this;
    }

    public ServiceBuilder<Configuration> build(ServiceTarget target) {
        return this.template.register(this.builder.build(target));
    }
}

