/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OVariableParserListener;

public class OVariableParser {
    public static Object resolveVariables(String iText, String iBegin, String iEnd, OVariableParserListener iListener) {
        return OVariableParser.resolveVariables(iText, iBegin, iEnd, iListener, null);
    }

    public static Object resolveVariables(String iText, String iBegin, String iEnd, OVariableParserListener iListener, Object iDefaultValue) {
        if (iListener == null) {
            throw new IllegalArgumentException("Missed VariableParserListener listener");
        }
        int beginPos = iText.lastIndexOf(iBegin);
        if (beginPos == -1) {
            return iText;
        }
        int endPos = iText.indexOf(iEnd, beginPos + 1);
        if (endPos == -1) {
            return iText;
        }
        String pre = iText.substring(0, beginPos);
        String var = iText.substring(beginPos + iBegin.length(), endPos);
        String post = iText.substring(endPos + iEnd.length());
        Object resolved = iListener.resolve(var);
        if (resolved == null) {
            if (iDefaultValue == null) {
                OLogManager.instance().info(null, "[OVariableParser.resolveVariables] Error on resolving property: %s", var);
            } else {
                resolved = iDefaultValue;
            }
        }
        if (pre.length() > 0 || post.length() > 0) {
            String path = pre + (resolved != null ? resolved.toString() : "") + post;
            return OVariableParser.resolveVariables(path, iBegin, iEnd, iListener);
        }
        return resolved;
    }
}

