/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractDelegate;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.Map;

public abstract class OIndexTxAware<T>
extends OIndexAbstractDelegate<T> {
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    protected ODatabaseDocumentInternal database;

    public OIndexTxAware(ODatabaseDocumentInternal iDatabase, OIndex<T> iDelegate) {
        super(iDelegate);
        this.database = iDatabase;
    }

    @Override
    public long getSize() {
        long tot = this.delegate.getSize();
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges != null) {
            if (indexChanges.cleared) {
                tot = 0L;
            }
            for (Map.Entry entry : indexChanges.changesPerKey.entrySet()) {
                for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : ((OTransactionIndexChangesPerKey)entry.getValue()).entries) {
                    if (e.operation != OTransactionIndexChanges.OPERATION.REMOVE || e.value != null) continue;
                    --tot;
                }
            }
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : indexChanges.nullKeyChanges.entries) {
                if (e.operation != OTransactionIndexChanges.OPERATION.REMOVE || e.value != null) continue;
                --tot;
            }
        }
        return tot;
    }

    @Override
    public OIndexTxAware<T> put(Object iKey, OIdentifiable iValue) {
        this.checkForKeyType(iKey);
        ORID rid = iValue.getIdentity();
        if (!rid.isValid()) {
            if (iValue instanceof ORecord) {
                ((ORecord)iValue).save();
            } else {
                throw new IllegalArgumentException("Cannot store non persistent RID as index value for key '" + iKey + "'");
            }
        }
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.PUT, iKey, iValue);
        return this;
    }

    public OIndexTxAware<T> putOnlyClientTrack(Object iKey, OIdentifiable iValue) {
        ORID rid = iValue.getIdentity();
        if (!rid.isValid()) {
            if (iValue instanceof ORecord) {
                ((ORecord)iValue).save();
            } else {
                throw new IllegalArgumentException("Cannot store non persistent RID as index value for key '" + iKey + "'");
            }
        }
        ((OTransactionRealAbstract)this.database.getTransaction()).addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.PUT, iKey, iValue, true);
        return this;
    }

    @Override
    public boolean remove(Object key) {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, key, null);
        return true;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, iKey, iRID);
        return true;
    }

    public boolean removeOnlyClientTrack(Object iKey, OIdentifiable iRID) {
        ((OTransactionRealAbstract)this.database.getTransaction()).addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, iKey, iRID, true);
        return true;
    }

    @Override
    public OIndexTxAware<T> clear() {
        this.database.getTransaction().addIndexEntry(this.delegate, super.getName(), OTransactionIndexChanges.OPERATION.CLEAR, null, null);
        return this;
    }

    @Override
    public Object getFirstKey() {
        OTransactionIndexChangesPerKey changesPerKey;
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return this.delegate.getFirstKey();
        }
        Object indexFirstKey = indexChanges.cleared ? null : this.delegate.getFirstKey();
        Object firstKey = indexChanges.getFirstKey();
        do {
            changesPerKey = indexChanges.getChangesPerKey(firstKey);
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry indexEntry : changesPerKey.entries) {
                if (indexEntry.operation.equals((Object)OTransactionIndexChanges.OPERATION.REMOVE)) {
                    firstKey = null;
                    continue;
                }
                firstKey = changesPerKey.key;
            }
            if (changesPerKey.key.equals(indexFirstKey)) {
                indexFirstKey = firstKey;
            }
            if (firstKey == null) continue;
            if (indexFirstKey != null && ((Comparable)indexFirstKey).compareTo(firstKey) < 0) {
                return indexFirstKey;
            }
            return firstKey;
        } while ((firstKey = indexChanges.getHigherKey(changesPerKey.key)) != null);
        return indexFirstKey;
    }

    @Override
    public Object getLastKey() {
        OTransactionIndexChangesPerKey changesPerKey;
        OTransactionIndexChanges indexChanges = this.database.getTransaction().getIndexChanges(this.delegate.getName());
        if (indexChanges == null) {
            return this.delegate.getLastKey();
        }
        Object indexLastKey = indexChanges.cleared ? null : this.delegate.getLastKey();
        Object lastKey = indexChanges.getLastKey();
        do {
            changesPerKey = indexChanges.getChangesPerKey(lastKey);
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry indexEntry : changesPerKey.entries) {
                if (indexEntry.operation.equals((Object)OTransactionIndexChanges.OPERATION.REMOVE)) {
                    lastKey = null;
                    continue;
                }
                lastKey = changesPerKey.key;
            }
            if (changesPerKey.key.equals(indexLastKey)) {
                indexLastKey = lastKey;
            }
            if (lastKey == null) continue;
            if (indexLastKey != null && ((Comparable)indexLastKey).compareTo(lastKey) > 0) {
                return indexLastKey;
            }
            return lastKey;
        } while ((lastKey = indexChanges.getLowerKey(changesPerKey.key)) != null);
        return indexLastKey;
    }

    protected Object enhanceCompositeKey(Object key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        int keySize = this.getDefinition().getParamCount();
        if (keySize != 1 && compositeKey.getKeys().size() != keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return fullKey;
        }
        return key;
    }

    protected Object enhanceToCompositeKeyBetweenAsc(Object keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    protected Object enhanceFromCompositeKeyBetweenAsc(Object keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    protected Object enhanceToCompositeKeyBetweenDesc(Object keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    protected Object enhanceFromCompositeKeyBetweenDesc(Object keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    public static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

