/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OLiveQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.IOException;
import java.util.Arrays;

public class OStreamSerializerAnyStreamable
implements OStreamSerializer {
    private static final String SCRIPT_COMMAND_CLASS = "s";
    private static final byte[] SCRIPT_COMMAND_CLASS_ASBYTES = "s".getBytes();
    private static final String SQL_COMMAND_CLASS = "c";
    private static final byte[] SQL_COMMAND_CLASS_ASBYTES = "c".getBytes();
    private static final String QUERY_COMMAND_CLASS = "q";
    private static final byte[] QUERY_COMMAND_CLASS_ASBYTES = "q".getBytes();
    public static final OStreamSerializerAnyStreamable INSTANCE = new OStreamSerializerAnyStreamable();
    public static final String NAME = "at";

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        int classNameSize = OBinaryProtocol.bytes2int(iStream);
        if (classNameSize <= 0) {
            String message = "Class signature not found in ANY element: " + Arrays.toString(iStream);
            OLogManager.instance().error((Object)this, message, new Object[0]);
            throw new OSerializationException(message);
        }
        String className = new String(iStream, 4, classNameSize, "UTF-8");
        try {
            OSerializableStream stream = className.equalsIgnoreCase(QUERY_COMMAND_CLASS) ? new OSQLSynchQuery() : (className.equalsIgnoreCase(SQL_COMMAND_CLASS) ? new OCommandSQL() : (className.equalsIgnoreCase(SCRIPT_COMMAND_CLASS) ? new OCommandScript() : (OSerializableStream)Class.forName(className).newInstance()));
            return stream.fromStream(OArrays.copyOfRange(iStream, 4 + classNameSize, iStream.length));
        }
        catch (Exception e) {
            String message = "Error on unmarshalling content. Class: " + className;
            OLogManager.instance().error((Object)this, message, e, new Object[0]);
            throw OException.wrapException(new OSerializationException(message), e);
        }
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        if (!(iObject instanceof OSerializableStream)) {
            throw new OSerializationException("Cannot serialize the object [" + iObject.getClass() + ":" + iObject + "] since it does not implement the OSerializableStream interface");
        }
        OSerializableStream stream = (OSerializableStream)iObject;
        Object className = iObject instanceof OLiveQuery ? iObject.getClass().getName().getBytes("UTF-8") : (iObject instanceof OSQLSynchQuery ? QUERY_COMMAND_CLASS_ASBYTES : (iObject instanceof OCommandSQL ? SQL_COMMAND_CLASS_ASBYTES : (iObject instanceof OCommandScript ? SCRIPT_COMMAND_CLASS_ASBYTES : (Object)(iObject == null ? null : iObject.getClass().getName().getBytes("UTF-8")))));
        byte[] objectContent = stream.toStream();
        byte[] result = new byte[4 + ((byte[])className).length + objectContent.length];
        System.arraycopy(OBinaryProtocol.int2bytes(((byte[])className).length), 0, result, 0, 4);
        System.arraycopy(className, 0, result, 4, ((byte[])className).length);
        System.arraycopy(objectContent, 0, result, 4 + ((byte[])className).length, objectContent.length);
        return result;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

