/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver;

import java.lang.invoke.MethodHandle;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.security.SubjectFactory;
import org.wildfly.extension.nosql.driver.Configuration;
import org.wildfly.nosql.common.MethodHandleBuilder;
import org.wildfly.nosql.common.NoSQLLogger;

public class OrientInteraction {
    private final Configuration configuration;
    private final Class oPartitionedDatabasePool;
    private MethodHandle oPartitionedDatabasePoolCtorMethod;
    private MethodHandle oPartitionedDatabasePoolDefaultSizeCtorMethod;
    private MethodHandle oPartitionedDatabasePoolCloseMethod;
    private volatile SubjectFactory subjectFactory;

    public OrientInteraction(Configuration configuration) {
        this.configuration = configuration;
        MethodHandleBuilder methodHandleBuilder = new MethodHandleBuilder();
        methodHandleBuilder.classLoader(ModuleIdentifier.fromString((String)configuration.getModuleName()));
        this.oPartitionedDatabasePool = methodHandleBuilder.className("com.orientechnologies.orient.core.db.OPartitionedDatabasePool").getTargetClass();
        this.oPartitionedDatabasePoolCtorMethod = methodHandleBuilder.declaredConstructor(new Class[]{String.class, String.class, String.class, Integer.TYPE, Integer.TYPE});
        this.oPartitionedDatabasePoolDefaultSizeCtorMethod = methodHandleBuilder.declaredConstructor(new Class[]{String.class, String.class, String.class});
        this.oPartitionedDatabasePoolCloseMethod = methodHandleBuilder.method("close", new Class[0]);
        methodHandleBuilder.className("com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal");
        MethodHandle oDatabaseRecordThreadLocalInstanceField = methodHandleBuilder.staticField("INSTANCE");
        MethodHandle isDefinedMethod = methodHandleBuilder.method("isDefined", new Class[0]);
        try {
            isDefinedMethod.invoke(oDatabaseRecordThreadLocalInstanceField.invoke());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("could not reference " + methodHandleBuilder.getTargetClass().getName() + " INSTANCE field", throwable);
        }
    }

    public void subjectFactory(SubjectFactory subjectFactory) {
        this.subjectFactory = subjectFactory;
    }

    <T> T getDatabasePool() {
        String username = null;
        String password = null;
        if (this.configuration.getSecurityDomain() != null && this.subjectFactory != null) {
            try {
                Subject subject = this.subjectFactory.createSubject(this.configuration.getSecurityDomain());
                Set<PasswordCredential> passwordCredentials = subject.getPrivateCredentials(PasswordCredential.class);
                PasswordCredential passwordCredential = passwordCredentials.iterator().next();
                username = passwordCredential.getUserName();
                password = new String(passwordCredential.getPassword());
            }
            catch (Throwable problem) {
                if (NoSQLLogger.ROOT_LOGGER.isTraceEnabled()) {
                    NoSQLLogger.ROOT_LOGGER.tracef(problem, "could not create subject for security domain '%s', user '%s', with '%s'", (Object)this.configuration.getSecurityDomain(), username, (Object)this.configuration.getDatabaseUrl());
                }
                throw problem;
            }
        }
        try {
            if (this.configuration.getMaxPartitionSize() > 0 || this.configuration.getMaxPoolSize() > 0) {
                return (T)this.oPartitionedDatabasePoolCtorMethod.invoke(this.configuration.getDatabaseUrl(), username, password, this.configuration.getMaxPartitionSize(), this.configuration.getMaxPoolSize());
            }
            return (T)this.oPartitionedDatabasePoolDefaultSizeCtorMethod.invoke(this.configuration.getDatabaseUrl(), username, password);
        }
        catch (Throwable throwable) {
            password = null;
            username = null;
            throw new RuntimeException("could not create partitioned database connection pool for " + this.configuration.getDatabaseUrl() + " " + username, throwable);
        }
    }

    void close(Object databasePool) throws Throwable {
        if (databasePool != null) {
            this.oPartitionedDatabasePoolCloseMethod.invoke(databasePool);
        }
    }

    public Class getDatabasePoolClass() {
        return this.oPartitionedDatabasePool;
    }
}

