/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.discovery;

import java.util.Collection;
import java.util.Map;
import org.wildfly.discovery.AttributeValue;
import org.wildfly.discovery.FilterSpec;

public final class NotFilterSpec
extends FilterSpec {
    private final FilterSpec child;

    NotFilterSpec(FilterSpec child) {
        this.child = child;
    }

    @Override
    public boolean matchesSimple(Map<String, AttributeValue> attributes) {
        return !this.child.matchesSimple(attributes);
    }

    @Override
    public boolean matchesMulti(Map<String, ? extends Collection<AttributeValue>> attributes) {
        return !this.child.matchesMulti(attributes);
    }

    @Override
    public boolean mayMatch(Collection<String> attributeNames) {
        return this.child.mayNotMatch(attributeNames);
    }

    @Override
    public boolean mayNotMatch(Collection<String> attributeNames) {
        return this.child.mayMatch(attributeNames);
    }

    @Override
    public <P, R, E extends Exception> R accept(FilterSpec.Visitor<P, R, E> visitor, P parameter) throws E {
        return visitor.handle(this, parameter);
    }

    public FilterSpec getChild() {
        return this.child;
    }

    @Override
    void toString(StringBuilder builder) {
        builder.append('(').append('!');
        this.child.toString(builder);
        builder.append(')');
    }
}

