/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.cli.util.StrictSizeTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DeploymentInfoHandler
extends BaseOperationCommand {
    private static final String ADDED = "added";
    private static final String ENABLED = "ENABLED";
    private static final String NAME = "NAME";
    private static final String PERSISTENT = "PERSISTENT";
    private static final String RUNTIME_NAME = "RUNTIME-NAME";
    private static final String NOT_ADDED = "not added";
    private static final String N_A = "n/a";
    private static final String SERVER_GROUP = "SERVER-GROUP";
    private static final String STATE = "STATE";
    private static final String STATUS = "STATUS";
    private final ArgumentWithValue name = new ArgumentWithValue((CommandHandlerWithArguments)this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public Collection<String> getAllCandidates(CommandContext ctx) {
            return Util.getDeployments(ctx.getModelControllerClient());
        }
    }), "--name");
    private final ArgumentWithValue serverGroup = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public Collection<String> getAllCandidates(CommandContext ctx) {
            return DeploymentInfoHandler.this.sgChildrenResourcesPermission.getAllowedOn(ctx);
        }
    }), "--server-group"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };
    private List<String> addedServerGroups;
    private List<String> otherServerGroups;
    private PerNodeOperationAccess sgChildrenResourcesPermission;

    public DeploymentInfoHandler(CommandContext ctx) {
        super(ctx, "deployment-info", true);
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.sgChildrenResourcesPermission = new PerNodeOperationAccess(ctx, "server-group", null, "read-children-resources");
        return AccessRequirementBuilder.Factory.create(ctx).any().standalone().any().operation("read-children-resources").operation("deployment=?", "read-resource").parent().parent().domain().any().all().operation("validate-address").operation("deployment=?", "read-resource").serverGroupOperation("deployment=?", "read-resource").parent().all().operation("read-children-resources").requirement(this.sgChildrenResourcesPermission).parent().parent().parent().build();
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        if (ctx.isDomainMode() && !this.name.isPresent(parsedCmd) && !this.serverGroup.isPresent(parsedCmd)) {
            throw new CommandFormatException("Either " + this.name.getFullName() + " or " + this.serverGroup.getFullName() + " is required.");
        }
        String deploymentName = this.name.getValue(parsedCmd);
        ModelNode request = new ModelNode();
        if (ctx.isDomainMode()) {
            List<String> serverGroups = Util.getServerGroups(ctx.getModelControllerClient());
            this.addedServerGroups = null;
            this.otherServerGroups = null;
            String serverGroupName = this.serverGroup.getValue(parsedCmd);
            if (serverGroupName == null) {
                ModelNode response;
                if (deploymentName == null || deploymentName.indexOf(42) >= 0) {
                    throw new CommandFormatException("If " + this.serverGroup.getFullName() + " is not specified, " + this.name.getFullName() + " must be set to a specific deployment name, " + "wildcards are allowed only when " + this.serverGroup.getFullName() + " is provided.");
                }
                ModelNode validateRequest = new ModelNode();
                validateRequest.get("operation").set("composite");
                validateRequest.get("address").setEmptyList();
                ModelNode steps = validateRequest.get("steps");
                for (String serverGroup : serverGroups) {
                    ModelNode step = new ModelNode();
                    step.get("address").setEmptyList();
                    step.get("operation").set("validate-address");
                    ModelNode value = step.get("value");
                    value.add("server-group", serverGroup);
                    value.add("deployment", deploymentName);
                    steps.add(step);
                }
                ModelControllerClient client = ctx.getModelControllerClient();
                try {
                    response = client.execute(validateRequest);
                }
                catch (IOException e) {
                    throw new CommandFormatException("Failed to query server groups for deployment " + deploymentName, e);
                }
                if (!response.hasDefined("result")) {
                    throw new CommandFormatException("The validation response came back w/o result: " + response);
                }
                ModelNode result = response.get("result");
                if (result.hasDefined("domain-results")) {
                    result = result.get("domain-results");
                }
                List stepResponses = result.asPropertyList();
                for (int i = 0; i < serverGroups.size(); ++i) {
                    Property prop = (Property)stepResponses.get(i);
                    ModelNode stepResponse = prop.getValue();
                    if (stepResponse.has(prop.getName())) {
                        stepResponse = stepResponse.get(prop.getName());
                    }
                    if (stepResponse.hasDefined("result")) {
                        ModelNode stepResult = stepResponse.get("result");
                        if (stepResult.hasDefined("valid") && stepResult.get("valid").asBoolean()) {
                            if (this.addedServerGroups == null) {
                                this.addedServerGroups = new ArrayList<String>();
                            }
                            this.addedServerGroups.add(serverGroups.get(i));
                            continue;
                        }
                        if (this.otherServerGroups == null) {
                            this.otherServerGroups = new ArrayList<String>();
                        }
                        this.otherServerGroups.add(serverGroups.get(i));
                        continue;
                    }
                    if (this.otherServerGroups == null) {
                        this.otherServerGroups = new ArrayList<String>();
                    }
                    this.otherServerGroups.add(serverGroups.get(i));
                }
                request.get("operation").set("composite");
                request.get("address").setEmptyList();
                steps = request.get("steps");
                ModelNode step = new ModelNode();
                ModelNode address = step.get("address");
                address.add("deployment", deploymentName);
                step.get("operation").set("read-resource");
                steps.add(step);
                if (this.addedServerGroups != null) {
                    for (String serverGroup : this.addedServerGroups) {
                        step = new ModelNode();
                        address = step.get("address");
                        address.add("server-group", serverGroup);
                        address.add("deployment", deploymentName);
                        step.get("operation").set("read-resource");
                        steps.add(step);
                    }
                }
            } else {
                if (serverGroupName.indexOf(42) >= 0) {
                    throw new CommandFormatException("Wildcards are not allowed here, please give a valid server-group name.");
                }
                request.get("operation").set("composite");
                request.get("address").setEmptyList();
                ModelNode steps = request.get("steps");
                ModelNode step = new ModelNode();
                step.get("operation").set("read-children-resources");
                step.get("child-type").set("deployment");
                step.get("include-runtime").set("true");
                steps.add(step);
                step = new ModelNode();
                step.get("operation").set("read-children-resources");
                step.get("address").add("server-group", serverGroupName);
                step.get("child-type").set("deployment");
                step.get("include-runtime").set("true");
                steps.add(step);
            }
        } else if (deploymentName == null || deploymentName.indexOf(42) >= 0) {
            request.get("operation").set("read-children-resources");
            request.get("child-type").set("deployment");
            request.get("include-runtime").set("true");
        } else {
            ModelNode address = request.get("address");
            address.add("deployment", deploymentName);
            request.get("operation").set("read-resource");
            request.get("include-runtime").set(true);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleResponse(CommandContext ctx, ModelNode response, boolean composite) throws CommandFormatException {
        try {
            if (!response.hasDefined("result")) {
                throw new CommandFormatException("The operation response came back w/o result: " + response);
            }
            ModelNode result = response.get("result");
            if (ctx.isDomainMode()) {
                Iterator steps;
                if (result.hasDefined("domain-results")) {
                    result = result.get("domain-results");
                }
                if (!(steps = result.asPropertyList().iterator()).hasNext()) {
                    throw new CommandFormatException("Response for the main resource info of the deployment is missing: " + result);
                }
                ModelNode step = ((Property)steps.next()).getValue();
                if (step.has("step-1")) {
                    step = step.get("step-1");
                }
                if (!step.has("result")) {
                    throw new CommandFormatException("Failed to read the main resource info of the deployment: " + Util.getFailureDescription(step));
                }
                ModelNode stepResponse = step.get("result");
                if (this.serverGroup.isPresent(ctx.getParsedCommandLine())) {
                    step = result.get("step-1");
                    if (!step.isDefined()) {
                        throw new CommandFormatException("No step outcome for deployment resources (step-1): " + result);
                    }
                    ModelNode allDeployments = step.get("result");
                    if (!allDeployments.isDefined()) {
                        throw new CommandFormatException("No result for deployment resources (step-1): " + result);
                    }
                    step = result.get("step-2");
                    if (!step.isDefined()) {
                        throw new CommandFormatException("No step outcome for server-group deployment resources (step-2): " + result);
                    }
                    ModelNode sgDeployments = step.get("result");
                    if (!sgDeployments.isDefined()) {
                        throw new CommandFormatException("No result for server-group deployment resources (step-2): " + result);
                    }
                    String deploymentName = this.name.getValue(ctx.getParsedCommandLine());
                    Pattern pattern = Pattern.compile(Util.wildcardToJavaRegex(deploymentName == null ? "*" : deploymentName));
                    SimpleTable table = new SimpleTable(new String[]{NAME, RUNTIME_NAME, STATE}, ctx.getTerminalWidth());
                    for (String name : allDeployments.keys()) {
                        if (!pattern.matcher(name).matches()) continue;
                        if (sgDeployments.hasDefined(name)) {
                            ModelNode node = sgDeployments.get(name);
                            table.addLine(node.get("name").asString(), node.get("runtime-name").asString(), node.get("enabled").asBoolean() ? "enabled" : ADDED);
                            continue;
                        }
                        ModelNode resource = allDeployments.get(name);
                        table.addLine(resource.get("name").asString(), resource.get("runtime-name").asString(), NOT_ADDED);
                    }
                    if (!table.isEmpty()) {
                        ctx.printLine(table.toString(true));
                    }
                } else {
                    StrictSizeTable table = new StrictSizeTable(1);
                    table.addCell("name", stepResponse.get("name").asString());
                    table.addCell("runtime-name", stepResponse.get("runtime-name").asString());
                    ctx.printLine(table.toString());
                    SimpleTable groups = new SimpleTable(new String[]{SERVER_GROUP, STATE}, ctx.getTerminalWidth());
                    if (this.addedServerGroups == null) {
                        if (steps.hasNext()) {
                            throw new CommandFormatException("Didn't expect results for server groups but received " + (result.asPropertyList().size() - 1) + " more steps.");
                        }
                    } else {
                        for (String sg : this.addedServerGroups) {
                            Property prop = (Property)steps.next();
                            stepResponse = prop.getValue();
                            if (stepResponse.has(prop.getName())) {
                                stepResponse = stepResponse.get(prop.getName());
                            }
                            if (stepResponse.hasDefined("result")) {
                                ModelNode stepResult = stepResponse.get("result");
                                if (stepResult.hasDefined("enabled")) {
                                    groups.addLine(sg, stepResult.get("enabled").asBoolean() ? "enabled" : ADDED);
                                    continue;
                                }
                                groups.addLine(sg, N_A);
                                continue;
                            }
                            groups.addLine(sg, "no response");
                        }
                    }
                    if (this.otherServerGroups != null) {
                        for (String sg : this.otherServerGroups) {
                            groups.addLine(sg, NOT_ADDED);
                        }
                    }
                    ctx.printLine(groups.toString(true));
                }
            } else {
                SimpleTable table = new SimpleTable(new String[]{NAME, RUNTIME_NAME, PERSISTENT, ENABLED, STATUS}, ctx.getTerminalWidth());
                String deploymentName = this.name.getValue(ctx.getParsedCommandLine());
                if (deploymentName == null || deploymentName.indexOf(42) >= 0) {
                    List list = result.asPropertyList();
                    if (!list.isEmpty()) {
                        Pattern pattern = Pattern.compile(Util.wildcardToJavaRegex(deploymentName == null ? "*" : deploymentName));
                        for (Property p : list) {
                            ModelNode node = p.getValue();
                            String name = node.get("name").asString();
                            if (!pattern.matcher(name).matches()) continue;
                            table.addLine(name, node.get("runtime-name").asString(), node.get("persistent").asString(), node.get("enabled").asString(), node.get("status").asString());
                        }
                    }
                } else {
                    table.addLine(result.get("name").asString(), result.get("runtime-name").asString(), result.get("persistent").asString(), result.get("enabled").asString(), result.get("status").asString());
                }
                if (!table.isEmpty()) {
                    ctx.printLine(table.toString());
                }
            }
        }
        finally {
            this.addedServerGroups = null;
            this.otherServerGroups = null;
        }
    }
}

