/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common;

import java.util.Collection;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.annotation.NotNull;

public final class Assert {
    private Assert() {
    }

    @NotNull
    public static <T> T checkNotNullParam(String name, T value) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked(name, value);
        return value;
    }

    @NotNull
    public static <T> T checkNotNullParamWithNullPointerException(String name, T value) throws NullPointerException {
        Assert.checkNotNullParamChecked("name", name);
        if (value == null) {
            throw CommonMessages.msg.nullParamNPE(name);
        }
        return value;
    }

    private static <T> void checkNotNullParamChecked(String name, T value) {
        if (value == null) {
            throw CommonMessages.msg.nullParam(name);
        }
    }

    @NotNull
    public static <T> T checkNotNullArrayParam(String name, int index, T value) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (value == null) {
            throw CommonMessages.msg.nullArrayParam(index, name);
        }
        return value;
    }

    @NotNull
    public static String checkNotEmptyParam(String name, String value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw CommonMessages.msg.emptyParam(name);
        }
        return value;
    }

    @NotNull
    public static <E, T extends Collection<E>> T checkNotEmptyParam(String name, T value) {
        Assert.checkNotNullParamChecked("name", name);
        Assert.checkNotNullParamChecked("value", value);
        if (value.isEmpty()) {
            throw CommonMessages.msg.emptyParam(name);
        }
        return value;
    }

    public static void checkMinimumParameter(String name, int min, int actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual < min) {
            throw CommonMessages.msg.paramLessThan(name, min);
        }
    }

    public static void checkMinimumParameter(String name, long min, long actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual < min) {
            throw CommonMessages.msg.paramLessThan(name, min);
        }
    }

    public static void checkMaximumParameter(String name, int max, int actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual > max) {
            throw CommonMessages.msg.paramGreaterThan(name, max);
        }
    }

    public static void checkMaximumParameter(String name, long max, long actual) throws IllegalArgumentException {
        Assert.checkNotNullParamChecked("name", name);
        if (actual > max) {
            throw CommonMessages.msg.paramGreaterThan(name, max);
        }
    }

    public static void checkArrayBounds(Object[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(byte[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(char[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(int[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(long[] array, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkNotNullParamChecked("array", array);
        Assert.checkArrayBounds(array.length, offs, len);
    }

    public static void checkArrayBounds(int arrayLength, int offs, int len) throws ArrayIndexOutOfBoundsException {
        Assert.checkMinimumParameter("offs", 0, offs);
        Assert.checkMinimumParameter("len", 0, len);
        if (offs > arrayLength) {
            throw CommonMessages.msg.arrayOffsetGreaterThanLength(offs, arrayLength);
        }
        if (offs + len > arrayLength) {
            throw CommonMessages.msg.arrayOffsetLengthGreaterThanLength(offs, len, arrayLength);
        }
    }

    @NotNull
    public static <T> T assertNotNull(T value) {
        assert (value != null) : CommonMessages.msg.unexpectedNullValue();
        return value;
    }

    @NotNull
    public static <T> T assertHoldsLock(@NotNull T monitor) {
        assert (Thread.holdsLock(Assert.checkNotNullParam("monitor", monitor))) : CommonMessages.msg.expectedLockHold(monitor);
        return monitor;
    }

    @NotNull
    public static <T> T assertNotHoldsLock(@NotNull T monitor) {
        assert (!Thread.holdsLock(Assert.checkNotNullParam("monitor", monitor))) : CommonMessages.msg.expectedLockNotHold(monitor);
        return monitor;
    }

    public static boolean assertTrue(boolean expr) {
        assert (expr) : CommonMessages.msg.expectedBoolean(expr);
        return expr;
    }

    public static boolean assertFalse(boolean expr) {
        assert (!expr) : CommonMessages.msg.expectedBoolean(expr);
        return expr;
    }

    public static IllegalStateException unreachableCode() {
        return CommonMessages.msg.unreachableCode();
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(@NotNull Object obj) {
        Assert.checkNotNullParamChecked("obj", obj);
        return CommonMessages.msg.impossibleSwitchCase(obj);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(int val) {
        return CommonMessages.msg.impossibleSwitchCase(val);
    }

    @NotNull
    public static IllegalStateException impossibleSwitchCase(long val) {
        return CommonMessages.msg.impossibleSwitchCase(val);
    }

    @NotNull
    public static UnsupportedOperationException unsupported() {
        StackTraceElement element = new Throwable().getStackTrace()[1];
        return CommonMessages.msg.unsupported(element.getMethodName(), element.getClassName());
    }
}

