/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.security.AccessController;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.JDKPaths;
import org.jboss.modules.JDKSpecific;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PropertyWriteAction;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.PathFilters;

final class ClassPathModuleLoader
extends ModuleLoader {
    static final String[] NO_STRINGS = new String[0];
    static final String CLASSPATH_STRING = "Classpath";
    private final ModuleLoader delegateLoader;
    private final String classPath;
    private final String dependencies;
    private final String mainClass;

    ClassPathModuleLoader(ModuleLoader delegateLoader, String mainClass, String classPath, String dependencies) {
        this.delegateLoader = delegateLoader;
        this.dependencies = dependencies;
        if (ClassPathModuleLoader.isEmpty(classPath)) {
            classPath = System.getenv().getOrDefault("CLASSPATH", "");
        }
        this.classPath = classPath;
        AccessController.doPrivileged(new PropertyWriteAction("java.class.path", classPath));
        this.mainClass = mainClass;
    }

    private static boolean isEmpty(String classPath) {
        return classPath == null || classPath.isEmpty();
    }

    @Override
    protected Module preloadModule(String name) throws ModuleLoadException {
        if (name.equals(CLASSPATH_STRING)) {
            return this.loadModuleLocal(name);
        }
        if (this.delegateLoader != null) {
            return ClassPathModuleLoader.preloadModule(name, this.delegateLoader);
        }
        return null;
    }

    @Override
    protected ModuleSpec findModule(String name) throws ModuleLoadException {
        String[] dependencyEntries;
        ModuleSpec.Builder builder = ModuleSpec.build(name);
        builder.setMainClass(this.mainClass);
        this.addClassPath(builder, this.classPath);
        for (String dependencyEntry : dependencyEntries = this.dependencies == null ? NO_STRINGS : this.dependencies.split(",")) {
            if ((dependencyEntry = dependencyEntry.trim()).isEmpty()) continue;
            DependencySpec spec = DependencySpec.createModuleDependencySpec(PathFilters.getMetaInfSubdirectoriesWithoutMetaInfFilter(), PathFilters.rejectAll(), this.delegateLoader, dependencyEntry, false);
            builder.addDependency(spec);
        }
        builder.addDependency(DependencySpec.createSystemDependencySpec(JDKPaths.JDK));
        builder.addDependency(DependencySpec.createLocalDependencySpec());
        return builder.create();
    }

    @Override
    public String toString() {
        return "Class path module loader for path '" + this.classPath + "'";
    }

    private void addClassPath(ModuleSpec.Builder builder, String classPath) throws ModuleLoadException {
        String[] classPathEntries = classPath == null ? NO_STRINGS : classPath.split(File.pathSeparator);
        File workingDir = new File(System.getProperty("user.dir"));
        for (String entry : classPathEntries) {
            if (entry.isEmpty()) continue;
            try {
                File root = new File(entry);
                if (!root.isAbsolute()) {
                    root = new File(workingDir, root.getPath());
                }
                if (root.isFile()) {
                    try {
                        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(root.getParent(), JDKSpecific.getJarFile(root, true))));
                    }
                    catch (Exception e) {
                        Module.log.trace((Throwable)e, "Resource %s does not appear to be a valid JAR. Loaded as file resource.", (Object)root);
                        builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createFileResourceLoader(entry, root)));
                    }
                    continue;
                }
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createFileResourceLoader(entry, root)));
            }
            catch (Exception e) {
                throw new ModuleLoadException(String.format("File %s in class path not valid.", entry), e);
            }
        }
    }
}

