/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.config.OStoragePaginatedClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategyFactory;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.OImmutableRecordId;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OStorageConfiguration
implements OSerializableStream {
    public static final ORecordId CONFIG_RID = new OImmutableRecordId(0, 0L);
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String charset;
    public static final int CURRENT_VERSION = 17;
    public static final int CURRENT_BINARY_FORMAT_VERSION = 12;
    private final List<OStorageEntryConfiguration> properties = new ArrayList<OStorageEntryConfiguration>();
    protected final transient OStorage storage;
    private volatile OContextConfiguration configuration;
    public volatile int version;
    public volatile String name;
    public volatile String schemaRecordId;
    public volatile String dictionaryRecordId;
    public volatile String indexMgrRecordId;
    public volatile String dateFormat;
    public volatile String dateTimeFormat;
    public volatile int binaryFormatVersion;
    public volatile OStorageSegmentConfiguration fileTemplate;
    public volatile List<OStorageClusterConfiguration> clusters;
    private volatile String localeLanguage;
    private volatile String localeCountry;
    private volatile TimeZone timeZone;
    private volatile transient Locale localeInstance;
    private volatile transient DecimalFormatSymbols unusualSymbols;
    private volatile String clusterSelection;
    private volatile String conflictStrategy;
    private volatile String recordSerializer;
    private volatile int recordSerializerVersion;
    private volatile boolean strictSQL;
    private volatile Map<String, Object> loadProperties;
    private volatile ConcurrentMap<String, IndexEngineData> indexEngines;
    private volatile transient boolean validation = true;
    private volatile boolean txRequiredForSQLGraphOperations;

    public OStorageConfiguration(OStorage iStorage) {
        this.storage = iStorage;
        this.initConfiguration();
        this.clear();
    }

    public void initConfiguration() {
        this.configuration = new OContextConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.fileTemplate = new OStorageSegmentConfiguration();
        this.charset = DEFAULT_CHARSET;
        List<OStorageEntryConfiguration> list = this.properties;
        synchronized (list) {
            this.properties.clear();
        }
        this.version = -1;
        this.name = null;
        this.schemaRecordId = null;
        this.dictionaryRecordId = null;
        this.indexMgrRecordId = null;
        this.dateFormat = DEFAULT_DATE_FORMAT;
        this.dateTimeFormat = DEFAULT_DATETIME_FORMAT;
        this.binaryFormatVersion = 0;
        this.clusters = Collections.synchronizedList(new ArrayList());
        this.localeLanguage = Locale.getDefault().getLanguage();
        this.localeCountry = Locale.getDefault().getCountry();
        this.timeZone = TimeZone.getDefault();
        this.localeInstance = null;
        this.unusualSymbols = null;
        this.clusterSelection = null;
        this.conflictStrategy = null;
        this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS.getValueAsInteger());
        this.autoInitClusters();
        this.recordSerializer = null;
        this.recordSerializerVersion = 0;
        this.strictSQL = false;
        this.txRequiredForSQLGraphOperations = true;
        this.indexEngines = new ConcurrentHashMap<String, IndexEngineData>();
        this.validation = OGlobalConfiguration.DB_VALIDATION.getValueAsBoolean();
        this.binaryFormatVersion = 12;
        this.txRequiredForSQLGraphOperations = OGlobalConfiguration.SQL_GRAPH_CONSISTENCY_MODE.getValueAsString().equalsIgnoreCase("tx");
    }

    private void autoInitClusters() {
        if (this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS) == 0) {
            int cpus = Runtime.getRuntime().availableProcessors();
            this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)(cpus > 64 ? 64 : cpus));
        }
    }

    public String getConflictStrategy() {
        return this.conflictStrategy;
    }

    public void setConflictStrategy(String conflictStrategy) {
        this.conflictStrategy = conflictStrategy;
    }

    public OContextConfiguration getContextConfiguration() {
        return this.configuration;
    }

    public OStorageConfiguration load(Map<String, Object> iProperties) throws OSerializationException {
        byte[] record;
        String encryptionKey;
        String encryptionMethod;
        this.initConfiguration();
        String compressionMethod = (String)iProperties.get(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getKey().toLowerCase());
        if (compressionMethod != null) {
            this.configuration.setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, (Object)compressionMethod);
        }
        if ((encryptionMethod = (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD.getKey().toLowerCase())) != null) {
            this.configuration.setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, (Object)encryptionMethod);
        }
        if ((encryptionKey = (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey().toLowerCase())) != null) {
            this.configuration.setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, (Object)encryptionKey);
        }
        if ((record = this.storage.readRecord((ORecordId)OStorageConfiguration.CONFIG_RID, null, (boolean)false, null).getResult().buffer) == null) {
            throw new OStorageException("Cannot load database configuration. The database seems corrupted");
        }
        this.fromStream(record);
        this.loadProperties = new HashMap<String, Object>(iProperties);
        return this;
    }

    public Map<String, Object> getLoadProperties() {
        if (this.loadProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.loadProperties);
    }

    public void update() throws OSerializationException {
        byte[] record = this.toStream();
        this.storage.updateRecord(CONFIG_RID, true, record, -1, (byte)98, 0, null);
    }

    public boolean isEmpty() {
        return this.clusters.isEmpty();
    }

    public String getDirectory() {
        return this.fileTemplate.location != null ? this.fileTemplate.getLocation() : ((OLocalPaginatedStorage)this.storage).getStoragePath();
    }

    public Locale getLocaleInstance() {
        if (this.localeInstance == null) {
            this.localeInstance = new Locale(this.localeLanguage, this.localeCountry);
        }
        return this.localeInstance;
    }

    public void resetLocaleInstance() {
        this.localeInstance = null;
    }

    public SimpleDateFormat getDateFormatInstance() {
        SimpleDateFormat dateFormatInstance = new SimpleDateFormat(this.dateFormat);
        dateFormatInstance.setLenient(false);
        dateFormatInstance.setTimeZone(this.timeZone);
        return dateFormatInstance;
    }

    public SimpleDateFormat getDateTimeFormatInstance() {
        SimpleDateFormat dateTimeFormatInstance = new SimpleDateFormat(this.dateTimeFormat);
        dateTimeFormatInstance.setLenient(false);
        dateTimeFormatInstance.setTimeZone(this.timeZone);
        return dateTimeFormatInstance;
    }

    public DecimalFormatSymbols getUnusualSymbols() {
        if (this.unusualSymbols == null) {
            this.unusualSymbols = new DecimalFormatSymbols(this.getLocaleInstance());
        }
        return this.unusualSymbols;
    }

    public void fromStream(byte[] stream, int offset, int length) {
        int i;
        int i2;
        this.clear();
        String[] values = new String(stream, offset, length).split("\\|");
        int index = 0;
        this.version = Integer.parseInt(this.read(values[index++]));
        this.name = this.read(values[index++]);
        this.schemaRecordId = this.read(values[index++]);
        this.dictionaryRecordId = this.read(values[index++]);
        this.indexMgrRecordId = this.version > 0 ? this.read(values[index++]) : null;
        this.localeLanguage = this.read(values[index++]);
        this.localeCountry = this.read(values[index++]);
        this.dateFormat = this.read(values[index++]);
        this.dateTimeFormat = this.read(values[index++]);
        if (this.version >= 4) {
            this.timeZone = TimeZone.getTimeZone(this.read(values[index++]));
            this.charset = this.read(values[index++]);
        }
        ORecordConflictStrategyFactory conflictStrategyFactory = Orient.instance().getRecordConflictStrategy();
        this.conflictStrategy = this.version >= 12 ? conflictStrategyFactory.getStrategy(this.read(values[index++])).getName() : conflictStrategyFactory.getDefaultStrategy();
        if (this.version > 1) {
            index = this.phySegmentFromStream(values, index, this.fileTemplate);
        }
        int size = Integer.parseInt(this.read(values[index++]));
        this.clusters.clear();
        String determineStorageCompression = null;
        for (i2 = 0; i2 < size; ++i2) {
            OStorageClusterConfiguration.STATUS status;
            String clusterConflictStrategy;
            String clusterEncryption;
            String clusterCompression;
            float aa;
            float bb;
            boolean cc;
            String clusterType;
            int clusterId;
            if ((clusterId = Integer.parseInt(this.read(values[index++]))) == -1) continue;
            String clusterName = this.read(values[index++]);
            int targetDataSegmentId = this.version >= 3 ? Integer.parseInt(this.read(values[index++])) : 0;
            if ((clusterType = this.read(values[index++])).equals("d")) {
                cc = Boolean.valueOf(this.read(values[index++]));
                bb = Float.valueOf(this.read(values[index++])).floatValue();
                aa = Float.valueOf(this.read(values[index++])).floatValue();
                clusterCompression = this.read(values[index++]);
                if (determineStorageCompression == null) {
                    determineStorageCompression = clusterCompression;
                }
                clusterEncryption = null;
                if (this.version >= 15) {
                    clusterEncryption = this.read(values[index++]);
                }
                clusterConflictStrategy = this.version >= 12 ? this.read(values[index++]) : null;
                status = OStorageClusterConfiguration.STATUS.ONLINE;
                if (this.version >= 13) {
                    status = OStorageClusterConfiguration.STATUS.valueOf(this.read(values[index++]));
                }
            } else {
                if (clusterType.equals("p")) {
                    throw new IllegalArgumentException("Cluster of storage 'local' are not supported since 2.0");
                }
                throw new IllegalArgumentException("Unsupported cluster type: " + clusterType);
            }
            OStoragePaginatedClusterConfiguration currentCluster = new OStoragePaginatedClusterConfiguration(this, clusterId, clusterName, null, cc, bb, aa, clusterCompression, clusterEncryption, this.configuration.getValueAsString(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY), clusterConflictStrategy, status);
            for (int c = this.clusters.size(); c <= clusterId; ++c) {
                this.clusters.add(null);
            }
            this.clusters.set(clusterId, currentCluster);
        }
        if (this.version < 13) {
            size = Integer.parseInt(this.read(values[index++]));
            for (i2 = 0; i2 < size; ++i2) {
                int dataId;
                if ((dataId = Integer.parseInt(this.read(values[index++]))) == -1) continue;
                this.read(values[index++]);
                this.read(values[index++]);
                this.read(values[index++]);
                this.read(values[index++]);
            }
            this.read(values[index++]);
            this.read(values[index++]);
            this.read(values[index++]);
            this.read(values[index++]);
            this.read(values[index++]);
        }
        size = Integer.parseInt(this.read(values[index++]));
        this.clearProperties();
        for (i2 = 0; i2 < size; ++i2) {
            this.setProperty(this.read(values[index++]), this.read(values[index++]));
        }
        this.binaryFormatVersion = this.version >= 7 ? Integer.parseInt(this.read(values[index++])) : (this.version == 6 ? 9 : 8);
        this.clusterSelection = this.version >= 8 ? this.read(values[index++]) : "round-robin";
        if (this.version >= 9) {
            this.setMinimumClusters(Integer.parseInt(this.read(values[index++])));
        } else {
            this.setMinimumClusters(1);
        }
        this.autoInitClusters();
        if (this.version >= 10) {
            this.recordSerializer = this.read(values[index++]);
            this.recordSerializerVersion = Integer.parseInt(this.read(values[index++]));
        }
        if (this.version >= 11) {
            int cfgSize = Integer.parseInt(this.read(values[index++]));
            for (i = 0; i < cfgSize; ++i) {
                String key = this.read(values[index++]);
                String value = this.read(values[index++]);
                OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(key);
                if (cfg != null) {
                    if (value == null) continue;
                    this.configuration.setValue(key, OType.convert(value, cfg.getType()));
                    continue;
                }
                OLogManager.instance().warn((Object)this, "Ignored storage configuration because not supported: %s=%s", key, value);
            }
        } else {
            this.configuration.setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, determineStorageCompression);
        }
        if (this.version > 15) {
            int enginesSize = Integer.parseInt(this.read(values[index++]));
            for (i = 0; i < enginesSize; ++i) {
                HashMap<String, String> engineProperties;
                int propertiesSize;
                String name = this.read(values[index++]);
                String algorithm = this.read(values[index++]);
                String indexType = this.version > 16 ? this.read(values[index++]) : "";
                byte valueSerializerId = Byte.parseByte(this.read(values[index++]));
                byte keySerializerId = Byte.parseByte(this.read(values[index++]));
                boolean isAutomatic = Boolean.parseBoolean(this.read(values[index++]));
                Boolean durableInNonTxMode = this.read(values[index]) == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.read(values[index++])));
                int n = ++index;
                int version = Integer.parseInt(this.read(values[n]));
                int n2 = ++index;
                boolean nullValuesSupport = Boolean.parseBoolean(this.read(values[n2]));
                int n3 = ++index;
                int keySize = Integer.parseInt(this.read(values[n3]));
                int n4 = ++index;
                ++index;
                int typesLength = Integer.parseInt(this.read(values[n4]));
                OType[] types = new OType[typesLength];
                for (int n5 = 0; n5 < types.length; ++n5) {
                    OType type;
                    types[n5] = type = OType.valueOf(this.read(values[index++]));
                }
                if ((propertiesSize = Integer.parseInt(this.read(values[index++]))) == 0) {
                    engineProperties = null;
                } else {
                    engineProperties = new HashMap<String, String>(propertiesSize);
                    for (int n6 = 0; n6 < propertiesSize; ++n6) {
                        String key = this.read(values[index++]);
                        String value = this.read(values[index++]);
                        engineProperties.put(key, value);
                    }
                }
                IndexEngineData indexEngineData = new IndexEngineData(name, algorithm, indexType, durableInNonTxMode, version, valueSerializerId, keySerializerId, isAutomatic, types, nullValuesSupport, keySize, engineProperties);
                this.indexEngines.put(name.toLowerCase(this.getLocaleInstance()), indexEngineData);
            }
        }
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        this.fromStream(iStream, 0, iStream.length);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        return this.toStream(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toStream(int iNetworkVersion) throws OSerializationException {
        StringBuilder buffer = new StringBuilder(8192);
        this.write(buffer, 17);
        this.write(buffer, this.name);
        this.write(buffer, this.schemaRecordId);
        this.write(buffer, this.dictionaryRecordId);
        this.write(buffer, this.indexMgrRecordId);
        this.write(buffer, this.localeLanguage);
        this.write(buffer, this.localeCountry);
        this.write(buffer, this.dateFormat);
        this.write(buffer, this.dateTimeFormat);
        this.write(buffer, this.timeZone.getID());
        this.write(buffer, this.charset);
        if (iNetworkVersion > 24) {
            this.write(buffer, this.conflictStrategy);
        }
        this.phySegmentToStream(buffer, this.fileTemplate);
        this.write(buffer, this.clusters.size());
        for (OStorageClusterConfiguration oStorageClusterConfiguration : this.clusters) {
            if (oStorageClusterConfiguration == null) {
                this.write(buffer, -1);
                continue;
            }
            this.write(buffer, oStorageClusterConfiguration.getId());
            this.write(buffer, oStorageClusterConfiguration.getName());
            this.write(buffer, oStorageClusterConfiguration.getDataSegmentId());
            if (!(oStorageClusterConfiguration instanceof OStoragePaginatedClusterConfiguration)) continue;
            this.write(buffer, "d");
            OStoragePaginatedClusterConfiguration paginatedClusterConfiguration = (OStoragePaginatedClusterConfiguration)oStorageClusterConfiguration;
            this.write(buffer, paginatedClusterConfiguration.useWal);
            this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordOverflowGrowFactor));
            this.write(buffer, Float.valueOf(paginatedClusterConfiguration.recordGrowFactor));
            this.write(buffer, paginatedClusterConfiguration.compression);
            if (iNetworkVersion >= 31) {
                this.write(buffer, paginatedClusterConfiguration.encryption);
            }
            if (iNetworkVersion > 24) {
                this.write(buffer, paginatedClusterConfiguration.conflictStrategy);
            }
            if (iNetworkVersion <= 25) continue;
            this.write(buffer, paginatedClusterConfiguration.getStatus().name().toString());
        }
        if (iNetworkVersion <= 25) {
            this.write(buffer, 0);
            this.write(buffer, "");
            this.write(buffer, "");
            this.write(buffer, 0);
            this.write(buffer, false);
            this.write(buffer, false);
        }
        Iterator<Object> iterator = this.properties;
        synchronized (iterator) {
            this.write(buffer, this.properties.size());
            for (OStorageEntryConfiguration e : this.properties) {
                this.entryToStream(buffer, e);
            }
        }
        this.write(buffer, this.binaryFormatVersion);
        this.write(buffer, this.clusterSelection);
        this.write(buffer, this.getMinimumClusters());
        if (iNetworkVersion > 24) {
            this.write(buffer, this.recordSerializer);
            this.write(buffer, this.recordSerializerVersion);
            this.write(buffer, this.configuration.getContextSize());
            for (String string : this.configuration.getContextKeys()) {
                OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(string);
                this.write(buffer, string);
                this.write(buffer, cfg.isHidden() ? null : this.configuration.getValueAsString(cfg));
            }
        }
        this.write(buffer, this.indexEngines.size());
        for (IndexEngineData indexEngineData : this.indexEngines.values()) {
            this.write(buffer, indexEngineData.name);
            this.write(buffer, indexEngineData.algorithm);
            this.write(buffer, indexEngineData.indexType == null ? "" : indexEngineData.indexType);
            this.write(buffer, indexEngineData.valueSerializerId);
            this.write(buffer, indexEngineData.keySerializedId);
            this.write(buffer, indexEngineData.isAutomatic);
            this.write(buffer, indexEngineData.durableInNonTxMode);
            this.write(buffer, indexEngineData.version);
            this.write(buffer, indexEngineData.nullValuesSupport);
            this.write(buffer, indexEngineData.keySize);
            if (indexEngineData.keyTypes != null) {
                this.write(buffer, indexEngineData.keyTypes.length);
                for (OType type : indexEngineData.keyTypes) {
                    this.write(buffer, type.name());
                }
            } else {
                this.write(buffer, 0);
            }
            if (indexEngineData.engineProperties == null) {
                this.write(buffer, 0);
                continue;
            }
            this.write(buffer, indexEngineData.engineProperties.size());
            for (Map.Entry entry : indexEngineData.engineProperties.entrySet()) {
                this.write(buffer, entry.getKey());
                this.write(buffer, entry.getValue());
            }
        }
        buffer.append("|");
        return buffer.toString().getBytes();
    }

    public void lock() throws IOException {
    }

    public void unlock() throws IOException {
    }

    public void create() throws IOException {
        this.storage.createRecord(CONFIG_RID, new byte[]{0, 0, 0, 0}, 0, (byte)98, 0, null);
    }

    public void synch() throws IOException {
    }

    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }

    public void delete() throws IOException {
        this.close();
    }

    public void close() throws IOException {
        this.clear();
        this.initConfiguration();
    }

    public void setCluster(OStorageClusterConfiguration config) {
        while (config.getId() >= this.clusters.size()) {
            this.clusters.add(null);
        }
        this.clusters.set(config.getId(), config);
    }

    public void dropCluster(int iClusterId) {
        if (iClusterId < this.clusters.size()) {
            this.clusters.set(iClusterId, null);
            this.update();
        }
    }

    public void addIndexEngine(String name, IndexEngineData engineData) {
        IndexEngineData oldEngine = this.indexEngines.putIfAbsent(name, engineData);
        if (oldEngine != null) {
            OLogManager.instance().warn((Object)this, "Index engine with name '" + engineData.name + "' already contained in database configuration", new Object[0]);
        }
        this.update();
    }

    public void deleteIndexEngine(String name) {
        this.indexEngines.remove(name);
        this.update();
    }

    public Set<String> indexEngines() {
        return Collections.unmodifiableSet(this.indexEngines.keySet());
    }

    public IndexEngineData getIndexEngine(String name) {
        return (IndexEngineData)this.indexEngines.get(name);
    }

    public void setClusterStatus(int clusterId, OStorageClusterConfiguration.STATUS iStatus) {
        OStorageClusterConfiguration clusterCfg = this.clusters.get(clusterId);
        if (clusterCfg != null) {
            clusterCfg.setStatus(iStatus);
        }
        this.update();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String getLocaleLanguage() {
        return this.localeLanguage;
    }

    public void setLocaleLanguage(String iValue) {
        this.localeLanguage = iValue;
        this.localeInstance = null;
    }

    public String getLocaleCountry() {
        return this.localeCountry;
    }

    public void setLocaleCountry(String iValue) {
        this.localeCountry = iValue;
        this.localeInstance = null;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public String getClusterSelection() {
        return this.clusterSelection;
    }

    public void setClusterSelection(String clusterSelection) {
        this.clusterSelection = clusterSelection;
    }

    public int getMinimumClusters() {
        int mc = this.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS);
        if (mc == 0) {
            this.autoInitClusters();
            return (Integer)this.getContextConfiguration().getValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS);
        }
        return mc;
    }

    public void setMinimumClusters(int minimumClusters) {
        this.getContextConfiguration().setValue(OGlobalConfiguration.CLASS_MINIMUM_CLUSTERS, (Object)minimumClusters);
        this.autoInitClusters();
    }

    public String getRecordSerializer() {
        return this.recordSerializer;
    }

    public void setRecordSerializer(String recordSerializer) {
        this.recordSerializer = recordSerializer;
    }

    public int getRecordSerializerVersion() {
        return this.recordSerializerVersion;
    }

    public void setRecordSerializerVersion(int recordSerializerVersion) {
        this.recordSerializerVersion = recordSerializerVersion;
    }

    public boolean isStrictSql() {
        return this.strictSQL;
    }

    public boolean isTxRequiredForSQLGraphOperations() {
        return this.txRequiredForSQLGraphOperations;
    }

    public List<OStorageEntryConfiguration> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String iName, String iValue) {
        if ("strictSql".equalsIgnoreCase(iName)) {
            this.strictSQL = "true".equalsIgnoreCase(iValue);
        }
        if ("txRequiredForSQLGraphOperations".equalsIgnoreCase(iName)) {
            this.txRequiredForSQLGraphOperations = "true".equalsIgnoreCase(iValue);
        }
        if ("txRequiredForSQLGraphOperations".equalsIgnoreCase(iName)) {
            this.txRequiredForSQLGraphOperations = "true".equalsIgnoreCase(iValue);
        }
        if ("validation".equalsIgnoreCase(iName)) {
            this.validation = "true".equalsIgnoreCase(iValue);
        }
        List<OStorageEntryConfiguration> list = this.properties;
        synchronized (list) {
            for (OStorageEntryConfiguration e : this.properties) {
                if (!e.name.equalsIgnoreCase(iName)) continue;
                e.value = iValue;
                return;
            }
            this.properties.add(new OStorageEntryConfiguration(iName, iValue));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getProperty(String iName) {
        List<OStorageEntryConfiguration> list = this.properties;
        synchronized (list) {
            for (OStorageEntryConfiguration e : this.properties) {
                if (!e.name.equalsIgnoreCase(iName)) continue;
                return e.value;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existsProperty(String iName) {
        List<OStorageEntryConfiguration> list = this.properties;
        synchronized (list) {
            for (OStorageEntryConfiguration e : this.properties) {
                if (!e.name.equalsIgnoreCase(iName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(String iName) {
        List<OStorageEntryConfiguration> list = this.properties;
        synchronized (list) {
            Iterator<OStorageEntryConfiguration> it = this.properties.iterator();
            while (it.hasNext()) {
                OStorageEntryConfiguration e = it.next();
                if (!e.name.equalsIgnoreCase(iName)) continue;
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProperties() {
        List<OStorageEntryConfiguration> list = this.properties;
        synchronized (list) {
            this.properties.clear();
        }
    }

    public boolean isValidationEnabled() {
        return this.validation;
    }

    public void setValidation(boolean validation) {
        this.setProperty("validation", validation ? "true" : "false");
    }

    protected void bindPropertiesToContext(Map<String, Object> iProperties) {
        String encryptionKey;
        String encryptionMethod;
        String compressionMethod;
        String string = compressionMethod = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD.getKey().toLowerCase()) : null;
        if (compressionMethod != null) {
            this.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_COMPRESSION_METHOD, (Object)compressionMethod);
        }
        String string2 = encryptionMethod = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD.getKey().toLowerCase()) : null;
        if (encryptionMethod != null) {
            this.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_METHOD, (Object)encryptionMethod);
        }
        String string3 = encryptionKey = iProperties != null ? (String)iProperties.get(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey().toLowerCase()) : null;
        if (encryptionKey != null) {
            this.getContextConfiguration().setValue(OGlobalConfiguration.STORAGE_ENCRYPTION_KEY, (Object)encryptionKey);
        }
    }

    private int phySegmentFromStream(String[] values, int index, OStorageSegmentConfiguration iSegment) {
        iSegment.location = this.version > 2 ? this.read(values[index++]) : null;
        iSegment.maxSize = this.read(values[index++]);
        iSegment.fileType = this.read(values[index++]);
        iSegment.fileStartSize = this.read(values[index++]);
        iSegment.fileMaxSize = this.read(values[index++]);
        iSegment.fileIncrementSize = this.read(values[index++]);
        iSegment.defrag = this.read(values[index++]);
        int size = Integer.parseInt(this.read(values[index++]));
        iSegment.infoFiles = new OStorageFileConfiguration[size];
        for (int i = 0; i < size; ++i) {
            int pos;
            String fileName;
            if (!(fileName = this.read(values[index++])).contains("$") && (pos = fileName.indexOf("/databases")) > -1) {
                fileName = "${ORIENTDB_HOME}" + fileName.substring(pos);
            }
            iSegment.infoFiles[i] = new OStorageFileConfiguration(iSegment, fileName, this.read(values[index++]), this.read(values[index++]), iSegment.fileIncrementSize);
        }
        return index;
    }

    private void phySegmentToStream(StringBuilder iBuffer, OStorageSegmentConfiguration iSegment) {
        this.write(iBuffer, iSegment.location);
        this.write(iBuffer, iSegment.maxSize);
        this.write(iBuffer, iSegment.fileType);
        this.write(iBuffer, iSegment.fileStartSize);
        this.write(iBuffer, iSegment.fileMaxSize);
        this.write(iBuffer, iSegment.fileIncrementSize);
        this.write(iBuffer, iSegment.defrag);
        this.write(iBuffer, iSegment.infoFiles.length);
        for (OStorageFileConfiguration f : iSegment.infoFiles) {
            this.fileToStream(iBuffer, f);
        }
    }

    private void fileToStream(StringBuilder iBuffer, OStorageFileConfiguration iFile) {
        this.write(iBuffer, iFile.path);
        this.write(iBuffer, iFile.type);
        this.write(iBuffer, iFile.maxSize);
    }

    private void entryToStream(StringBuilder iBuffer, OStorageEntryConfiguration iEntry) {
        this.write(iBuffer, iEntry.name);
        this.write(iBuffer, iEntry.value);
    }

    private String read(String iValue) {
        if (iValue.equals(" ")) {
            return null;
        }
        return iValue;
    }

    private void write(StringBuilder iBuffer, Object iValue) {
        if (iBuffer.length() > 0) {
            iBuffer.append('|');
        }
        iBuffer.append(iValue != null ? iValue.toString() : Character.valueOf(' '));
    }

    public static final class IndexEngineData {
        private final String name;
        private final String algorithm;
        private final String indexType;
        private final Boolean durableInNonTxMode;
        private final int version;
        private final byte valueSerializerId;
        private final byte keySerializedId;
        private final boolean isAutomatic;
        private final OType[] keyTypes;
        private final boolean nullValuesSupport;
        private final int keySize;
        private final Map<String, String> engineProperties;

        public IndexEngineData(String name, String algorithm, String indexType, Boolean durableInNonTxMode, int version, byte valueSerializerId, byte keySerializedId, boolean isAutomatic, OType[] keyTypes, boolean nullValuesSupport, int keySize, Map<String, String> engineProperties) {
            this.name = name;
            this.algorithm = algorithm;
            this.indexType = indexType;
            this.durableInNonTxMode = durableInNonTxMode;
            this.version = version;
            this.valueSerializerId = valueSerializerId;
            this.keySerializedId = keySerializedId;
            this.isAutomatic = isAutomatic;
            this.keyTypes = keyTypes;
            this.nullValuesSupport = nullValuesSupport;
            this.keySize = keySize;
            this.engineProperties = engineProperties == null ? null : new HashMap<String, String>(engineProperties);
        }

        public int getKeySize() {
            return this.keySize;
        }

        public String getName() {
            return this.name;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public Boolean getDurableInNonTxMode() {
            return this.durableInNonTxMode;
        }

        public int getVersion() {
            return this.version;
        }

        public byte getValueSerializerId() {
            return this.valueSerializerId;
        }

        public byte getKeySerializedId() {
            return this.keySerializedId;
        }

        public boolean isAutomatic() {
            return this.isAutomatic;
        }

        public OType[] getKeyTypes() {
            return this.keyTypes;
        }

        public boolean isNullValuesSupport() {
            return this.nullValuesSupport;
        }

        public Map<String, String> getEngineProperties() {
            if (this.engineProperties == null) {
                return null;
            }
            return Collections.unmodifiableMap(this.engineProperties);
        }

        public String getIndexType() {
            return this.indexType;
        }
    }
}

