/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sharding.auto;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.index.hashindex.local.OHashIndexBucket;
import com.orientechnologies.orient.core.index.hashindex.local.OHashTable;
import com.orientechnologies.orient.core.index.hashindex.local.OLocalHashTable;
import com.orientechnologies.orient.core.index.hashindex.local.OMurmurHash3HashFunction;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingMurmurStrategy;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingStrategy;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OAutoShardingIndexEngine
implements OIndexEngine {
    public static final int VERSION = 1;
    public static final String SUBINDEX_METADATA_FILE_EXTENSION = ".asm";
    public static final String SUBINDEX_TREE_FILE_EXTENSION = ".ast";
    public static final String SUBINDEX_BUCKET_FILE_EXTENSION = ".asb";
    public static final String SUBINDEX_NULL_BUCKET_FILE_EXTENSION = ".asn";
    private final OAbstractPaginatedStorage storage;
    private final boolean durableInNonTx;
    private final OMurmurHash3HashFunction<Object> hashFunction;
    private List<OHashTable<Object, Object>> partitions;
    private OAutoShardingStrategy strategy;
    private int version;
    private final String name;
    private int partitionSize;

    public OAutoShardingIndexEngine(String iName, Boolean iDurableInNonTxMode, OAbstractPaginatedStorage iStorage, int iVersion) {
        this.name = iName;
        this.storage = iStorage;
        this.hashFunction = new OMurmurHash3HashFunction();
        this.durableInNonTx = iDurableInNonTxMode == null ? OGlobalConfiguration.INDEX_DURABLE_IN_NON_TX_MODE.getValueAsBoolean() : iDurableInNonTxMode.booleanValue();
        this.version = iVersion;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OAutoShardingStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public void create(OBinarySerializer valueSerializer, boolean isAutomatic, OType[] keyTypes, boolean nullPointerSupport, OBinarySerializer keySerializer, int keySize, Set<String> clustersToIndex, Map<String, String> engineProperties, ODocument metadata) {
        this.strategy = new OAutoShardingMurmurStrategy(keySerializer);
        this.hashFunction.setValueSerializer(keySerializer);
        this.partitionSize = clustersToIndex.size();
        engineProperties.put("partitions", "" + this.partitionSize);
        this.init();
        for (OHashTable<Object, Object> p : this.partitions) {
            p.create(keySerializer, valueSerializer, keyTypes, nullPointerSupport);
        }
    }

    @Override
    public void load(String indexName, OBinarySerializer valueSerializer, boolean isAutomatic, OBinarySerializer keySerializer, OType[] keyTypes, boolean nullPointerSupport, int keySize, Map<String, String> engineProperties) {
        this.strategy = new OAutoShardingMurmurStrategy(keySerializer);
        OStorage storage = this.getDatabase().getStorage().getUnderlying();
        if (storage instanceof OAbstractPaginatedStorage) {
            String partitionsAsString = engineProperties.get("partitions");
            if (partitionsAsString == null || partitionsAsString.isEmpty()) {
                throw new OIndexException("Cannot load autosharding index '" + indexName + "' because there is no metadata about the number of partitions");
            }
            this.partitionSize = Integer.parseInt(partitionsAsString);
            this.init();
            int i = 0;
            for (OHashTable<Object, Object> p : this.partitions) {
                p.load(indexName + "_" + i++, keyTypes, nullPointerSupport);
            }
        }
        this.hashFunction.setValueSerializer(keySerializer);
    }

    @Override
    public void flush() {
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.flush();
            }
        }
    }

    @Override
    public void deleteWithoutLoad(String indexName) {
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.deleteWithoutLoad(indexName, (OAbstractPaginatedStorage)this.getDatabase().getStorage().getUnderlying());
            }
        }
    }

    @Override
    public void delete() {
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.delete();
            }
        }
    }

    @Override
    public void init(String indexName, String indexType, OIndexDefinition indexDefinition, boolean isAutomatic, ODocument metadata) {
    }

    private void init() {
        if (this.partitions != null) {
            return;
        }
        this.partitions = new ArrayList<OHashTable<Object, Object>>(this.partitionSize);
        for (int i = 0; i < this.partitionSize; ++i) {
            this.partitions.add(new OLocalHashTable(this.name + "_" + i, SUBINDEX_METADATA_FILE_EXTENSION, SUBINDEX_TREE_FILE_EXTENSION, SUBINDEX_BUCKET_FILE_EXTENSION, SUBINDEX_NULL_BUCKET_FILE_EXTENSION, this.hashFunction, this.durableInNonTx, this.storage));
        }
    }

    @Override
    public boolean contains(Object key) {
        return this.getPartition(key).get(key) != null;
    }

    @Override
    public boolean remove(Object key) {
        return this.getPartition(key).remove(key) != null;
    }

    @Override
    public void clear() {
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.clear();
            }
        }
    }

    @Override
    public void close() {
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                p.close();
            }
        }
    }

    @Override
    public Object get(Object key) {
        return this.getPartition(key).get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this.getPartition(key).put(key, value);
    }

    @Override
    public long size(OIndexEngine.ValuesTransformer transformer) {
        long counter = 0L;
        if (this.partitions != null) {
            for (OHashTable<Object, Object> p : this.partitions) {
                if (transformer == null) {
                    counter += p.size();
                    continue;
                }
                OHashIndexBucket.Entry<Object, Object> firstEntry = p.firstEntry();
                if (firstEntry == null) continue;
                OHashIndexBucket.Entry<Object, Object>[] entries = p.ceilingEntries(firstEntry.key);
                while (entries.length > 0) {
                    for (OHashIndexBucket.Entry<Object, Object> entry : entries) {
                        counter += (long)transformer.transformFromValue(entry.value).size();
                    }
                    entries = p.higherEntries(entries[entries.length - 1].key);
                }
            }
        }
        return counter;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean hasRangeQuerySupport() {
        return false;
    }

    @Override
    public OIndexCursor cursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        throw new UnsupportedOperationException("cursor");
    }

    @Override
    public OIndexCursor descCursor(OIndexEngine.ValuesTransformer valuesTransformer) {
        throw new UnsupportedOperationException("descCursor");
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        return new OIndexKeyCursor(){
            private int nextPartition = 1;
            private OHashTable<Object, Object> hashTable;
            private int nextEntriesIndex;
            private OHashIndexBucket.Entry<Object, Object>[] entries;
            {
                if (OAutoShardingIndexEngine.this.partitions == null || OAutoShardingIndexEngine.this.partitions.isEmpty()) {
                    this.entries = OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY;
                } else {
                    this.hashTable = (OHashTable)OAutoShardingIndexEngine.this.partitions.get(0);
                    OHashIndexBucket.Entry<Object, Object> firstEntry = this.hashTable.firstEntry();
                    this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : this.hashTable.ceilingEntries(firstEntry.key);
                }
            }

            @Override
            public Object next(int prefetchSize) {
                if (this.entries.length == 0) {
                    return null;
                }
                OHashIndexBucket.Entry<Object, Object> bucketEntry = this.entries[this.nextEntriesIndex];
                ++this.nextEntriesIndex;
                if (this.nextEntriesIndex >= this.entries.length) {
                    this.entries = this.hashTable.higherEntries(this.entries[this.entries.length - 1].key);
                    this.nextEntriesIndex = 0;
                    if (this.entries.length == 0 && this.nextPartition < OAutoShardingIndexEngine.this.partitions.size()) {
                        this.hashTable = (OHashTable)OAutoShardingIndexEngine.this.partitions.get(this.nextPartition++);
                        OHashIndexBucket.Entry<Object, Object> firstEntry = this.hashTable.firstEntry();
                        this.entries = firstEntry == null ? OCommonConst.EMPTY_BUCKET_ENTRY_ARRAY : this.hashTable.ceilingEntries(firstEntry.key);
                    }
                }
                return bucketEntry.key;
            }
        };
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object rangeFrom, boolean fromInclusive, Object rangeTo, boolean toInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean isInclusive, boolean ascSortOrder, OIndexEngine.ValuesTransformer transformer) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("firstKey");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("lastKey");
    }

    @Override
    public boolean acquireAtomicExclusiveLock(Object key) {
        this.getPartition(key).acquireAtomicExclusiveLock();
        return false;
    }

    @Override
    public String getIndexNameByKey(Object key) {
        return this.getPartition(key).getName();
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private OHashTable<Object, Object> getPartition(Object iKey) {
        int partitionId = iKey != null ? this.strategy.getPartitionsId(iKey, this.partitionSize) : 0;
        return this.partitions.get(partitionId);
    }
}

