/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import com.orientechnologies.orient.core.sql.parser.OMethodCall;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OMatchPathItem
extends SimpleNode {
    protected OMethodCall method;
    protected OMatchFilter filter;

    public OMatchPathItem(int id) {
        super(id);
    }

    public OMatchPathItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isBidirectional() {
        if (this.filter.getWhileCondition() != null) {
            return false;
        }
        if (this.filter.getMaxDepth() != null) {
            return false;
        }
        if (this.filter.isOptional()) {
            return false;
        }
        return this.method.isBidirectional();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.method.toString(params, builder);
        if (this.filter != null) {
            this.filter.toString(params, builder);
        }
    }

    protected Iterable<OIdentifiable> executeTraversal(OMatchStatement.MatchContext matchContext, OCommandContext iCommandContext, OIdentifiable startingPoint, int depth) {
        OWhereClause filter = null;
        OWhereClause whileCondition = null;
        Integer maxDepth = null;
        if (this.filter != null) {
            filter = this.filter.getFilter();
            whileCondition = this.filter.getWhileCondition();
            maxDepth = this.filter.getMaxDepth();
        }
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        if (whileCondition == null && maxDepth == null) {
            Iterable<OIdentifiable> queryResult = this.traversePatternEdge(matchContext, startingPoint, iCommandContext);
            if (this.filter == null || this.filter.getFilter() == null) {
                return queryResult;
            }
            for (OIdentifiable origin : queryResult) {
                Object previousMatch = iCommandContext.getVariable("$currentMatch");
                iCommandContext.setVariable("$currentMatch", origin);
                if (filter == null || filter.matchesFilters(origin, iCommandContext)) {
                    result.add(origin);
                }
                iCommandContext.setVariable("$currentMatch", previousMatch);
            }
        } else {
            iCommandContext.setVariable("$depth", depth);
            Object previousMatch = iCommandContext.getVariable("$currentMatch");
            iCommandContext.setVariable("$currentMatch", startingPoint);
            if (filter == null || filter.matchesFilters(startingPoint, iCommandContext)) {
                result.add(startingPoint);
            }
            if (!(maxDepth != null && depth >= maxDepth || whileCondition != null && !whileCondition.matchesFilters(startingPoint, iCommandContext))) {
                Iterable<OIdentifiable> queryResult = this.traversePatternEdge(matchContext, startingPoint, iCommandContext);
                for (OIdentifiable origin : queryResult) {
                    Iterable<OIdentifiable> subResult = this.executeTraversal(matchContext, iCommandContext, origin, depth + 1);
                    if (subResult instanceof Collection) {
                        result.addAll((Collection)subResult);
                        continue;
                    }
                    for (OIdentifiable i : subResult) {
                        result.add(i);
                    }
                }
            }
            iCommandContext.setVariable("$currentMatch", previousMatch);
        }
        return result;
    }

    protected Iterable<OIdentifiable> traversePatternEdge(OMatchStatement.MatchContext matchContext, OIdentifiable startingPoint, OCommandContext iCommandContext) {
        Object qR;
        Iterable<Object> possibleResults = null;
        if (this.filter != null) {
            OIdentifiable matchedNode = matchContext.matched.get(this.filter.getAlias());
            possibleResults = matchedNode != null ? Collections.singleton(matchedNode) : (matchContext.matched.containsKey(this.filter.getAlias()) ? Collections.emptySet() : (matchContext.candidates == null ? null : matchContext.candidates.get(this.filter.getAlias())));
        }
        return (qR = this.method.execute(startingPoint, possibleResults, iCommandContext)) instanceof Iterable ? (Set<Object>)qR : Collections.singleton(qR);
    }
}

