/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class CharacterType
extends AbstractPrimitiveType<Character> {
    private CharacterEncoding _characterEncoding;

    CharacterType(EncoderImpl encoder, DecoderImpl decoder) {
        this._characterEncoding = new CharacterEncoding(encoder, decoder);
        encoder.register(Character.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Character> getTypeClass() {
        return Character.class;
    }

    public CharacterEncoding getEncoding(Character val) {
        return this._characterEncoding;
    }

    public CharacterEncoding getCanonicalEncoding() {
        return this._characterEncoding;
    }

    @Override
    public Collection<CharacterEncoding> getAllEncodings() {
        return Collections.singleton(this._characterEncoding);
    }

    @Override
    public void write(char c) {
        this._characterEncoding.write(c);
    }

    public class CharacterEncoding
    extends FixedSizePrimitiveTypeEncoding<Character> {
        public CharacterEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 4;
        }

        @Override
        public byte getEncodingCode() {
            return 115;
        }

        public CharacterType getType() {
            return CharacterType.this;
        }

        @Override
        public void writeValue(Character val) {
            this.getEncoder().writeRaw(val.charValue() & 0xFFFF);
        }

        @Override
        public void writeValue(char val) {
            this.getEncoder().writeRaw(val & 0xFFFF);
        }

        public void write(char c) {
            this.writeConstructor();
            this.getEncoder().writeRaw(c & 0xFFFF);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Character> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Character readValue() {
            return Character.valueOf(this.readPrimitiveValue());
        }

        public char readPrimitiveValue() {
            return (char)(this.getDecoder().readRawInt() & 0xFFFF);
        }

        @Override
        public boolean encodesJavaPrimitive() {
            return true;
        }
    }
}

