/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.clustering.ee.Immutability;

public class CollectionImmutability
implements Predicate<Object> {
    private final Set<Class<?>> unmodifiableClasses = Immutability.createIdentitySet(Stream.of(Collections.singleton(null), Collections.singletonList(null), Collections.singletonMap(null, null), Collections.unmodifiableCollection(Collections.emptyList()), Collections.unmodifiableList(Collections.emptyList()), Collections.unmodifiableMap(Collections.emptyMap()), Collections.unmodifiableNavigableMap(Collections.emptyNavigableMap()), Collections.unmodifiableNavigableSet(Collections.emptyNavigableSet()), Collections.unmodifiableSet(Collections.emptySet()), Collections.unmodifiableSortedMap(Collections.emptySortedMap()), Collections.unmodifiableSortedSet(Collections.emptySortedSet())).map(o -> o.getClass()).collect(Collectors.toList()));
    private final Predicate<Object> elementImmutability;

    public CollectionImmutability(Predicate<Object> elementImmutability) {
        this.elementImmutability = elementImmutability;
    }

    @Override
    public boolean test(Object object) {
        if (this.unmodifiableClasses.stream().anyMatch(immutableClass -> immutableClass.isInstance(object))) {
            if (object instanceof Set) {
                return true;
            }
            Collection collection = object instanceof Map ? ((Map)object).values() : (Collection)object;
            return collection.stream().allMatch(e -> this.elementImmutability.test(e));
        }
        return false;
    }
}

