/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;

public class LsHandler
extends BaseOperationCommand {
    private final ArgumentWithValue nodePath;
    private final ArgumentWithoutValue l = new ArgumentWithoutValue(this, "-l");
    private final ArgumentWithoutValue resolve;

    public LsHandler(CommandContext ctx) {
        this(ctx, "ls");
    }

    public LsHandler(CommandContext ctx, String command) {
        super(ctx, command, true);
        this.nodePath = new ArgumentWithValue((CommandHandlerWithArguments)this, OperationRequestCompleter.ARG_VALUE_COMPLETER, 0, "--node-path");
        this.resolve = new ArgumentWithoutValue(this, "--resolve-expressions"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                ModelNode properties;
                ModelNode result;
                if (!super.canAppearNext(ctx)) {
                    return false;
                }
                ModelNode op = new ModelNode();
                op.get("operation").set("read-operation-description");
                op.get("name").set("read-attribute");
                OperationRequestAddress address = LsHandler.this.getOperationRequestAddress(ctx);
                op = LsHandler.this.getAddressNode(ctx, address, op);
                ModelNode returnVal = new ModelNode();
                try {
                    returnVal = ctx.getModelControllerClient().execute(op);
                }
                catch (IOException e) {
                    throw new CommandFormatException("Failed to read resource: " + e.getLocalizedMessage(), e);
                }
                return returnVal.hasDefined("outcome") && returnVal.get("outcome").asString().equals("success") && (result = returnVal.get("result")).hasDefined("request-properties") && (properties = result.get("request-properties")).hasDefined("resolve-expressions");
            }
        };
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        super.recognizeArguments(ctx);
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        if (this.resolve.isPresent(parsedCmd)) {
            ModelNode properties;
            ModelNode result;
            ModelNode op = new ModelNode();
            op.get("operation").set("read-operation-description");
            op.get("name").set("read-attribute");
            OperationRequestAddress address = this.getOperationRequestAddress(ctx);
            op = this.getAddressNode(ctx, address, op);
            ModelNode returnVal = new ModelNode();
            try {
                if (ctx.getModelControllerClient() != null) {
                    returnVal = ctx.getModelControllerClient().execute(op);
                }
            }
            catch (IOException e) {
                throw new CommandFormatException("Failed to read resource: " + e.getLocalizedMessage(), e);
            }
            if (returnVal.hasDefined("outcome") && returnVal.get("outcome").asString().equals("success") && (result = returnVal.get("result")).hasDefined("request-properties") && !(properties = result.get("request-properties")).hasDefined("resolve-expressions") && this.resolve.isPresent(parsedCmd)) {
                throw new OperationFormatException("Resolve Expression argument not available at this location.");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleResponse(CommandContext ctx, ModelNode outcome, boolean composite) throws CommandLineException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        if (!composite) {
            List nodeList = outcome.get("result").asList();
            if (nodeList.isEmpty()) return;
            ArrayList<String> list = new ArrayList<String>(nodeList.size());
            for (ModelNode node : nodeList) {
                list.add(node.asString());
            }
            this.printList(ctx, list, this.l.isPresent(parsedCmd));
            return;
        }
        List<String> additionalProps = Collections.emptyList();
        if (this.l.isPresent(parsedCmd)) {
            Set<String> argNames = parsedCmd.getPropertyNames();
            boolean resolvePresent = this.resolve.isPresent(parsedCmd);
            int recognizedArgs = 1 + (resolvePresent ? 1 : 0);
            if (argNames.size() > recognizedArgs) {
                additionalProps = new ArrayList<String>(argNames.size() - recognizedArgs);
                boolean i = false;
                for (String arg : argNames) {
                    if (arg.equals(this.l.getFullName()) || resolvePresent && arg.equals(this.resolve.getFullName())) continue;
                    String prop = arg.length() > 1 && arg.charAt(0) == '-' ? (arg.charAt(1) == '-' ? arg.substring(2) : arg.substring(1)) : arg;
                    additionalProps.add(prop);
                }
            }
        }
        ModelNode resultNode = outcome.get("result");
        ModelNode attrDescriptions = null;
        ModelNode childDescriptions = null;
        if (resultNode.hasDefined("step-3")) {
            ModelNode stepOutcome = resultNode.get("step-3");
            if (!Util.isSuccess(stepOutcome)) throw new CommandFormatException("Failed to get resource description: " + outcome);
            if (!stepOutcome.hasDefined("result")) throw new CommandFormatException("Result is not available for read-resource-description request: " + outcome);
            ModelNode descrResult = stepOutcome.get("result");
            if (descrResult.hasDefined("attributes")) {
                attrDescriptions = descrResult.get("attributes");
            }
            if (descrResult.hasDefined("children")) {
                childDescriptions = descrResult.get("children");
            }
        }
        ArrayList<String> names = null;
        ArrayList<String> typeNames = null;
        if (!resultNode.hasDefined("step-1")) throw new CommandFormatException("The result for children type names is not available: " + outcome);
        ModelNode typesOutcome = resultNode.get("step-1");
        if (!Util.isSuccess(typesOutcome)) throw new CommandFormatException("Failed to fetch type names: " + outcome);
        if (!typesOutcome.hasDefined("result")) throw new CommandFormatException("Result is not available for read-children-types request: " + outcome);
        ModelNode resourceResult = typesOutcome.get("result");
        List types = resourceResult.asList();
        if (!types.isEmpty()) {
            typeNames = new ArrayList<String>();
            for (ModelNode type : types) {
                typeNames.add(type.asString());
            }
            if (childDescriptions == null && attrDescriptions == null) {
                names = typeNames;
            }
        }
        if (!resultNode.hasDefined("step-2")) throw new CommandFormatException("The result for attributes is not available: " + outcome);
        ModelNode resourceOutcome = resultNode.get("step-2");
        if (!Util.isSuccess(resourceOutcome)) throw new CommandFormatException("Failed to fetch attributes: " + outcome);
        if (!resourceOutcome.hasDefined("result")) throw new CommandFormatException("Result is not available for read-resource request: " + outcome);
        resourceResult = resourceOutcome.get("result");
        List props = resourceResult.asPropertyList();
        if (!props.isEmpty()) {
            SimpleTable childrenTable;
            SimpleTable attrTable;
            if (attrDescriptions == null) {
                attrTable = null;
            } else if (!additionalProps.isEmpty()) {
                String[] headers = new String[3 + additionalProps.size()];
                headers[0] = "ATTRIBUTE";
                headers[1] = "VALUE";
                headers[2] = "TYPE";
                int i = 3;
                for (String additional : additionalProps) {
                    headers[i++] = additional.toUpperCase(Locale.ENGLISH);
                }
                attrTable = new SimpleTable(headers, ctx.getTerminalWidth());
            } else {
                attrTable = new SimpleTable(new String[]{"ATTRIBUTE", "VALUE", "TYPE"}, ctx.getTerminalWidth());
            }
            SimpleTable simpleTable = childrenTable = childDescriptions == null ? null : new SimpleTable(new String[]{"CHILD", "MIN-OCCURS", "MAX-OCCURS"}, ctx.getTerminalWidth());
            if (typeNames == null && attrTable == null && childrenTable == null) {
                typeNames = new ArrayList();
                names = typeNames;
            }
            for (Property prop : props) {
                StringBuilder buf = new StringBuilder();
                if (typeNames == null || !typeNames.contains(prop.getName())) {
                    if (attrDescriptions == null) {
                        buf.append(prop.getName());
                        buf.append('=');
                        buf.append(prop.getValue().asString());
                        typeNames.add(buf.toString());
                        buf.setLength(0);
                        continue;
                    }
                    String[] line = new String[attrTable.columnsTotal()];
                    line[0] = prop.getName();
                    line[1] = prop.getValue().asString();
                    if (attrDescriptions.hasDefined(prop.getName())) {
                        ModelNode attrDescr = attrDescriptions.get(prop.getName());
                        line[2] = this.getAsString(attrDescr, "type");
                        if (!additionalProps.isEmpty()) {
                            int i = 3;
                            for (String additional : additionalProps) {
                                line[i++] = this.getAsString(attrDescr, additional);
                            }
                        }
                    } else {
                        for (int i = 2; i < line.length; ++i) {
                            line[i] = "n/a";
                        }
                    }
                    attrTable.addLine(line);
                    continue;
                }
                if (childDescriptions == null) continue;
                if (childDescriptions.hasDefined(prop.getName())) {
                    ModelNode childDescr = childDescriptions.get(prop.getName());
                    Integer maxOccurs = this.getAsInteger(childDescr, "max-occurs");
                    childrenTable.addLine(prop.getName(), this.getAsString(childDescr, "min-occurs"), maxOccurs == null ? "n/a" : (maxOccurs == Integer.MAX_VALUE ? "unbounded" : maxOccurs.toString()));
                    continue;
                }
                childrenTable.addLine(prop.getName(), "n/a", "n/a");
            }
            StringBuilder buf = null;
            if (attrTable != null && !attrTable.isEmpty()) {
                buf = new StringBuilder();
                attrTable.append(buf, true);
            }
            if (childrenTable != null && !childrenTable.isEmpty()) {
                if (buf == null) {
                    buf = new StringBuilder();
                } else {
                    buf.append("\n\n");
                }
                childrenTable.append(buf, true);
            }
            if (buf != null) {
                ctx.printLine(buf.toString());
            }
        }
        if (names == null) return;
        this.printList(ctx, names, this.l.isPresent(parsedCmd));
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        OperationRequestAddress address = this.getOperationRequestAddress(ctx);
        if (address.endsOnType()) {
            String type = address.getNodeType();
            address.toParentNode();
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(address);
            try {
                builder.setOperationName("read-children-names");
                builder.addProperty("child-type", type);
                return builder.buildRequest();
            }
            catch (OperationFormatException e) {
                throw new IllegalStateException("Failed to build operation", e);
            }
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        ModelNode typesRequest = new ModelNode();
        typesRequest.get("operation").set("read-children-types");
        typesRequest = this.getAddressNode(ctx, address, typesRequest);
        steps.add(typesRequest);
        ModelNode resourceRequest = new ModelNode();
        resourceRequest.get("operation").set("read-resource");
        resourceRequest = this.getAddressNode(ctx, address, resourceRequest);
        resourceRequest.get("include-runtime").set("true");
        if (this.resolve.isPresent(parsedCmd)) {
            resourceRequest.get("resolve-expressions").set("true");
        }
        steps.add(resourceRequest);
        if (this.l.isPresent(parsedCmd)) {
            steps.add(Util.buildRequest(ctx, address, "read-resource-description"));
        }
        return composite;
    }

    @Override
    protected Map<String, CommandArgument> getArgumentsMap(CommandContext ctx) {
        HashMap<String, CommandArgument> ret = new HashMap<String, CommandArgument>(super.getArgumentsMap(ctx));
        try {
            Map<String, CommandArgument> dyns = this.getDynamicOptions(ctx);
            ret.putAll(dyns);
        }
        catch (CommandFormatException ex) {
            Logger.getLogger(this.getClass()).trace((Object)"Exception while retreiving ls description properties", (Throwable)ex);
        }
        return ret;
    }

    @Override
    public Collection<CommandArgument> getArguments(CommandContext ctx) {
        ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(super.getArguments(ctx));
        try {
            args.addAll(this.getDynamicOptions(ctx).values());
        }
        catch (CommandFormatException ex) {
            Logger.getLogger(this.getClass()).trace((Object)"Exception while retreiving ls description properties", (Throwable)ex);
        }
        return args;
    }

    private Map<String, CommandArgument> getDynamicOptions(CommandContext ctx) throws CommandFormatException {
        if (ctx.getModelControllerClient() == null) {
            return Collections.emptyMap();
        }
        OperationRequestAddress address = this.getOperationRequestAddress(ctx);
        if (address.endsOnType()) {
            return Collections.emptyMap();
        }
        ModelNode req = new ModelNode();
        if (address.isEmpty()) {
            req.get("address").setEmptyList();
        } else {
            ModelNode addrNode = req.get("address");
            for (OperationRequestAddress.Node node : address) {
                addrNode.add(node.getType(), node.getName());
            }
        }
        req.get("operation").set("read-resource-description");
        Map<String, CommandArgument> options = Collections.emptyMap();
        try {
            ModelNode result;
            ModelNode response = ctx.getModelControllerClient().execute(req);
            if (Util.isSuccess(response) && response.hasDefined("result") && (result = response.get("result")).hasDefined("attributes")) {
                options = new TreeMap<String, CommandArgument>();
                ModelNode attributes = result.get("attributes");
                for (String key : attributes.keys()) {
                    ModelNode attribute = attributes.get(key);
                    for (String k : attribute.keys()) {
                        ArgumentWithoutValue wv = new ArgumentWithoutValue(new CommandHandlerWithArguments(){

                            @Override
                            public boolean isAvailable(CommandContext ctx) {
                                return LsHandler.this.isAvailable(ctx);
                            }

                            @Override
                            public boolean isBatchMode(CommandContext ctx) {
                                return LsHandler.this.isBatchMode(ctx);
                            }

                            @Override
                            public void handle(CommandContext ctx) throws CommandLineException {
                                LsHandler.this.handle(ctx);
                            }

                            @Override
                            public void addArgument(CommandArgument arg) {
                            }
                        }, "--" + k);
                        wv.addRequiredPreceding(this.l);
                        options.put("--" + k, wv);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return options;
    }

    protected String getAsString(ModelNode attrDescr, String name) {
        if (attrDescr == null) {
            return "n/a";
        }
        return attrDescr.has(name) ? attrDescr.get(name).asString() : "n/a";
    }

    protected Integer getAsInteger(ModelNode attrDescr, String name) {
        if (attrDescr == null) {
            return null;
        }
        return attrDescr.has(name) ? Integer.valueOf(attrDescr.get(name).asInt()) : null;
    }

    private OperationRequestAddress getOperationRequestAddress(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestAddress address;
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        String nodePathString = this.nodePath.getValue(parsedCmd);
        if (nodePathString != null) {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
            nodePathString = ctx.getArgumentsString();
            if (nodePathString == null) {
                nodePathString = parsedCmd.getOriginalLine();
                int cmdNameLength = parsedCmd.getOperationName().length();
                if (nodePathString.length() == cmdNameLength) {
                    return address;
                }
                nodePathString = nodePathString.substring(cmdNameLength + 1);
            }
            nodePathString = LsHandler.getNodePath(nodePathString);
            DefaultCallbackHandler handler = new DefaultCallbackHandler(address);
            ctx.getCommandLineParser().parse(nodePathString, handler);
        } else {
            address = new DefaultOperationRequestAddress(ctx.getCurrentNodePath());
        }
        return address;
    }

    protected static String getNodePath(String nodePathString) {
        int i = 0;
        while (i < nodePathString.length() && (i = nodePathString.indexOf(45, i)) >= 0) {
            int end;
            StringBuilder buf;
            if (i > 0) {
                if (!Character.isWhitespace(nodePathString.charAt(i - 1))) {
                    ++i;
                    continue;
                }
                buf = new StringBuilder(nodePathString.length());
                buf.append(nodePathString.substring(0, i - 1));
            } else {
                buf = new StringBuilder(nodePathString.length());
            }
            for (end = i + 1; end < nodePathString.length() && !Character.isWhitespace(nodePathString.charAt(end)); ++end) {
            }
            if (end < nodePathString.length()) {
                buf.append(nodePathString.substring(end));
            }
            nodePathString = buf.toString();
        }
        return nodePathString.trim();
    }

    private ModelNode getAddressNode(CommandContext ctx, OperationRequestAddress address, ModelNode op) throws CommandFormatException {
        ModelNode addressNode = op.get("address");
        if (address.isEmpty()) {
            addressNode.setEmptyList();
        } else {
            Iterator iterator = address.iterator();
            while (iterator.hasNext()) {
                OperationRequestAddress.Node node = (OperationRequestAddress.Node)iterator.next();
                if (node.getName() != null) {
                    if (node.getName().equals("*")) {
                        throw new CommandFormatException("* is not supported in node path argument");
                    }
                    addressNode.add(node.getType(), node.getName());
                    continue;
                }
                if (!iterator.hasNext()) continue;
                throw new OperationFormatException("Expected a node name for type '" + node.getType() + "' in path '" + ctx.getNodePathFormatter().format(address) + "'");
            }
        }
        return op;
    }
}

