/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.configuration.cache.EvictionConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionType;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class EvictionBuilder
extends ComponentBuilder<EvictionConfiguration> {
    private volatile EvictionStrategy strategy;
    private volatile long maxEntries;

    EvictionBuilder(PathAddress cacheAddress) {
        super(CacheComponent.EVICTION, cacheAddress);
    }

    public Builder<EvictionConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.strategy = (EvictionStrategy)ModelNodes.asEnum((ModelNode)EvictionResourceDefinition.Attribute.STRATEGY.resolveModelAttribute((ExpressionResolver)context, model), EvictionStrategy.class);
        this.maxEntries = EvictionResourceDefinition.Attribute.MAX_ENTRIES.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return this;
    }

    public EvictionConfiguration getValue() {
        EvictionConfigurationBuilder builder = new ConfigurationBuilder().eviction().strategy(this.strategy.isEnabled() ? this.strategy : EvictionStrategy.MANUAL);
        if (this.strategy.isEnabled()) {
            builder.type(EvictionType.COUNT).size(this.maxEntries);
        }
        return builder.create();
    }
}

