/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.ExpirationConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.ComponentBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.Builder;

public class ExpirationBuilder
extends ComponentBuilder<ExpirationConfiguration> {
    private volatile long interval;
    private volatile long lifespan;
    private volatile long maxIdle;

    ExpirationBuilder(PathAddress cacheAddress) {
        super(CacheComponent.EXPIRATION, cacheAddress);
    }

    public Builder<ExpirationConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.interval = ExpirationResourceDefinition.Attribute.INTERVAL.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.lifespan = ExpirationResourceDefinition.Attribute.LIFESPAN.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        this.maxIdle = ExpirationResourceDefinition.Attribute.MAX_IDLE.resolveModelAttribute((ExpressionResolver)context, model).asLong();
        return this;
    }

    public ExpirationConfiguration getValue() {
        return new ConfigurationBuilder().expiration().wakeUpInterval(this.interval).lifespan(this.lifespan).maxIdle(this.maxIdle).create();
    }
}

