/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.remoting.transport.Address;

public class EntryRequestCommand<K, V, C>
extends BaseRpcCommand
implements TopologyAffectedCommand {
    public static final byte COMMAND_ID = 41;
    private UUID identifier;
    private Set<Integer> segments;
    private Set<K> keysToFilter;
    private KeyValueFilter<? super K, ? super V> filter;
    private Converter<? super K, ? super V, C> converter;
    private Set<Flag> flags;
    private int topologyId = -1;
    private EntryRetriever<K, V> entryRetrieverManager;

    private EntryRequestCommand() {
        super(null);
    }

    public EntryRequestCommand(String cacheName) {
        super(cacheName);
    }

    public EntryRequestCommand(String cacheName, UUID identifier, Address origin, Set<Integer> segments, Set<K> keysToFilter, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter, Set<Flag> flags) {
        super(cacheName);
        this.setOrigin(origin);
        this.identifier = identifier;
        this.segments = segments;
        this.keysToFilter = keysToFilter;
        this.filter = filter;
        this.converter = converter;
        this.flags = flags;
    }

    @Inject
    public void init(EntryRetriever<K, V> entryRetrieverManager) {
        this.entryRetrieverManager = entryRetrieverManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        this.entryRetrieverManager.startRetrievingValues(this.identifier, this.getOrigin(), this.segments, this.keysToFilter, this.filter, this.converter, this.flags);
        return null;
    }

    @Override
    public byte getCommandId() {
        return 41;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallUUID((UUID)this.identifier, (ObjectOutput)output, (boolean)false);
        output.writeObject(this.getOrigin());
        MarshallUtil.marshallCollection(this.segments, (ObjectOutput)output);
        MarshallUtil.marshallCollection(this.keysToFilter, (ObjectOutput)output);
        output.writeObject(this.filter);
        output.writeObject(this.converter);
        output.writeInt(this.topologyId);
        output.writeObject(Flag.copyWithoutRemotableFlags(this.flags));
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.identifier = MarshallUtil.unmarshallUUID((ObjectInput)input, (boolean)false);
        this.setOrigin((Address)input.readObject());
        this.segments = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.keysToFilter = (Set)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, HashSet::new);
        this.filter = (KeyValueFilter)input.readObject();
        this.converter = (Converter)input.readObject();
        this.topologyId = input.readInt();
        this.flags = (Set)input.readObject();
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public String toString() {
        return "EntryRequestCommand{identifier=" + this.identifier + ", segments=" + this.segments + ", keysToFilter=" + this.keysToFilter + ", filter=" + this.filter + ", converter=" + this.converter + ", topologyId=" + this.topologyId + ", flags=" + this.flags + '}';
    }
}

