/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.subsystem.EJB3SubsystemRootResourceDefinition;
import org.jboss.as.ejb3.suspend.EJBSuspendHandlerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;

public class EnableGracefulTxnShutdownWriteHandler
extends AbstractWriteAttributeHandler<Void> {
    public static final EnableGracefulTxnShutdownWriteHandler INSTANCE = new EnableGracefulTxnShutdownWriteHandler(new AttributeDefinition[]{EJB3SubsystemRootResourceDefinition.ENABLE_GRACEFUL_TXN_SHUTDOWN});
    private final AttributeDefinition gracefulTxnShutdownAttribute;

    EnableGracefulTxnShutdownWriteHandler(AttributeDefinition ... attributes) {
        super(attributes);
        this.gracefulTxnShutdownAttribute = attributes[0];
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        ModelNode model = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
        this.applyModelToRuntime(context, operation, attributeName, model);
        return false;
    }

    private void applyModelToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode model) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(true);
        EJBSuspendHandlerService service = (EJBSuspendHandlerService)registry.getRequiredService(EJBSuspendHandlerService.SERVICE_NAME).getValue();
        if (service != null && this.gracefulTxnShutdownAttribute.getName().equals(attributeName)) {
            boolean enableGracefulTxnShutdown = this.gracefulTxnShutdownAttribute.resolveModelAttribute(context, model).asBoolean();
            service.enableGracefulTxnShutdown(enableGracefulTxnShutdown);
        }
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        ModelNode restored = context.readResource(PathAddress.EMPTY_ADDRESS).getModel().clone();
        restored.get(attributeName).set(valueToRestore);
        this.applyModelToRuntime(context, operation, attributeName, restored);
    }
}

