/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http2;

import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.conduits.BytesReceivedStreamSourceConduit;
import io.undertow.conduits.BytesSentStreamSinkConduit;
import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import io.undertow.protocols.http2.Http2Channel;
import io.undertow.server.ConnectorStatistics;
import io.undertow.server.ConnectorStatisticsImpl;
import io.undertow.server.DelegateOpenListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.XnioByteBufferPool;
import io.undertow.server.protocol.http2.Http2ReceiveListener;
import java.nio.ByteBuffer;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.StreamConnection;

public final class Http2OpenListener
implements ChannelListener<StreamConnection>,
DelegateOpenListener {
    public static final String HTTP2 = "h2";
    @Deprecated
    public static final String HTTP2_14 = "h2-14";
    private final ByteBufferPool bufferPool;
    private final int bufferSize;
    private final ChannelListener<Http2Channel> closeTask = new ChannelListener<Http2Channel>(){

        @Override
        public void handleEvent(Http2Channel channel) {
            Http2OpenListener.this.connectorStatistics.decrementConnectionCount();
        }
    };
    private volatile HttpHandler rootHandler;
    private volatile OptionMap undertowOptions;
    private volatile boolean statisticsEnabled;
    private final ConnectorStatisticsImpl connectorStatistics;
    private final String protocol;

    @Deprecated
    public Http2OpenListener(Pool<ByteBuffer> pool) {
        this(pool, OptionMap.EMPTY);
    }

    @Deprecated
    public Http2OpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions) {
        this(pool, undertowOptions, HTTP2);
    }

    @Deprecated
    public Http2OpenListener(Pool<ByteBuffer> pool, OptionMap undertowOptions, String protocol) {
        this(new XnioByteBufferPool(pool), undertowOptions, protocol);
    }

    public Http2OpenListener(ByteBufferPool pool) {
        this(pool, OptionMap.EMPTY);
    }

    public Http2OpenListener(ByteBufferPool pool, OptionMap undertowOptions) {
        this(pool, undertowOptions, HTTP2);
    }

    public Http2OpenListener(ByteBufferPool pool, OptionMap undertowOptions, String protocol) {
        this.undertowOptions = undertowOptions;
        this.bufferPool = pool;
        PooledByteBuffer buf = pool.allocate();
        this.bufferSize = buf.getBuffer().remaining();
        buf.close();
        this.connectorStatistics = new ConnectorStatisticsImpl();
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_STATISTICS, false);
        this.protocol = protocol;
    }

    @Override
    public void handleEvent(StreamConnection channel, PooledByteBuffer buffer) {
        if (UndertowLogger.REQUEST_LOGGER.isTraceEnabled()) {
            UndertowLogger.REQUEST_LOGGER.tracef("Opened HTTP/2 connection with %s", (Object)channel.getPeerAddress());
        }
        Http2Channel http2Channel = new Http2Channel(channel, this.protocol, this.bufferPool, buffer, false, false, this.undertowOptions);
        Integer idleTimeout = this.undertowOptions.get(UndertowOptions.IDLE_TIMEOUT);
        if (idleTimeout != null && idleTimeout > 0) {
            http2Channel.setIdleTimeout(idleTimeout.intValue());
        }
        if (this.statisticsEnabled) {
            channel.getSinkChannel().setConduit(new BytesSentStreamSinkConduit(channel.getSinkChannel().getConduit(), this.connectorStatistics.sentAccumulator()));
            channel.getSourceChannel().setConduit(new BytesReceivedStreamSourceConduit(channel.getSourceChannel().getConduit(), this.connectorStatistics.receivedAccumulator()));
            this.connectorStatistics.incrementConnectionCount();
            http2Channel.addCloseTask(this.closeTask);
        }
        http2Channel.getReceiveSetter().set(new Http2ReceiveListener(this.rootHandler, this.getUndertowOptions(), this.bufferSize, this.connectorStatistics));
        http2Channel.resumeReceives();
    }

    @Override
    public ConnectorStatistics getConnectorStatistics() {
        if (this.statisticsEnabled) {
            return this.connectorStatistics;
        }
        return null;
    }

    @Override
    public HttpHandler getRootHandler() {
        return this.rootHandler;
    }

    @Override
    public void setRootHandler(HttpHandler rootHandler) {
        this.rootHandler = rootHandler;
    }

    @Override
    public OptionMap getUndertowOptions() {
        return this.undertowOptions;
    }

    @Override
    public void setUndertowOptions(OptionMap undertowOptions) {
        if (undertowOptions == null) {
            throw UndertowMessages.MESSAGES.argumentCannotBeNull("undertowOptions");
        }
        this.undertowOptions = undertowOptions;
        this.statisticsEnabled = undertowOptions.get(UndertowOptions.ENABLE_CONNECTOR_STATISTICS, false);
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    @Override
    public void handleEvent(StreamConnection channel) {
        this.handleEvent(channel, null);
    }
}

