/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class SessionQueueQueryMessage
extends PacketImpl {
    private SimpleString queueName;

    public SessionQueueQueryMessage(SimpleString queueName) {
        super((byte)45);
        this.queueName = queueName;
    }

    public SessionQueueQueryMessage() {
        super((byte)45);
    }

    public SimpleString getQueueName() {
        return this.queueName;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.queueName);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.queueName = buffer.readSimpleString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer(this.getParentString());
        buff.append(", queueName=" + this.queueName);
        buff.append("]");
        return buff.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryMessage)) {
            return false;
        }
        SessionQueueQueryMessage other = (SessionQueueQueryMessage)obj;
        return !(this.queueName == null ? other.queueName != null : !this.queueName.equals((Object)other.queueName));
    }
}

