/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.flow.FlowImpl;
import com.sun.faces.util.Util;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.Parameter;

public class FlowHandlerImpl
extends FlowHandler {
    public static final String ABANDONED_FLOW = "javax.faces.flow.AbandonedFlow";
    private boolean flowFeatureIsEnabled = false;
    private final Map<String, Map<String, Flow>> flows = new ConcurrentHashMap<String, Map<String, Flow>>();
    private final Map<String, List<Flow>> flowsByFlowId = new ConcurrentHashMap<String, List<Flow>>();
    public static final String FLOW_RETURN_DEPTH_PARAM_NAME = "jffrd";

    public Map<Object, Object> getCurrentFlowScope() {
        return FlowCDIContext.getCurrentFlowScopeAndUpdateSession();
    }

    public Flow getFlow(FacesContext context, String definingDocumentId, String id) {
        Util.notNull("context", context);
        Util.notNull("definingDocumentId", definingDocumentId);
        Util.notNull("id", id);
        Flow result = null;
        Map<String, Flow> mapsForDefiningDocument = this.flows.get(definingDocumentId);
        if (null != mapsForDefiningDocument) {
            result = mapsForDefiningDocument.get(id);
        }
        return result;
    }

    public void addFlow(FacesContext context, Flow toAdd) {
        Flow oldFlow;
        Util.notNull("context", context);
        Util.notNull("toAdd", toAdd);
        String id = toAdd.getId();
        if (null == id || 0 == id.length()) {
            throw new IllegalArgumentException("The id of the flow may not be null or zero-length.");
        }
        String definingDocumentId = toAdd.getDefiningDocumentId();
        if (null == definingDocumentId) {
            throw new IllegalArgumentException("The definingDocumentId of the flow may not be null.");
        }
        Map<String, Flow> mapsForDefiningDocument = this.flows.get(definingDocumentId);
        if (null == mapsForDefiningDocument) {
            mapsForDefiningDocument = new ConcurrentHashMap<String, Flow>();
            this.flows.put(toAdd.getDefiningDocumentId(), mapsForDefiningDocument);
        }
        if (null != (oldFlow = mapsForDefiningDocument.put(id, toAdd))) {
            String message = MessageFormat.format("Flow with id \"{0}\" and definingDocumentId \"{1}\" already exists.", id, definingDocumentId);
            throw new IllegalStateException(message);
        }
        List<Flow> flowsWithId = this.flowsByFlowId.get(id);
        if (null == flowsWithId) {
            flowsWithId = new CopyOnWriteArrayList<Flow>();
            this.flowsByFlowId.put(id, flowsWithId);
        }
        flowsWithId.add(toAdd);
        NavigationHandler navigationHandler = context.getApplication().getNavigationHandler();
        if (navigationHandler instanceof ConfigurableNavigationHandler) {
            ((ConfigurableNavigationHandler)navigationHandler).inspectFlow(context, toAdd);
        }
        this.flowFeatureIsEnabled = true;
    }

    public boolean isActive(FacesContext context, String definingDocumentId, String id) {
        Util.notNull("context", context);
        Util.notNull("definingDocumentId", definingDocumentId);
        Util.notNull("id", id);
        boolean result = false;
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        for (Flow cur : flowStack) {
            if (!id.equals(cur.getId()) || !definingDocumentId.equals(cur.getDefiningDocumentId())) continue;
            result = true;
            break;
        }
        return result;
    }

    public Flow getCurrentFlow(FacesContext context) {
        Util.notNull("context", context);
        if (!this.flowFeatureIsEnabled) {
            return null;
        }
        Flow result = null;
        if (null == context.getExternalContext().getSession(false)) {
            return null;
        }
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        int returnDepth = flowStack.getReturnDepth();
        if (flowStack.size() <= returnDepth) {
            return null;
        }
        if (0 < returnDepth) {
            Iterator<Flow> stackIter = flowStack.iterator();
            int i = 0;
            stackIter.next();
            if (stackIter.hasNext()) {
                do {
                    result = stackIter.next();
                } while (++i < returnDepth);
            }
        } else {
            result = FlowHandlerImpl.getFlowStack(context).peekFirst();
        }
        return result;
    }

    public String getLastDisplayedViewId(FacesContext context) {
        Util.notNull("context", context);
        String result = null;
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        result = flowStack.peekLastDisplayedViewId();
        return result;
    }

    public int getAndClearReturnModeDepth(FacesContext context) {
        int result = 0;
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        result = ((FlowDeque)flowStack).getAndClearMaxReturnDepth(context);
        return result;
    }

    public void pushReturnMode(FacesContext context) {
        Util.notNull("context", context);
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        flowStack.pushReturnMode();
    }

    public void popReturnMode(FacesContext context) {
        Util.notNull("context", context);
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        flowStack.popReturnMode();
    }

    public void transition(FacesContext context, Flow sourceFlow, Flow targetFlow, FlowCallNode outboundCallNode, String toViewId) {
        Util.notNull("context", context);
        Util.notNull("toViewId", toViewId);
        if (!this.flowFeatureIsEnabled) {
            return;
        }
        if (!this.flowsEqual(sourceFlow, targetFlow)) {
            HashMap<String, Object> evaluatedParams = null;
            if (null != outboundCallNode) {
                Map outboundParameters = outboundCallNode.getOutboundParameters();
                Map inboundParameters = targetFlow.getInboundParameters();
                if (null != outboundParameters && !outboundParameters.isEmpty() && null != inboundParameters && !inboundParameters.isEmpty()) {
                    ELContext elContext = context.getELContext();
                    for (Map.Entry curOutbound : outboundParameters.entrySet()) {
                        String curName = (String)curOutbound.getKey();
                        if (!inboundParameters.containsKey(curName)) continue;
                        if (null == evaluatedParams) {
                            evaluatedParams = new HashMap<String, Object>();
                        }
                        evaluatedParams.put(curName, ((Parameter)curOutbound.getValue()).getValue().getValue(elContext));
                    }
                }
            }
            this.performPops(context, sourceFlow, targetFlow);
            if (null != targetFlow && !targetFlow.equals(FlowImpl.ABANDONED_FLOW)) {
                this.pushFlow(context, targetFlow, toViewId, evaluatedParams);
            } else {
                this.assignInboundParameters(context, targetFlow, evaluatedParams);
            }
        }
    }

    private void assignInboundParameters(FacesContext context, Flow calledFlow, Map<String, Object> evaluatedParams) {
        if (null != evaluatedParams) {
            Map inboundParameters = calledFlow.getInboundParameters();
            ELContext elContext = context.getELContext();
            for (Map.Entry<String, Object> curOutbound : evaluatedParams.entrySet()) {
                String curName = curOutbound.getKey();
                assert (inboundParameters.containsKey(curName));
                ValueExpression toSet = ((Parameter)inboundParameters.get(curName)).getValue();
                toSet.setValue(elContext, curOutbound.getValue());
            }
        }
    }

    public void clientWindowTransition(FacesContext context) {
        Map requestParamMap = context.getExternalContext().getRequestParameterMap();
        String toFlowDocumentId = (String)requestParamMap.get("jftfdi");
        String flowId = (String)requestParamMap.get("jffi");
        if (null != toFlowDocumentId) {
            FlowHandler fh = context.getApplication().getFlowHandler();
            Flow sourceFlow = fh.getCurrentFlow(context);
            Flow targetFlow = null;
            FlowCallNode flowCallNode = null;
            if (null != flowId && !"javax.faces.flow.NullFlow".equals(toFlowDocumentId)) {
                targetFlow = fh.getFlow(context, toFlowDocumentId, flowId);
                if (null != targetFlow && null != sourceFlow) {
                    flowCallNode = sourceFlow.getFlowCall(targetFlow);
                }
            } else {
                String maxReturnDepthStr = (String)requestParamMap.get(FLOW_RETURN_DEPTH_PARAM_NAME);
                int maxReturnDepth = Integer.valueOf(maxReturnDepthStr);
                FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
                ((FlowDeque)flowStack).setMaxReturnDepth(context, maxReturnDepth);
            }
            fh.transition(context, sourceFlow, targetFlow, flowCallNode, context.getViewRoot().getViewId());
        }
    }

    private void performPops(FacesContext context, Flow sourceFlow, Flow targetFlow) {
        if (null == sourceFlow) {
            assert (null == this.peekFlow(context));
            return;
        }
        if (null == targetFlow) {
            FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
            int maxReturns = ((FlowDeque)flowStack).getAndClearMaxReturnDepth(context);
            for (int i = 0; i < maxReturns; ++i) {
                this.popFlow(context);
            }
            return;
        }
        if (FlowImpl.ABANDONED_FLOW.equals(targetFlow)) {
            FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
            int depth = flowStack.size();
            for (int i = 0; i < depth; ++i) {
                this.popFlow(context);
            }
            return;
        }
        if (null == sourceFlow.getFlowCall(targetFlow)) {
            this.popFlow(context);
        }
    }

    private boolean flowsEqual(Flow flow1, Flow flow2) {
        boolean result = false;
        result = flow1 == flow2 ? true : (null == flow1 || null == flow2 ? false : flow1.equals(flow2));
        return result;
    }

    private void pushFlow(FacesContext context, Flow toPush, String lastDisplayedViewId, Map<String, Object> evaluatedParams) {
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        flowStack.addFirst(toPush, lastDisplayedViewId);
        FlowCDIContext.flowEntered();
        this.assignInboundParameters(context, toPush, evaluatedParams);
        MethodExpression me = toPush.getInitializer();
        if (null != me) {
            me.invoke(context.getELContext(), null);
        }
        this.forceSessionUpdateForFlowStack(context, flowStack);
    }

    private Flow peekFlow(FacesContext context) {
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        return flowStack.peekFirst();
    }

    private Flow popFlow(FacesContext context) {
        FlowDeque<Flow> flowStack = FlowHandlerImpl.getFlowStack(context);
        Flow currentFlow = this.peekFlow(context);
        if (null != currentFlow) {
            this.callFinalizer(context, currentFlow, flowStack.size());
        }
        Flow result = flowStack.pollFirst();
        this.forceSessionUpdateForFlowStack(context, flowStack);
        return result;
    }

    private void callFinalizer(FacesContext context, Flow currentFlow, int depth) {
        MethodExpression me = currentFlow.getFinalizer();
        if (null != me) {
            me.invoke(context.getELContext(), null);
        }
        FlowCDIContext.flowExited(currentFlow, depth);
    }

    static FlowDeque<Flow> getFlowStack(FacesContext context) {
        FlowDeque result = null;
        ExternalContext extContext = context.getExternalContext();
        String sessionKey = extContext.getClientWindow().getId() + "_flowStack";
        Map sessionMap = extContext.getSessionMap();
        result = (FlowDeque)sessionMap.get(sessionKey);
        if (null == result) {
            result = new FlowDeque(sessionKey);
            sessionMap.put(sessionKey, result);
        }
        return result;
    }

    private void forceSessionUpdateForFlowStack(FacesContext context, FlowDeque<Flow> stack) {
        ExternalContext extContext = context.getExternalContext();
        Map sessionMap = extContext.getSessionMap();
        sessionMap.put(stack.getSessionKey(), stack);
    }

    static class FlowDeque<E>
    implements Iterable<E>,
    Serializable {
        private static final long serialVersionUID = 7915803727932706270L;
        private int returnDepth;
        private ArrayDeque<E> data = new ArrayDeque();
        private ArrayDeque<RideAlong> rideAlong = new ArrayDeque();
        private final String sessionKey;

        public FlowDeque(String sessionKey) {
            this.sessionKey = sessionKey;
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public int size() {
            return this.data.size();
        }

        @Override
        public Iterator<E> iterator() {
            return this.data.iterator();
        }

        public void addFirst(E e, String lastDisplayedViewId) {
            this.rideAlong.addFirst(new RideAlong(lastDisplayedViewId));
            this.data.addFirst(e);
        }

        public E pollFirst() {
            this.rideAlong.pollFirst();
            return this.data.pollFirst();
        }

        public int getCurrentFlowDepth() {
            int returnDepth = this.returnDepth;
            if (this.data.size() <= returnDepth) {
                return 0;
            }
            int result = this.data.size();
            if (0 < returnDepth) {
                Iterator<E> stackIter = this.data.iterator();
                for (int i = 0; stackIter.hasNext() && i < returnDepth; ++i) {
                    stackIter.next();
                    --result;
                }
            }
            return result;
        }

        public E peekFirst() {
            return this.data.peekFirst();
        }

        public String peekLastDisplayedViewId() {
            String result = null;
            RideAlong helper = null;
            int myReturnDepth = this.getReturnDepth();
            if (0 < myReturnDepth) {
                Iterator<RideAlong> stackIter = this.rideAlong.iterator();
                stackIter.next();
                int i = 0;
                if (stackIter.hasNext()) {
                    do {
                        helper = stackIter.next();
                    } while (++i < myReturnDepth);
                }
            } else {
                helper = this.rideAlong.peekFirst();
            }
            if (null != helper) {
                result = helper.lastDisplayedViewId;
            }
            return result;
        }

        public int getReturnDepth() {
            return this.returnDepth;
        }

        private void setMaxReturnDepth(FacesContext context, int value) {
            Map attrs = context.getAttributes();
            attrs.put(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME, value);
        }

        private int getAndClearMaxReturnDepth(FacesContext context) {
            Map attrs = context.getAttributes();
            int result = 0;
            if (attrs.containsKey(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME)) {
                result = (Integer)attrs.remove(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME);
            }
            return result;
        }

        private void incrementMaxReturnDepth() {
            FacesContext context = FacesContext.getCurrentInstance();
            Map attrs = context.getAttributes();
            if (!attrs.containsKey(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME)) {
                attrs.put(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME, 1);
            } else {
                Integer cur = (Integer)attrs.get(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME);
                attrs.put(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME, cur + 1);
            }
        }

        public void pushReturnMode() {
            this.incrementMaxReturnDepth();
            ++this.returnDepth;
        }

        public void popReturnMode() {
            --this.returnDepth;
        }

        private static class RideAlong
        implements Serializable {
            String lastDisplayedViewId;

            public RideAlong(String lastDisplayedViewId) {
                this.lastDisplayedViewId = lastDisplayedViewId;
            }
        }
    }
}

