/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.encryption.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.OInvalidStorageEncryptionKeyException;

public abstract class OAbstractEncryption
implements OEncryption {
    public abstract byte[] encryptOrDecrypt(int var1, byte[] var2, int var3, int var4) throws Exception;

    @Override
    public byte[] encrypt(byte[] content) {
        return this.encrypt(content, 0, content.length);
    }

    @Override
    public byte[] decrypt(byte[] content) {
        return this.decrypt(content, 0, content.length);
    }

    @Override
    public byte[] encrypt(byte[] content, int offset, int length) {
        try {
            return this.encryptOrDecrypt(1, content, offset, length);
        }
        catch (Exception e) {
            throw OException.wrapException(new OInvalidStorageEncryptionKeyException("Cannot encrypt content"), e);
        }
    }

    @Override
    public byte[] decrypt(byte[] content, int offset, int length) {
        try {
            return this.encryptOrDecrypt(2, content, offset, length);
        }
        catch (Exception e) {
            throw OException.wrapException(new OInvalidStorageEncryptionKeyException("Cannot decrypt content"), e);
        }
    }
}

