/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.schedule.OScheduledEvent;
import com.orientechnologies.orient.core.schedule.OScheduler;
import java.util.Arrays;
import java.util.HashSet;

public class OSchedulerTrigger
extends ODocumentHookAbstract {
    public OSchedulerTrigger(ODatabaseDocument database) {
        super(database);
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    @Override
    public ORecordHook.RESULT onTrigger(ORecordHook.TYPE iType, ORecord iRecord) {
        OImmutableClass clazz = null;
        if (iRecord instanceof ODocument) {
            clazz = ODocumentInternal.getImmutableSchemaClass((ODocument)iRecord);
        }
        if (clazz == null || !clazz.isScheduler()) {
            return ORecordHook.RESULT.RECORD_NOT_CHANGED;
        }
        return super.onTrigger(iType, iRecord);
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        String name = (String)iDocument.field("name");
        OScheduledEvent event = this.database.getMetadata().getScheduler().getEvent(name);
        if (event != null && event.getDocument() != iDocument) {
            throw new ODatabaseException("Scheduled event with name '" + name + "' already exists in database");
        }
        iDocument.field("status", OScheduler.STATUS.STOPPED.name());
        return ORecordHook.RESULT.RECORD_CHANGED;
    }

    @Override
    public void onRecordAfterCreate(ODocument iDocument) {
        this.database.getMetadata().getScheduler().scheduleEvent(new OScheduledEvent(iDocument));
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        try {
            String schedulerName = (String)iDocument.field("name");
            OScheduledEvent event = this.database.getMetadata().getScheduler().getEvent(schedulerName);
            if (event != null) {
                HashSet<String> dirtyFields = new HashSet<String>(Arrays.asList(iDocument.getDirtyFields()));
                if (dirtyFields.contains("name")) {
                    throw new OValidationException("Scheduled event cannot change name");
                }
                if (dirtyFields.contains("rule")) {
                    this.database.getMetadata().getScheduler().removeEvent(event.getName());
                    this.database.getMetadata().getScheduler().scheduleEvent(new OScheduledEvent(iDocument));
                }
                iDocument.field("status", OScheduler.STATUS.STOPPED.name());
                event.fromStream(iDocument);
                return ORecordHook.RESULT.RECORD_CHANGED;
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error((Object)this, "Error on updating scheduled event", ex, new Object[0]);
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        String eventName = (String)iDocument.field("name");
        OScheduledEvent scheduler = this.database.getMetadata().getScheduler().getEvent(eventName);
        if (scheduler != null) {
            this.database.getMetadata().getScheduler().removeEvent(eventName);
        }
        return ORecordHook.RESULT.RECORD_CHANGED;
    }
}

