/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

final class OLogSegment
implements Comparable<OLogSegment> {
    private final OByteBufferPool byteBufferPool = OByteBufferPool.instance();
    private ODiskWriteAheadLog writeAheadLog;
    private RandomAccessFile rndFile;
    private final Lock fileLock = new ReentrantLock();
    private final AtomicBoolean autoCloseInProgress = new AtomicBoolean();
    private volatile boolean preventAutoClose = false;
    private final File file;
    private volatile boolean closeNextTime;
    private final int fileTTL;
    private final ScheduledExecutorService closer = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("WAL Closer Task (" + OLogSegment.this.writeAheadLog.getStorage().getName() + ")");
            return thread;
        }
    });
    private final long order;
    private final int maxPagesCacheSize;
    private final OPerformanceStatisticManager performanceStatisticManager;
    protected final Lock cacheLock = new ReentrantLock();
    private volatile List<OLogRecord> logCache = new ArrayList<OLogRecord>();
    private final ScheduledExecutorService commitExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB WAL Flush Task (" + OLogSegment.this.writeAheadLog.getStorage().getName() + ")");
            return thread;
        }
    });
    private volatile long filledUpTo;
    private boolean closed;
    private OLogSequenceNumber last = null;
    private OLogSequenceNumber pendingLSNToFlush;
    private volatile boolean flushNewData = true;
    private WeakReference<OPair<OLogSequenceNumber, byte[]>> lastReadRecord = new WeakReference<Object>(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitLog() throws IOException {
        if (!this.flushNewData) {
            return;
        }
        OSessionStoragePerformanceStatistic statistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
        if (statistic != null) {
            statistic.startWALFlushTimer();
        }
        try {
            RandomAccessFile rndFile;
            List<OLogRecord> toFlush;
            this.flushNewData = false;
            try {
                this.cacheLock.lock();
                if (this.logCache.isEmpty()) {
                    return;
                }
                toFlush = this.logCache;
                this.logCache = new ArrayList<OLogRecord>();
            }
            finally {
                this.cacheLock.unlock();
            }
            if (toFlush.isEmpty()) {
                return;
            }
            byte[] pageContent = new byte[OWALPage.PAGE_SIZE];
            OLogRecord first = toFlush.get(0);
            int curIndex = (int)(first.writeFrom / (long)OWALPage.PAGE_SIZE);
            this.fileLock.lock();
            try {
                RandomAccessFile rndFile2 = this.getRndFile();
                long pagesCount = rndFile2.length() / (long)OWALPage.PAGE_SIZE;
                if (pagesCount > (long)curIndex) {
                    rndFile2.seek(curIndex * OWALPage.PAGE_SIZE);
                    rndFile2.readFully(pageContent);
                }
            }
            finally {
                this.fileLock.unlock();
            }
            OLogSequenceNumber lsn = null;
            int pageIndex = 0;
            int pos = 0;
            boolean lastToFlush = false;
            for (OLogRecord log : toFlush) {
                lsn = new OLogSequenceNumber(this.order, log.writeFrom);
                pos = (int)(log.writeFrom % (long)OWALPage.PAGE_SIZE);
                pageIndex = (int)(log.writeFrom / (long)OWALPage.PAGE_SIZE);
                int written = 0;
                while (written < log.record.length) {
                    int fromRecord;
                    int contentLength;
                    lastToFlush = true;
                    int pageFreeSpace = OWALPage.calculateRecordSize(OWALPage.PAGE_SIZE - pos);
                    if (OWALPage.PAGE_SIZE - (pos = this.writeContentInPage(pageContent, pos, log.record, (written += (contentLength = Math.min(pageFreeSpace, log.record.length - written))) == log.record.length, fromRecord = written, contentLength)) >= 7) continue;
                    this.fileLock.lock();
                    try {
                        RandomAccessFile rndFile3 = this.getRndFile();
                        rndFile3.seek(pageIndex * OWALPage.PAGE_SIZE);
                        this.flushPage(pageContent, rndFile3);
                    }
                    finally {
                        this.fileLock.unlock();
                    }
                    if (this.pendingLSNToFlush != null) {
                        this.writeAheadLog.setFlushedLsn(this.pendingLSNToFlush);
                    }
                    this.pendingLSNToFlush = lsn;
                    lastToFlush = false;
                    ++pageIndex;
                    pos = 16;
                }
            }
            if (lastToFlush) {
                this.fileLock.lock();
                try {
                    rndFile = this.getRndFile();
                    rndFile.seek(pageIndex * OWALPage.PAGE_SIZE);
                    this.flushPage(pageContent, rndFile);
                }
                finally {
                    this.fileLock.unlock();
                }
            }
            if (OGlobalConfiguration.WAL_SYNC_ON_PAGE_FLUSH.getValueAsBoolean()) {
                this.fileLock.lock();
                try {
                    rndFile = this.getRndFile();
                    rndFile.getFD().sync();
                }
                finally {
                    this.fileLock.unlock();
                }
            }
            this.writeAheadLog.setFlushedLsn(lsn);
        }
        finally {
            if (statistic != null) {
                statistic.stopWALFlushTimer();
            }
        }
    }

    private int writeContentInPage(byte[] pageContent, int posInPage, byte[] log, boolean isLast, int fromRecord, int contentLength) {
        OByteSerializer.INSTANCE.serializeNative(!isLast ? (byte)1 : 0, pageContent, posInPage, new Object[0]);
        OByteSerializer.INSTANCE.serializeNative(isLast ? (byte)1 : 0, pageContent, posInPage + 1, new Object[0]);
        OIntegerSerializer.INSTANCE.serializeNative(contentLength, pageContent, posInPage + 2, new Object[0]);
        System.arraycopy(log, fromRecord, pageContent, posInPage + 4 + 2, contentLength);
        OIntegerSerializer.INSTANCE.serializeNative(OWALPage.PAGE_SIZE - (posInPage += OWALPage.calculateSerializedSize(contentLength)), pageContent, 12, new Object[0]);
        return posInPage;
    }

    private void flushPage(byte[] content, RandomAccessFile rndFile) throws IOException {
        OLongSerializer.INSTANCE.serializeNative(4207608830L, content, 4, new Object[0]);
        CRC32 crc32 = new CRC32();
        crc32.update(content, 4, OWALPage.PAGE_SIZE - 4);
        OIntegerSerializer.INSTANCE.serializeNative((int)crc32.getValue(), content, 0, new Object[0]);
        rndFile.write(content);
    }

    OLogSegment(ODiskWriteAheadLog writeAheadLog, File file, int fileTTL, int maxPagesCacheSize, OPerformanceStatisticManager performanceStatisticManager) throws IOException {
        this.writeAheadLog = writeAheadLog;
        this.file = file;
        this.fileTTL = fileTTL;
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.performanceStatisticManager = performanceStatisticManager;
        this.order = this.extractOrder(file.getName());
        this.closed = false;
    }

    public void startFlush() {
        if (this.writeAheadLog.getCommitDelay() > 0) {
            this.commitExecutor.scheduleAtFixedRate(new FlushTask(), this.writeAheadLog.getCommitDelay(), this.writeAheadLog.getCommitDelay(), TimeUnit.MILLISECONDS);
            this.preventAutoClose = true;
        }
    }

    public void stopFlush(boolean flush) {
        if (flush) {
            this.flush();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                    throw new OStorageException("WAL flush task for '" + this.getPath() + "' segment cannot be stopped");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error((Object)this, "Cannot shutdown background WAL commit thread", new Object[0]);
            }
        }
        this.preventAutoClose = false;
    }

    private RandomAccessFile getRndFile() throws IOException {
        if (this.rndFile == null) {
            this.rndFile = new RandomAccessFile(this.file, "rw");
            this.scheduleFileAutoClose();
        } else {
            this.closeNextTime = false;
        }
        return this.rndFile;
    }

    private void scheduleFileAutoClose() {
        if (!this.autoCloseInProgress.get() && this.autoCloseInProgress.compareAndSet(false, true)) {
            this.closeNextTime = true;
            FileCloser task = new FileCloser();
            task.self = this.closer.scheduleWithFixedDelay(task, this.fileTTL, this.fileTTL, TimeUnit.SECONDS);
        }
    }

    public long getOrder() {
        return this.order;
    }

    public void init() throws IOException {
        this.selfCheck();
        this.initPageCache();
        this.last = new OLogSequenceNumber(this.order, this.filledUpTo - 1L);
    }

    @Override
    public int compareTo(OLogSegment other) {
        long otherOrder = other.order;
        if (this.order > otherOrder) {
            return 1;
        }
        if (this.order < otherOrder) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLogSegment that = (OLogSegment)o;
        return this.order == that.order;
    }

    public int hashCode() {
        return (int)(this.order ^ this.order >>> 32);
    }

    public long filledUpTo() throws IOException {
        return this.filledUpTo;
    }

    public OLogSequenceNumber begin() throws IOException {
        if (!this.logCache.isEmpty()) {
            return new OLogSequenceNumber(this.order, 16L);
        }
        this.fileLock.lock();
        try {
            RandomAccessFile rndFile = this.getRndFile();
            if (rndFile.length() > 0L) {
                OLogSequenceNumber oLogSequenceNumber = new OLogSequenceNumber(this.order, 16L);
                return oLogSequenceNumber;
            }
        }
        finally {
            this.fileLock.unlock();
        }
        return null;
    }

    public OLogSequenceNumber end() {
        return this.last;
    }

    public void delete(boolean flush) throws IOException {
        this.close(flush);
        boolean deleted = OFileUtils.delete(this.file);
        int retryCount = 0;
        while (!deleted) {
            deleted = OFileUtils.delete(this.file);
            if (++retryCount <= 10) continue;
            throw new IOException("Cannot delete file. Retry limit exceeded. (" + retryCount + ")");
        }
    }

    public String getPath() {
        return this.file.getAbsolutePath();
    }

    public static OLogRecord generateLogRecord(long starting, byte[] record) {
        long resultSize;
        long from = starting;
        long length = record.length;
        int freePageSpace = OWALPage.PAGE_SIZE - (int)Math.max(starting % (long)OWALPage.PAGE_SIZE, 16L);
        int inPage = OWALPage.calculateRecordSize(freePageSpace);
        if ((long)inPage >= length) {
            long resultSize2 = OWALPage.calculateSerializedSize((int)length);
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 16L;
            }
            return new OLogRecord(record, from, from + resultSize2);
        }
        if (inPage > 0) {
            length -= (long)inPage;
            resultSize = freePageSpace;
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 16L;
            }
        } else {
            from = starting + (long)freePageSpace + 16L;
            resultSize = -16L;
        }
        resultSize += length / (long)OWALPage.calculateRecordSize(OWALPage.MAX_ENTRY_SIZE) * (long)OWALPage.PAGE_SIZE;
        int leftSize = (int)length % OWALPage.calculateRecordSize(OWALPage.MAX_ENTRY_SIZE);
        if (leftSize > 0) {
            resultSize += (long)(16 + OWALPage.calculateSerializedSize(leftSize));
        }
        return new OLogRecord(record, from, from + resultSize);
    }

    public OLogSequenceNumber logRecord(byte[] record) throws IOException {
        long pagesInCache;
        this.flushNewData = true;
        OLogRecord rec = OLogSegment.generateLogRecord(this.filledUpTo, record);
        this.filledUpTo = rec.writeTo;
        this.last = new OLogSequenceNumber(this.order, rec.writeFrom);
        try {
            this.cacheLock.lock();
            this.logCache.add(rec);
        }
        finally {
            this.cacheLock.unlock();
        }
        long flushedPos = 0L;
        if (this.writeAheadLog.getFlushedLsn() != null) {
            flushedPos = this.writeAheadLog.getFlushedLsn().getPosition();
        }
        if ((pagesInCache = (this.filledUpTo - flushedPos) / (long)OWALPage.PAGE_SIZE) > (long)this.maxPagesCacheSize) {
            OLogManager.instance().info((Object)this, "Max cache limit is reached (%d vs. %d), sync flush is performed", this.maxPagesCacheSize, pagesInCache);
            this.writeAheadLog.incrementCacheOverflowCount();
            this.flush();
        }
        return this.last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public byte[] readRecord(OLogSequenceNumber lsn) throws IOException {
        OPair lastRecord = (OPair)this.lastReadRecord.get();
        if (lastRecord != null && ((OLogSequenceNumber)lastRecord.getKey()).equals(lsn)) {
            return (byte[])lastRecord.getValue();
        }
        assert (lsn.getSegment() == this.order);
        if (lsn.getPosition() >= this.filledUpTo) {
            return null;
        }
        if (!this.logCache.isEmpty()) {
            this.flush();
        }
        long pageIndex = lsn.getPosition() / (long)OWALPage.PAGE_SIZE;
        byte[] record = null;
        int pageOffset = (int)(lsn.getPosition() % (long)OWALPage.PAGE_SIZE);
        long pageCount = (this.filledUpTo + (long)OWALPage.PAGE_SIZE - 1L) / (long)OWALPage.PAGE_SIZE;
        while (pageIndex < pageCount) {
            byte[] pageContent = new byte[OWALPage.PAGE_SIZE];
            this.fileLock.lock();
            try {
                RandomAccessFile rndFile = this.getRndFile();
                rndFile.seek(pageIndex * (long)OWALPage.PAGE_SIZE);
                rndFile.readFully(pageContent);
            }
            finally {
                this.fileLock.unlock();
            }
            if (!this.checkPageIntegrity(pageContent)) {
                throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
            }
            ByteBuffer buffer = this.byteBufferPool.acquireDirect(false);
            buffer.put(pageContent);
            try {
                OWALPage page = new OWALPage(buffer, false);
                byte[] content = page.getRecord(pageOffset);
                if (record == null) {
                    record = content;
                } else {
                    byte[] oldRecord = record;
                    record = new byte[record.length + content.length];
                    System.arraycopy(oldRecord, 0, record, 0, oldRecord.length);
                    System.arraycopy(content, 0, record, oldRecord.length, record.length - oldRecord.length);
                }
                if (page.mergeWithNextPage(pageOffset)) {
                    pageOffset = 16;
                    if (++pageIndex < pageCount) continue;
                    throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
                }
                if (page.getFreeSpace() >= 7 && pageIndex < pageCount - 1L) {
                    throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
                }
                break;
            }
            finally {
                this.byteBufferPool.release(buffer);
            }
        }
        this.lastReadRecord = new WeakReference<OPair<OLogSequenceNumber, Object>>(new OPair<OLogSequenceNumber, Object>(lsn, record));
        return record;
    }

    public OLogSequenceNumber getNextLSN(OLogSequenceNumber lsn) throws IOException {
        byte[] record = this.readRecord(lsn);
        if (record == null) {
            return null;
        }
        long pos = lsn.getPosition();
        long pageIndex = pos / (long)OWALPage.PAGE_SIZE;
        int pageOffset = (int)(pos - pageIndex * (long)OWALPage.PAGE_SIZE);
        int restOfRecord = record.length;
        while (restOfRecord > 0) {
            int entrySize = OWALPage.calculateSerializedSize(restOfRecord);
            if (entrySize + pageOffset < OWALPage.PAGE_SIZE) {
                if (entrySize + pageOffset <= OWALPage.PAGE_SIZE - 7) {
                    pos += (long)entrySize;
                    break;
                }
                pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 16);
                break;
            }
            if (entrySize + pageOffset == OWALPage.PAGE_SIZE) {
                pos += (long)(entrySize + 16);
                break;
            }
            long chunkSize = OWALPage.calculateRecordSize(OWALPage.PAGE_SIZE - pageOffset);
            restOfRecord = (int)((long)restOfRecord - chunkSize);
            pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 16);
            pageOffset = 16;
        }
        if (pos >= this.filledUpTo) {
            return null;
        }
        return new OLogSequenceNumber(this.order, pos);
    }

    public void close(boolean flush) throws IOException {
        if (!this.closed) {
            this.lastReadRecord.clear();
            this.stopFlush(flush);
            if (!this.closer.isShutdown()) {
                this.closer.shutdown();
                try {
                    if (!this.closer.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL file auto close task '" + this.getPath() + "' cannot be stopped");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error((Object)this, "Shutdown of file auto close thread was interrupted", new Object[0]);
                }
            }
            this.fileLock.lock();
            try {
                if (this.rndFile != null) {
                    this.rndFile.close();
                    this.rndFile = null;
                }
            }
            finally {
                this.fileLock.unlock();
            }
            this.closed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OLogSequenceNumber readFlushedLSN() throws IOException {
        this.fileLock.lock();
        try {
            RandomAccessFile rndFile = this.getRndFile();
            long pages = rndFile.length() / (long)OWALPage.PAGE_SIZE;
            if (pages == 0L) {
                OLogSequenceNumber oLogSequenceNumber = null;
                return oLogSequenceNumber;
            }
        }
        finally {
            this.fileLock.unlock();
        }
        return new OLogSequenceNumber(this.order, this.filledUpTo - 1L);
    }

    public void flush() {
        if (!this.commitExecutor.isShutdown()) {
            try {
                this.commitExecutor.submit(new FlushTask()).get();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw OException.wrapException(new OStorageException("Thread was interrupted during flush"), e);
            }
            catch (ExecutionException e) {
                throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' flush"), e);
            }
        } else {
            new FlushTask().run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPageCache() throws IOException {
        this.fileLock.lock();
        try {
            RandomAccessFile rndFile = this.getRndFile();
            long pagesCount = rndFile.length() / (long)OWALPage.PAGE_SIZE;
            if (pagesCount == 0L) {
                return;
            }
            rndFile.seek((pagesCount - 1L) * (long)OWALPage.PAGE_SIZE);
            byte[] content = new byte[OWALPage.PAGE_SIZE];
            rndFile.readFully(content);
            if (this.checkPageIntegrity(content)) {
                int freeSpace = OIntegerSerializer.INSTANCE.deserializeNative(content, 12);
                this.filledUpTo = (pagesCount - 1L) * (long)OWALPage.PAGE_SIZE + (long)(OWALPage.PAGE_SIZE - freeSpace);
            } else {
                this.filledUpTo = pagesCount * (long)OWALPage.PAGE_SIZE + 16L;
            }
        }
        finally {
            this.fileLock.unlock();
        }
    }

    private long extractOrder(String name) {
        Matcher matcher = Pattern.compile("^.*\\.(\\d+)\\.wal$").matcher(name);
        boolean matches = matcher.find();
        assert (matches);
        String order = matcher.group(1);
        try {
            return Long.parseLong(order);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean checkPageIntegrity(byte[] content) {
        long magicNumber = OLongSerializer.INSTANCE.deserializeNative(content, 4);
        if (magicNumber != 4207608830L) {
            return false;
        }
        CRC32 crc32 = new CRC32();
        crc32.update(content, 4, OWALPage.PAGE_SIZE - 4);
        return (int)crc32.getValue() == OIntegerSerializer.INSTANCE.deserializeNative(content, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selfCheck() throws IOException {
        if (!this.logCache.isEmpty()) {
            throw new IllegalStateException("WAL cache is not empty, we cannot verify WAL after it was started to be used");
        }
        this.fileLock.lock();
        try {
            RandomAccessFile rndFile = this.getRndFile();
            long pagesCount = rndFile.length() / (long)OWALPage.PAGE_SIZE;
            if (rndFile.length() % (long)OWALPage.PAGE_SIZE > 0L) {
                OLogManager.instance().error((Object)this, "Last WAL page was written partially, auto fix", new Object[0]);
                rndFile.setLength((long)OWALPage.PAGE_SIZE * pagesCount);
            }
        }
        finally {
            this.fileLock.unlock();
        }
    }

    public long getFilledUpTo() {
        return this.filledUpTo;
    }

    class FileCloser
    implements Runnable {
        private boolean stopped = false;
        private volatile ScheduledFuture<?> self = null;

        FileCloser() {
        }

        @Override
        public void run() {
            block11: {
                if (this.stopped) {
                    if (this.self != null) {
                        this.self.cancel(false);
                    }
                    return;
                }
                if (OLogSegment.this.preventAutoClose) {
                    return;
                }
                OLogSegment.this.fileLock.lock();
                try {
                    if (OLogSegment.this.closeNextTime) {
                        try {
                            if (OLogSegment.this.rndFile != null) {
                                OLogSegment.this.rndFile.close();
                                OLogSegment.this.rndFile = null;
                            }
                        }
                        catch (IOException e) {
                            OLogManager.instance().error((Object)this, "Can not auto close file in WAL", e, new Object[0]);
                        }
                        OLogSegment.this.autoCloseInProgress.set(false);
                        this.stopped = true;
                        if (this.self != null) {
                            this.self.cancel(false);
                        }
                        break block11;
                    }
                    OLogSegment.this.closeNextTime = true;
                }
                finally {
                    OLogSegment.this.fileLock.unlock();
                }
            }
        }
    }

    public static class OLogRecord {
        public final byte[] record;
        public final long writeFrom;
        public final long writeTo;

        public OLogRecord(byte[] record, long writeFrom, long writeTo) {
            this.record = record;
            this.writeFrom = writeFrom;
            this.writeTo = writeTo;
        }
    }

    private final class FlushTask
    implements Runnable {
        private FlushTask() {
        }

        @Override
        public void run() {
            try {
                try {
                    OLogSegment.this.commitLog();
                }
                catch (Throwable e) {
                    OLogManager.instance().error((Object)this, "Error during WAL background flush", e, new Object[0]);
                }
            }
            finally {
                OLogSegment.this.writeAheadLog.checkFreeSpace();
            }
        }
    }
}

