/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.services.bootstrap;

import java.security.Principal;
import org.jboss.as.security.service.SimpleSecurityManager;
import org.jboss.as.weld.ServiceNames;
import org.jboss.as.weld.logging.WeldLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.weld.security.spi.SecurityServices;
import org.wildfly.security.auth.server.SecurityDomain;

public class WeldSecurityServices
implements Service<WeldSecurityServices>,
SecurityServices {
    public static final ServiceName SERVICE_NAME = ServiceNames.WELD_SECURITY_SERVICES_SERVICE_NAME;
    private final InjectedValue<SimpleSecurityManager> securityManagerValue = new InjectedValue();

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public WeldSecurityServices getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public Principal getPrincipal() {
        SecurityDomain elytronDomain = SecurityDomain.getCurrent();
        if (elytronDomain != null) {
            return elytronDomain.getCurrentSecurityIdentity().getPrincipal();
        }
        SimpleSecurityManager securityManager = (SimpleSecurityManager)this.securityManagerValue.getOptionalValue();
        if (securityManager == null) {
            throw WeldLogger.ROOT_LOGGER.securityNotEnabled();
        }
        return securityManager.getCallerPrincipal();
    }

    public void cleanup() {
    }

    public InjectedValue<SimpleSecurityManager> getSecurityManagerValue() {
        return this.securityManagerValue;
    }
}

