/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.spi.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.wildfly.clustering.infinispan.spi.persistence.KeyFormat;
import org.wildfly.common.function.ExceptionBiConsumer;
import org.wildfly.common.function.ExceptionFunction;

public class BinaryKeyFormat<K>
implements KeyFormat<K> {
    private final Class<K> targetClass;
    private final ExceptionFunction<DataInput, K, IOException> reader;
    private final ExceptionBiConsumer<DataOutput, K, IOException> writer;

    public BinaryKeyFormat(Class<K> targetClass, ExceptionFunction<DataInput, K, IOException> reader, ExceptionBiConsumer<DataOutput, K, IOException> writer) {
        this.targetClass = targetClass;
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public Class<K> getTargetClass() {
        return this.targetClass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public K parse(String value) {
        try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(value)));){
            Object object = this.reader.apply((Object)input);
            return (K)object;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String format(K key) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try (DataOutputStream output = new DataOutputStream(bytes);){
            this.writer.accept((Object)output, key);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return Base64.getEncoder().encodeToString(bytes.toByteArray());
    }
}

