/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.service;

import java.security.AccessController;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.as.txn.service.UserTransactionRegistryService;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.jboss.tm.usertx.UserTransactionRegistry;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.transaction.client.AbstractTransaction;
import org.wildfly.transaction.client.AssociationListener;
import org.wildfly.transaction.client.ContextTransactionManager;
import org.wildfly.transaction.client.CreationListener;
import org.wildfly.transaction.client.LocalTransactionContext;

public class TransactionManagerService
extends AbstractService<TransactionManager> {
    public static final ServiceName SERVICE_NAME = TxnServices.JBOSS_TXN_TRANSACTION_MANAGER;
    private InjectedValue<UserTransactionRegistry> registryInjector = new InjectedValue();

    private TransactionManagerService() {
    }

    public static ServiceController<TransactionManager> addService(ServiceTarget target) {
        TransactionManagerService service = new TransactionManagerService();
        ServiceBuilder serviceBuilder = target.addService(SERVICE_NAME, (Service)service);
        serviceBuilder.addDependency(TxnServices.JBOSS_TXN_LOCAL_TRANSACTION_CONTEXT);
        serviceBuilder.addDependency(UserTransactionRegistryService.SERVICE_NAME, UserTransactionRegistry.class, service.registryInjector);
        return serviceBuilder.install();
    }

    public void start(StartContext context) throws StartException {
        final UserTransactionRegistry registry = (UserTransactionRegistry)this.registryInjector.getValue();
        LocalTransactionContext.getCurrent().registerCreationListener((txn, createdBy) -> {
            if (createdBy == CreationListener.CreatedBy.USER_TRANSACTION) {
                if (WildFlySecurityManager.isChecking()) {
                    AccessController.doPrivileged(() -> {
                        txn.registerAssociationListener(new AssociationListener(){
                            private final AtomicBoolean first = new AtomicBoolean();

                            public void associationChanged(AbstractTransaction t, boolean a) {
                                if (a && this.first.compareAndSet(false, true)) {
                                    registry.userTransactionStarted();
                                }
                            }
                        });
                        return null;
                    });
                } else {
                    txn.registerAssociationListener(new AssociationListener(){
                        private final AtomicBoolean first = new AtomicBoolean();

                        public void associationChanged(AbstractTransaction t, boolean a) {
                            if (a && this.first.compareAndSet(false, true)) {
                                registry.userTransactionStarted();
                            }
                        }
                    });
                }
            }
        });
    }

    public TransactionManager getValue() throws IllegalStateException {
        return ContextTransactionManager.getInstance();
    }
}

