/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.nosql.driver;

public class Configuration {
    private static final String DEFAULT_MODULE_NAME = "com.orientechnologies";
    private String databaseUrl = "";
    private String database = "";
    private boolean remote = true;
    private String securityDomain;
    private int maxPartitionSize = -1;
    private int maxPoolSize = -1;
    private String jndiName = "";
    private String moduleName = "com.orientechnologies";
    private String profileName = "";

    private Configuration() {
    }

    private Configuration(Configuration configuration) {
        this.databaseUrl = configuration.getDatabaseUrl();
        this.database = configuration.getDatabase();
        this.securityDomain = configuration.getSecurityDomain();
        this.maxPartitionSize = configuration.getMaxPartitionSize();
        this.maxPoolSize = configuration.getMaxPoolSize();
        this.jndiName = configuration.getJndiName();
        this.moduleName = configuration.getModuleName();
        this.profileName = configuration.getProfileName();
        this.remote = configuration.isRemote();
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public int getMaxPartitionSize() {
        return this.maxPartitionSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public static class Builder {
        private Configuration configuration;

        public Builder() {
            this.configuration = new Configuration();
        }

        public Builder(Configuration configuration) {
            this.configuration = new Configuration(configuration);
        }

        public Builder databaseUrl(String databaseUrl) {
            this.configuration.databaseUrl = databaseUrl;
            return this;
        }

        public Builder database(String database) {
            this.configuration.database = database;
            return this;
        }

        public Builder remote(boolean remote) {
            this.configuration.remote = remote;
            return this;
        }

        public Builder securityDomain(String securityDomain) {
            this.configuration.securityDomain = securityDomain;
            return this;
        }

        public Builder maxPartitionSize(int maxPartitionSize) {
            this.configuration.maxPartitionSize = maxPartitionSize;
            return this;
        }

        public Builder maxPoolSize(int maxPoolSize) {
            this.configuration.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder jndiName(String jndiName) {
            this.configuration.jndiName = jndiName;
            return this;
        }

        public Builder moduleName(String moduleName) {
            this.configuration.moduleName = moduleName;
            return this;
        }

        public Builder profileName(String profileName) {
            this.configuration.profileName = profileName;
            return this;
        }

        public Configuration build() {
            return new Configuration(this.configuration);
        }
    }
}

