/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugin.common.AbstractServerConnection;
import org.wildfly.plugins.bootablejar.maven.common.Utils;

@Mojo(name="start", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class StartBootableJarMojo
extends AbstractServerConnection {
    @Parameter(alias="jvmArguments", property="wildfly.bootable.start.jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(alias="arguments", property="wildfly.bootable.start.arguments")
    public List<String> arguments = new ArrayList<String>();
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="wildfly.bootable.start.skip")
    private boolean skip;
    @Parameter(alias="check-server-start", defaultValue="true", property="wildfly.bootable.start.check.start")
    private boolean checkStarted;
    @Parameter(alias="startup-timeout", defaultValue="60", property="wildfly.bootable.start.timeout")
    private long startupTimeout;
    @Parameter(alias="id", defaultValue="60", property="wildfly.bootable.start.id")
    private String id;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping " + this.goal() + " of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        ModelControllerClient client = null;
        if (this.checkStarted) {
            client = this.createClient();
        }
        try {
            Utils.startBootableJar(Utils.getBootableJarPath(this.project, this.goal()), this.jvmArguments, this.arguments, false, this.checkStarted, client, this.startupTimeout);
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException ex) {
                    throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
                }
            }
        }
    }

    public String goal() {
        return "start";
    }
}

