/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.wildfly.security.manager.WildFlySecurityManager;

class AbstractBuildBootableJarMojo
extends AbstractMojo {
    public static final String BOOTABLE_SUFFIX = "wildfly";
    public static final String JAR = "jar";
    public static final String WAR = "war";
    @Component
    RepositorySystem repoSystem;
    @Component
    ArtifactResolver artifactResolver;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(alias="plugin-options", required=false)
    Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="offline", defaultValue="false")
    boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    boolean logTime;
    @Parameter(alias="layers", required=false)
    List<String> layers = Collections.emptyList();
    @Parameter(alias="exclude-layers", required=false)
    List<String> excludeLayers = Collections.emptyList();
    @Parameter(alias="record-state", defaultValue="false")
    boolean recordState;
    @Parameter(defaultValue="${project.build.directory}")
    String projectBuildDir;
    @Parameter(alias="root-url-path", defaultValue="true", property="wildfly.bootable.root.url")
    boolean rootUrlPath;
    @Parameter(alias="feature-pack-location", required=false, property="wildfly.bootable.fpl")
    String featurePackLocation;
    @Parameter(alias="cli-script-files")
    List<String> cliScriptFiles = Collections.emptyList();
    @Parameter(alias="cli-properties-file")
    String propertiesFile;
    @Parameter(alias="hollow-jar", property="wildfly.bootable.hollow")
    boolean hollowJar;
    @Parameter(defaultValue="false", property="wildfly.bootable.package.skip")
    boolean skip;
    @Parameter(alias="output-file-name", property="wildfly.bootable.package.output.file.name")
    String outputFileName;

    AbstractBuildBootableJarMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.outputFileName == null) {
            this.outputFileName = this.project.getBuild().getFinalName() + "-" + BOOTABLE_SUFFIX + "." + JAR;
        }
        this.validateProjectFile();
        if (System.getProperty("dev") != null) {
            Path deployments = this.getDeploymentsDir();
            IoUtils.recursiveDelete((Path)deployments);
            try {
                Files.createDirectory(deployments, new FileAttribute[0]);
                this.copyProjectFile(deployments);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Fail creating deployments directory ", (Exception)ex);
            }
            return;
        }
        Path contentRoot = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("bootable-jar-build-artifacts");
        if (Files.exists(contentRoot, new LinkOption[0])) {
            AbstractBuildBootableJarMojo.deleteDir(contentRoot);
        }
        Path jarFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.outputFileName);
        IoUtils.recursiveDelete((Path)contentRoot);
        Path wildflyDir = contentRoot.resolve(BOOTABLE_SUFFIX);
        Path contentDir = contentRoot.resolve("jar-content");
        try {
            Files.createDirectories(contentRoot, new FileAttribute[0]);
            Files.createDirectories(contentDir, new FileAttribute[0]);
            Files.deleteIfExists(jarFile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Packaging wildfly failed", (Exception)ex);
        }
        try {
            this.provisionServer(wildflyDir);
        }
        catch (ProvisioningException ex) {
            throw new MojoExecutionException("Provisioning failed", (Exception)((Object)ex));
        }
        try {
            ArrayList<String> commands = new ArrayList<String>();
            this.deploy(commands);
            this.userScripts(commands);
            this.configureCli(commands);
            this.executeCliScript(wildflyDir, commands);
            this.cleanupServer(wildflyDir);
            AbstractBuildBootableJarMojo.zipServer(wildflyDir, contentDir);
            this.buildJar(contentDir, jarFile);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Packaging wildfly failed", ex);
        }
        this.attachJar(jarFile);
    }

    private void copyProjectFile(Path targetDir) throws IOException, MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String fileName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || fileName.endsWith(WAR)) && this.rootUrlPath) {
            fileName = "ROOT.war";
        }
        Files.copy(f.toPath(), targetDir.resolve(fileName), new CopyOption[0]);
    }

    protected Path getDeploymentsDir() {
        return Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("deployments");
    }

    protected void configureCli(List<String> commands) {
    }

    private void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        IoUtils.recursiveDelete((Path)jbossHome.resolve("bin"));
        Files.deleteIfExists(jbossHome.resolve("README.txt"));
    }

    protected File validateProjectFile() throws MojoExecutionException {
        File f = this.getProjectFile();
        if (f == null && !this.hollowJar) {
            throw new MojoExecutionException("Cannot package without a primary artifact; please `mvn package` prior to invoking wildfly-jar:package from the command-line");
        }
        return f;
    }

    private void userScripts(List<String> commands) throws Exception {
        for (String path : this.cliScriptFiles) {
            File f = new File(path);
            if (!f.exists()) {
                if (!f.isAbsolute()) {
                    f = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(f.toPath()).toFile();
                }
                if (!f.exists()) {
                    throw new RuntimeException("Cli script file " + path + " doesn't exist");
                }
            }
            BufferedReader reader = new BufferedReader(new FileReader(f));
            Throwable throwable = null;
            try {
                String line = reader.readLine();
                while (line != null) {
                    commands.add(line.trim());
                    line = reader.readLine();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCliScript(Path jbossHome, List<String> commands) throws Exception {
        Properties props = null;
        if (this.propertiesFile != null) {
            props = this.loadProperties();
        }
        try {
            this.processCLI(jbossHome, commands);
        }
        finally {
            if (props != null) {
                for (String key : props.stringPropertyNames()) {
                    WildFlySecurityManager.clearPropertyPrivileged((String)key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCLI(Path jbossHome, List<String> commands) throws Exception {
        CommandContextConfiguration.Builder builder = new CommandContextConfiguration.Builder();
        builder.setResolveParameterValues(true);
        CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext(builder.build());
        Exception originalException = null;
        try {
            cmdCtx.handle("embed-server --jboss-home=" + jbossHome + " --std-out=echo");
            for (String line : commands) {
                cmdCtx.handle(line.trim());
            }
        }
        catch (Exception ex) {
            originalException = ex;
        }
        finally {
            try {
                cmdCtx.handle("stop-embedded-server");
            }
            catch (Exception ex2) {
                if (originalException != null) {
                    ex2.addSuppressed(originalException);
                }
                throw ex2;
            }
        }
    }

    private Properties loadProperties() throws Exception {
        File f = new File(this.propertiesFile);
        if (!f.exists()) {
            if (!f.isAbsolute()) {
                f = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(f.toPath()).toFile();
            }
            if (!f.exists()) {
                throw new RuntimeException("Cli properties file " + f + " doesn't exist");
            }
        }
        Properties props = new Properties();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
            props.load(inputStreamReader);
        }
        catch (IOException e) {
            throw new Exception("Failed to load properties from " + this.propertiesFile + ": " + e.getLocalizedMessage());
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (String key : props.stringPropertyNames()) {
            WildFlySecurityManager.setPropertyPrivileged((String)key, (String)props.getProperty(key));
        }
        return props;
    }

    private File getProjectFile() {
        if (this.project.getArtifact().getFile() != null) {
            return this.project.getArtifact().getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        Path candidate = Paths.get(this.projectBuildDir, finalName + "." + this.project.getPackaging());
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toFile();
        }
        return null;
    }

    private void provisionServer(Path home) throws ProvisioningException {
        ProvisioningConfig config;
        MavenArtifactRepositoryManager artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        Path provisioningFile = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve("galleon").resolve("provisioning.xml");
        if (!this.layers.isEmpty() || !this.excludeLayers.isEmpty()) {
            if (this.featurePackLocation == null) {
                throw new ProvisioningException("No server feature-pack location to provision layers, you must set a feature-pack-location.");
            }
            if (Files.exists(provisioningFile, new LinkOption[0])) {
                this.getLog().warn((CharSequence)("Layers defined in pom.xml override provisioning file located in " + provisioningFile));
            }
            ConfigModel.Builder configBuilder = ConfigModel.builder((String)"standalone", (String)"standalone.xml");
            for (String layer : this.layers) {
                configBuilder.includeLayer(layer);
            }
            for (String layer : this.excludeLayers) {
                configBuilder.excludeLayer(layer);
            }
            if (this.pluginOptions.isEmpty()) {
                this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
            } else if (!this.pluginOptions.containsKey("optional-packages")) {
                this.pluginOptions.put("optional-packages", "passive+");
            }
            FeaturePackConfig dependency = ((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)FeaturePackLocation.fromString((String)this.featurePackLocation)).setInheritPackages(false).setInheritConfigs(false)).build();
            config = ((ProvisioningConfig.Builder)((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(dependency)).addConfig(configBuilder.build())).build();
        } else if (Files.exists(provisioningFile, new LinkOption[0])) {
            config = ProvisioningXmlParser.parse((Path)provisioningFile);
        } else {
            if (this.featurePackLocation == null) {
                throw new ProvisioningException("No server feature-pack location to provision standalone configuration, you must set a feature-pack-location.");
            }
            FeaturePackConfig dependency = ((FeaturePackConfig.Builder)((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)FeaturePackLocation.fromString((String)this.featurePackLocation)).setInheritPackages(true).setInheritConfigs(false)).includeDefaultConfig("standalone", "standalone.xml")).build();
            config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(dependency)).build();
        }
        IoUtils.recursiveDelete((Path)home);
        this.getLog().info((CharSequence)("Building server based on " + config.getFeaturePackDeps() + " galleon feature-packs"));
        ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)artifactResolver)).setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();
        Object object = null;
        try {
            pm.provision(config, this.pluginOptions);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (pm != null) {
                if (object != null) {
                    try {
                        pm.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    pm.close();
                }
            }
        }
    }

    private void deploy(List<String> commands) throws IOException, MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String runtimeName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || runtimeName.endsWith(WAR)) && this.rootUrlPath) {
            runtimeName = "ROOT.war";
        }
        commands.add("deploy " + f.getAbsolutePath() + " --name=" + f.getName() + " --runtime-name=" + runtimeName);
    }

    private static void zipServer(Path home, Path contentDir) throws IOException {
        Path target = contentDir.resolve("wildfly.zip");
        ZipUtils.zip((Path)home, (Path)target);
    }

    private String retrieveRuntimeVersion() throws UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/plugin.xml");
        if (is == null) {
            throw new MojoExecutionException("Can't retrieve plugin descriptor");
        }
        PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
        PluginDescriptor pluginDescriptor = builder.build((Reader)new InputStreamReader(is, "UTF-8"));
        return pluginDescriptor.getVersion();
    }

    private void buildJar(Path contentDir, Path jarFile) throws MojoExecutionException, IOException {
        try {
            Path rtJarFile = this.resolveRuntime();
            ZipUtils.unzip((Path)rtJarFile, (Path)contentDir);
            ZipUtils.zip((Path)contentDir, (Path)jarFile);
        }
        catch (UnsupportedEncodingException | ArtifactResolverException | PlexusConfigurationException e) {
            throw new MojoExecutionException("Failed to resolve rt jar ", (Exception)e);
        }
    }

    private Path resolveRuntime() throws ArtifactResolverException, UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setLocalRepository(this.session.getLocalRepository());
        buildingRequest.setRemoteRepositories(this.project.getRemoteArtifactRepositories());
        ArtifactResult result = this.artifactResolver.resolveArtifact((ProjectBuildingRequest)buildingRequest, (Artifact)new DefaultArtifact("org.wildfly.plugins", "wildfly-jar-runtime", this.retrieveRuntimeVersion(), "provided", JAR, null, (ArtifactHandler)new DefaultArtifactHandler(JAR)));
        return result.getArtifact().getFile().toPath();
    }

    private void attachJar(Path jarFile) {
        this.debug("Attaching bootable jar %s as a project artifact", jarFile);
        this.projectHelper.attachArtifact(this.project, JAR, BOOTABLE_SUFFIX, jarFile.toFile());
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }

    static void deleteDir(Path root) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

