/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.nio.file.Path;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;
import org.wildfly.plugins.bootablejar.maven.goals.StartBootableJarMojo;

@Mojo(name="dev", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public final class DevBootableJarMojo
extends AbstractBuildBootableJarMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        this.hollowJar = true;
        super.execute();
        new StartBootableJarMojo().startDevMode(this.project);
    }

    @Override
    protected void configureCli(List<String> commands) {
        this.configureScanner(this.getDeploymentsDir(), commands);
    }

    private void configureScanner(Path deployments, List<String> commands) {
        commands.add("/subsystem=deployment-scanner/scanner=new:add(scan-interval=1000,auto-deploy-exploded=false,path=\"" + deployments + "\")");
    }
}

