/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.cli;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.wildfly.plugin.tools.bootablejar.BootLoggingConfiguration;
import org.wildfly.plugin.tools.cli.CLIWrapper;
import org.wildfly.plugins.bootablejar.maven.cli.CLIExecutor;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;

public class LocalCLIExecutor
implements CLIExecutor {
    private final Level level;
    private final ClassLoader originalCl;
    private final URLClassLoader cliCl;
    private final AbstractBuildBootableJarMojo mojo;
    private final CLIWrapper cliWrapper;

    public LocalCLIExecutor(Path jbossHome, List<Path> cliArtifacts, AbstractBuildBootableJarMojo mojo, boolean resolveExpression, BootLoggingConfiguration bootLoggingConfiguration) throws Exception {
        this.mojo = mojo;
        this.level = mojo.disableLog();
        URL[] cp = new URL[cliArtifacts.size()];
        Iterator<Path> it = cliArtifacts.iterator();
        int i = 0;
        while (it.hasNext()) {
            cp[i] = it.next().toUri().toURL();
            ++i;
        }
        this.originalCl = Thread.currentThread().getContextClassLoader();
        this.cliCl = new URLClassLoader(cp, this.originalCl);
        Thread.currentThread().setContextClassLoader(this.cliCl);
        this.cliWrapper = new CLIWrapper(jbossHome, resolveExpression, (ClassLoader)this.cliCl, bootLoggingConfiguration);
    }

    @Override
    public void handle(String command) throws Exception {
        this.cliWrapper.handle(command);
    }

    @Override
    public String getOutput() {
        return this.cliWrapper.getOutput();
    }

    @Override
    public void close() throws Exception {
        try {
            this.cliWrapper.close();
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalCl);
            try {
                this.cliCl.close();
            }
            catch (IOException iOException) {}
            this.mojo.enableLog(this.level);
        }
    }

    @Override
    public void execute(List<String> commands) throws Exception {
        for (String cmd : commands) {
            this.handle(cmd);
        }
    }

    @Override
    public void generateBootLoggingConfig() throws Exception {
        this.cliWrapper.generateBootLoggingConfig();
    }
}

