/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.impl.CommandContextConfiguration;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.ConfigurationId;
import org.jboss.galleon.maven.plugin.util.FeaturePack;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.wildfly.plugins.bootablejar.maven.common.MavenRepositoriesEnricher;
import org.wildfly.plugins.bootablejar.maven.goals.CliSession;
import org.wildfly.security.manager.WildFlySecurityManager;

class AbstractBuildBootableJarMojo
extends AbstractMojo {
    public static final String BOOTABLE_SUFFIX = "bootable";
    public static final String JAR = "jar";
    public static final String WAR = "war";
    private static final String MODULE_ID_JAR_RUNTIME = "org.wildfly.bootable-jar";
    private static final String BOOT_ARTIFACT_ID = "wildfly-jar-boot";
    @Component
    RepositorySystem repoSystem;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(alias="plugin-options", required=false)
    Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="offline", defaultValue="false")
    boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    boolean logTime;
    @Parameter(alias="layers", required=false)
    List<String> layers = Collections.emptyList();
    @Parameter(alias="excluded-layers", required=false)
    List<String> excludedLayers = Collections.emptyList();
    @Parameter(alias="record-state", defaultValue="false")
    boolean recordState;
    @Parameter(defaultValue="${project.build.directory}")
    String projectBuildDir;
    @Parameter(alias="root-url-path", defaultValue="true", property="wildfly.bootable.root.url")
    boolean rootUrlPath;
    @Parameter(alias="feature-pack-location", required=false, property="wildfly.bootable.fpl")
    String featurePackLocation;
    @Parameter(alias="cli-sessions")
    List<CliSession> cliSessions = Collections.emptyList();
    @Parameter(alias="hollow-jar", property="wildfly.bootable.hollow")
    boolean hollowJar;
    @Parameter(defaultValue="false", property="wildfly.bootable.package.skip")
    boolean skip;
    @Parameter(alias="output-file-name", property="wildfly.bootable.package.output.file.name")
    String outputFileName;
    @Parameter(alias="feature-packs", required=false)
    private List<FeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="extra-server-content-dirs", property="wildfly.bootable.package.extra.server.content.dirs")
    List<String> extraServerContent = Collections.emptyList();
    @Parameter(alias="provisioning-file", property="wildfly.bootable.provisioning.file", defaultValue="${project.basedir}/galleon/provisioning.xml")
    private File provisioningFile;
    private Set<String> extraLayers = new HashSet<String>();
    private Path wildflyDir;
    private MavenRepoManager artifactResolver;

    AbstractBuildBootableJarMojo() {
    }

    public Path getJBossHome() {
        return this.wildflyDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenRepositoriesEnricher.enrich(this.session, this.project, this.repositories);
        MavenArtifactRepositoryManager mavenArtifactRepositoryManager = this.artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        if (this.outputFileName == null) {
            this.outputFileName = this.project.getBuild().getFinalName() + "-" + BOOTABLE_SUFFIX + "." + JAR;
        }
        this.validateProjectFile();
        if (System.getProperty("dev") != null) {
            Path deployments = this.getDeploymentsDir();
            IoUtils.recursiveDelete((Path)deployments);
            try {
                Files.createDirectory(deployments, new FileAttribute[0]);
                this.copyProjectFile(deployments);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Fail creating deployments directory ", (Exception)ex);
            }
            return;
        }
        Path contentRoot = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("bootable-jar-build-artifacts");
        if (Files.exists(contentRoot, new LinkOption[0])) {
            AbstractBuildBootableJarMojo.deleteDir(contentRoot);
        }
        Path jarFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.outputFileName);
        IoUtils.recursiveDelete((Path)contentRoot);
        this.wildflyDir = contentRoot.resolve("wildfly");
        Path contentDir = contentRoot.resolve("jar-content");
        try {
            Files.createDirectories(contentRoot, new FileAttribute[0]);
            Files.createDirectories(contentDir, new FileAttribute[0]);
            Files.deleteIfExists(jarFile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Packaging wildfly failed", (Exception)ex);
        }
        Artifact bootArtifact = null;
        try {
            bootArtifact = this.provisionServer(this.wildflyDir, contentDir.resolve("provisioning.xml"));
        }
        catch (IOException | XMLStreamException | ProvisioningException ex) {
            throw new MojoExecutionException("Provisioning failed", (Exception)ex);
        }
        try {
            this.copyExtraContentInternal(this.wildflyDir, contentDir);
            this.copyExtraContent(this.wildflyDir);
            ArrayList<String> commands = new ArrayList<String>();
            this.deploy(commands);
            this.configureCli(commands);
            if (!commands.isEmpty()) {
                this.executeCliScript(this.wildflyDir, commands, null, false, "Server configuration");
            }
            this.userScripts(this.wildflyDir);
            this.cleanupServer(this.wildflyDir);
            AbstractBuildBootableJarMojo.zipServer(this.wildflyDir, contentDir);
            this.buildJar(contentDir, jarFile, bootArtifact);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Packaging wildfly failed", ex);
        }
        this.attachJar(jarFile);
    }

    private void copyExtraContent(Path wildflyDir) throws Exception {
        for (String path : this.extraServerContent) {
            Path extraContent = Paths.get(path, new String[0]);
            if (!Files.exists(extraContent, new LinkOption[0])) {
                throw new Exception("Extra content dir " + path + " doesn't exist");
            }
            IoUtils.copy((Path)extraContent, (Path)wildflyDir);
        }
    }

    protected void copyExtraContentInternal(Path wildflyDir, Path contentDir) throws Exception {
    }

    protected void addExtraLayer(String layer) {
        this.extraLayers.add(layer);
    }

    private void copyProjectFile(Path targetDir) throws IOException, MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String fileName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || fileName.endsWith(WAR)) && this.rootUrlPath) {
            fileName = "ROOT.war";
        }
        Files.copy(f.toPath(), targetDir.resolve(fileName), new CopyOption[0]);
    }

    protected Path getDeploymentsDir() {
        return Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("deployments");
    }

    protected void configureCli(List<String> commands) {
    }

    private void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        Files.deleteIfExists(jbossHome.resolve("README.txt"));
    }

    protected File validateProjectFile() throws MojoExecutionException {
        File f = this.getProjectFile();
        if (f == null && !this.hollowJar) {
            throw new MojoExecutionException("Cannot package without a primary artifact; please `mvn package` prior to invoking wildfly-jar:package from the command-line");
        }
        return f;
    }

    private void userScripts(Path wildflyDir) throws Exception {
        for (CliSession session : this.cliSessions) {
            ArrayList<String> commands = new ArrayList<String>();
            for (String path : session.getScriptFiles()) {
                File f = new File(path);
                if (!f.exists()) {
                    if (!f.isAbsolute()) {
                        f = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(f.toPath()).toFile();
                    }
                    if (!f.exists()) {
                        throw new RuntimeException("Cli script file " + path + " doesn't exist");
                    }
                }
                BufferedReader reader = new BufferedReader(new FileReader(f));
                Throwable throwable = null;
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        commands.add(line.trim());
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            if (commands.isEmpty()) continue;
            this.executeCliScript(wildflyDir, commands, session.getPropertiesFile(), session.getResolveExpression(), session.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCliScript(Path jbossHome, List<String> commands, String propertiesFile, boolean resolveExpression, String message) throws Exception {
        this.getLog().info((CharSequence)("Executing CLI, " + message));
        Properties props = null;
        if (propertiesFile != null) {
            props = this.loadProperties(propertiesFile);
        }
        try {
            this.processCLI(jbossHome, commands, resolveExpression);
        }
        finally {
            if (props != null) {
                for (String key : props.stringPropertyNames()) {
                    WildFlySecurityManager.clearPropertyPrivileged((String)key);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCLI(Path jbossHome, List<String> commands, boolean resolveExpression) throws Exception {
        Level level = this.disableLog();
        Path config = jbossHome.resolve("bin").resolve("jboss-cli.xml");
        String origConfig = System.getProperty("jboss.cli.config");
        if (Files.exists(config, new LinkOption[0])) {
            System.setProperty("jboss.cli.config", config.toString());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Throwable originalException = null;
        try {
            CommandContextConfiguration.Builder builder = new CommandContextConfiguration.Builder();
            builder.setEchoCommand(true);
            builder.setResolveParameterValues(resolveExpression);
            builder.setConsoleOutput((OutputStream)out);
            CommandContext cmdCtx = CommandContextFactory.getInstance().newCommandContext(builder.build());
            try {
                cmdCtx.handle("embed-server --jboss-home=" + jbossHome + " --std-out=discard");
                for (String line : commands) {
                    cmdCtx.handle(line.trim());
                }
            }
            catch (Exception ex) {
                originalException = ex;
            }
            finally {
                try {
                    cmdCtx.handle("stop-embedded-server");
                }
                catch (Exception ex2) {
                    if (originalException != null) {
                        ex2.addSuppressed(originalException);
                    }
                    throw ex2;
                }
            }
            if (originalException != null) {
                throw originalException;
            }
        }
        finally {
            this.enableLog(level);
            if (origConfig != null) {
                System.setProperty("jboss.cli.config", origConfig);
            }
            if (originalException != null) {
                this.getLog().error((CharSequence)("Error executing CLI script " + originalException.getLocalizedMessage()));
                this.getLog().error((CharSequence)out.toString());
            }
        }
        this.getLog().info((CharSequence)"CLI scripts execution done.");
    }

    private Level disableLog() {
        Logger l = Logger.getLogger("");
        Level level = l.getLevel();
        if (!this.getLog().isDebugEnabled()) {
            l.setLevel(Level.OFF);
        }
        return level;
    }

    private void enableLog(Level level) {
        Logger l = Logger.getLogger("");
        l.setLevel(level);
    }

    private Properties loadProperties(String propertiesFile) throws Exception {
        File f = new File(propertiesFile);
        if (!f.exists()) {
            if (!f.isAbsolute()) {
                f = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(f.toPath()).toFile();
            }
            if (!f.exists()) {
                throw new RuntimeException("Cli properties file " + f + " doesn't exist");
            }
        }
        Properties props = new Properties();
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);
            props.load(inputStreamReader);
        }
        catch (IOException e) {
            throw new Exception("Failed to load properties from " + propertiesFile + ": " + e.getLocalizedMessage());
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        for (String key : props.stringPropertyNames()) {
            WildFlySecurityManager.setPropertyPrivileged((String)key, (String)props.getProperty(key));
        }
        return props;
    }

    private File getProjectFile() {
        if (this.project.getArtifact().getFile() != null) {
            return this.project.getArtifact().getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        Path candidate = Paths.get(this.projectBuildDir, finalName + "." + this.project.getPackaging());
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toFile();
        }
        return null;
    }

    protected Path getProvisioningFile() {
        return this.provisioningFile.toPath();
    }

    protected boolean hasLayers() {
        return !this.layers.isEmpty();
    }

    protected List<String> getLayers() {
        return this.layers;
    }

    protected List<String> getExcludedLayers() {
        return this.excludedLayers;
    }

    /*
     * WARNING - void declaration
     */
    private Artifact provisionServer(Path home, Path outputProvisioningFile) throws ProvisioningException, MojoExecutionException, IOException, XMLStreamException {
        Path provisioningFile = this.getProvisioningFile();
        ProvisioningConfig.Builder state = null;
        try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)this.artifactResolver)).setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();){
            void var9_24;
            ProvisioningConfig config;
            ConfigModel.Builder configBuilder;
            if (!this.featurePacks.isEmpty()) {
                if (Files.exists(provisioningFile, new LinkOption[0])) {
                    this.getLog().warn((CharSequence)("Feature packs defined in pom.xml override provisioning file located in " + provisioningFile));
                }
                if (this.featurePackLocation != null) {
                    throw new MojoExecutionException("Feature packlocation can't be used with a list of feature-packs");
                }
                state = ProvisioningConfig.builder();
                for (FeaturePack featurePack : this.featurePacks) {
                    FeaturePackConfig.Builder fpConfig;
                    FeaturePackLocation fpl;
                    if (featurePack.getLocation() == null && (featurePack.getGroupId() == null || featurePack.getArtifactId() == null) && featurePack.getNormalizedPath() == null) {
                        throw new MojoExecutionException("Feature-pack location, Maven GAV or feature pack path is missing");
                    }
                    if (featurePack.getNormalizedPath() != null) {
                        fpl = pm.getLayoutFactory().addLocal(featurePack.getNormalizedPath(), false);
                    } else if (featurePack.getGroupId() != null && featurePack.getArtifactId() != null) {
                        Path path = this.resolveMaven((ArtifactCoordinate)featurePack);
                        fpl = pm.getLayoutFactory().addLocal(path, false);
                    } else {
                        fpl = FeaturePackLocation.fromString((String)featurePack.getLocation());
                    }
                    FeaturePackConfig.Builder builder = fpConfig = featurePack.isTransitive() ? FeaturePackConfig.transitiveBuilder((FeaturePackLocation)fpl) : FeaturePackConfig.builder((FeaturePackLocation)fpl);
                    if (featurePack.isInheritConfigs() != null) {
                        fpConfig.setInheritConfigs(featurePack.isInheritConfigs().booleanValue());
                    }
                    if (featurePack.isInheritPackages() != null) {
                        fpConfig.setInheritPackages(featurePack.isInheritPackages().booleanValue());
                    }
                    if (!featurePack.getExcludedConfigs().isEmpty()) {
                        for (ConfigurationId configId : featurePack.getExcludedConfigs()) {
                            if (configId.isModelOnly()) {
                                fpConfig.excludeConfigModel(configId.getId().getModel());
                                continue;
                            }
                            fpConfig.excludeDefaultConfig(configId.getId());
                        }
                    }
                    if (!featurePack.getIncludedConfigs().isEmpty()) {
                        for (ConfigurationId configId : featurePack.getIncludedConfigs()) {
                            if (configId.isModelOnly()) {
                                fpConfig.includeConfigModel(configId.getId().getModel());
                                continue;
                            }
                            fpConfig.includeDefaultConfig(configId.getId());
                        }
                    }
                    if (!featurePack.getIncludedPackages().isEmpty()) {
                        for (String includedPackage : featurePack.getIncludedPackages()) {
                            fpConfig.includePackage(includedPackage);
                        }
                    }
                    if (!featurePack.getExcludedPackages().isEmpty()) {
                        for (String excludedPackage : featurePack.getExcludedPackages()) {
                            fpConfig.excludePackage(excludedPackage);
                        }
                    }
                    state.addFeaturePackDep(fpConfig.build());
                }
            }
            if (!this.layers.isEmpty()) {
                if (this.featurePackLocation == null && state == null) {
                    throw new ProvisioningException("No server feature-pack location to provision layers, you must set a feature-pack-location.");
                }
                if (Files.exists(provisioningFile, new LinkOption[0])) {
                    this.getLog().warn((CharSequence)("Layers defined in pom.xml override provisioning file located in " + provisioningFile));
                }
                configBuilder = ConfigModel.builder((String)"standalone", (String)"standalone.xml");
                for (String layer : this.layers) {
                    configBuilder.includeLayer(layer);
                }
                for (String layer : this.extraLayers) {
                    if (this.layers.contains(layer)) continue;
                    configBuilder.includeLayer(layer);
                }
                for (String layer : this.excludedLayers) {
                    configBuilder.excludeLayer(layer);
                }
                if (this.pluginOptions.isEmpty()) {
                    this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
                } else if (!this.pluginOptions.containsKey("optional-packages")) {
                    this.pluginOptions.put("optional-packages", "passive+");
                }
                if (state == null) {
                    state = ProvisioningConfig.builder();
                    FeaturePackConfig featurePackConfig = ((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)FeaturePackLocation.fromString((String)this.featurePackLocation)).setInheritPackages(false).setInheritConfigs(false)).build();
                    state.addFeaturePackDep(featurePackConfig);
                }
                state.addConfig(configBuilder.build());
            }
            if (state == null) {
                if (Files.exists(provisioningFile, new LinkOption[0])) {
                    config = ProvisioningXmlParser.parse((Path)provisioningFile);
                } else {
                    if (this.featurePackLocation == null) {
                        throw new ProvisioningException("No server feature-pack location to provision microprofile standalone configuration, you must set a feature-pack-location.");
                    }
                    configBuilder = null;
                    if (!this.extraLayers.isEmpty()) {
                        configBuilder = ConfigModel.builder((String)"standalone", (String)"standalone-microprofile.xml");
                        for (String layer : this.extraLayers) {
                            configBuilder.includeLayer(layer);
                        }
                    }
                    FeaturePackConfig featurePackConfig = ((FeaturePackConfig.Builder)((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)FeaturePackLocation.fromString((String)this.featurePackLocation)).setInheritPackages(false).setInheritConfigs(false)).includeDefaultConfig("standalone", "standalone-microprofile.xml")).build();
                    ProvisioningConfig.Builder provBuilder = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(featurePackConfig)).addOptions(this.pluginOptions);
                    if (configBuilder == null) {
                        configBuilder = ConfigModel.builder((String)"standalone", (String)"standalone-microprofile.xml");
                    }
                    configBuilder.setProperty("--server-config", "standalone.xml");
                    provBuilder.addConfig(configBuilder.build());
                    this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
                    provBuilder.addOptions(this.pluginOptions);
                    config = provBuilder.build();
                }
            } else {
                state.addOptions(this.pluginOptions);
                config = state.build();
            }
            IoUtils.recursiveDelete((Path)home);
            this.getLog().info((CharSequence)("Building server based on " + config.getFeaturePackDeps() + " galleon feature-packs"));
            Throwable throwable = null;
            try (FileWriter writer = new FileWriter(outputProvisioningFile.toFile());){
                ProvisioningXmlWriter.getInstance().write((Object)config, (Writer)writer);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            ProvisioningRuntime rt = pm.getRuntime(config);
            Object var9_22 = null;
            block29: for (FeaturePackRuntime fprt : rt.getFeaturePacks()) {
                if (fprt.getPackage(MODULE_ID_JAR_RUNTIME) == null) continue;
                Path artifactProps = fprt.getResource(new String[]{"wildfly/artifact-versions.properties"});
                HashMap<String, String> propsMap = new HashMap<String, String>();
                try {
                    AbstractBuildBootableJarMojo.readProperties(artifactProps, propsMap);
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Error reading artifact versions", ex);
                }
                for (Map.Entry entry : propsMap.entrySet()) {
                    String value = (String)entry.getValue();
                    Artifact a = AbstractBuildBootableJarMojo.getArtifact(value);
                    if (!BOOT_ARTIFACT_ID.equals(a.getArtifactId())) continue;
                    this.getLog().info((CharSequence)("Found boot artifact " + a + " in " + fprt.getFPID()));
                    Artifact artifact = a;
                    break block29;
                }
            }
            if (var9_24 == null) {
                throw new ProvisioningException("Server doesn't support bootable jar packaging");
            }
            pm.provision(rt.getLayout());
            Iterator iterator = var9_24;
            return iterator;
        }
    }

    static Artifact getArtifact(String str) {
        String[] parts = str.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String classifier = parts[3];
        String extension = parts[4];
        return new DefaultArtifact(groupId, artifactId, version, "provided", extension, classifier, (ArtifactHandler)new DefaultArtifactHandler(extension));
    }

    private static void readProperties(Path propsFile, Map<String, String> propsMap) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).charAt(0) != '#' && !line.isEmpty()) {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new Exception("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
    }

    private void deploy(List<String> commands) throws IOException, MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String runtimeName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || runtimeName.endsWith(WAR)) && this.rootUrlPath) {
            runtimeName = "ROOT.war";
        }
        commands.add("deploy " + f.getAbsolutePath() + " --name=" + f.getName() + " --runtime-name=" + runtimeName);
    }

    private static void zipServer(Path home, Path contentDir) throws IOException {
        Path target = contentDir.resolve("wildfly.zip");
        ZipUtils.zip((Path)home, (Path)target);
    }

    private void buildJar(Path contentDir, Path jarFile, Artifact artifact) throws MojoExecutionException, IOException {
        Path rtJarFile = this.resolveArtifact(artifact);
        ZipUtils.unzip((Path)rtJarFile, (Path)contentDir);
        ZipUtils.zip((Path)contentDir, (Path)jarFile);
    }

    public String retrievePluginVersion() throws UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/plugin.xml");
        if (is == null) {
            throw new MojoExecutionException("Can't retrieve plugin descriptor");
        }
        PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
        PluginDescriptor pluginDescriptor = builder.build((Reader)new InputStreamReader(is, "UTF-8"));
        return pluginDescriptor.getVersion();
    }

    public Path resolveArtifact(String groupId, String artifactId, String version) throws UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        return this.resolveArtifact((Artifact)new DefaultArtifact(groupId, artifactId, version, "provided", JAR, null, (ArtifactHandler)new DefaultArtifactHandler(JAR)));
    }

    private Path resolveArtifact(Artifact artifact) throws MojoExecutionException {
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.setGroupId(artifact.getGroupId());
        mavenArtifact.setArtifactId(artifact.getArtifactId());
        mavenArtifact.setVersion(artifact.getVersion());
        mavenArtifact.setClassifier(artifact.getClassifier());
        mavenArtifact.setExtension(artifact.getType());
        try {
            this.artifactResolver.resolve(mavenArtifact);
            return mavenArtifact.getPath();
        }
        catch (MavenUniverseException ex) {
            throw new MojoExecutionException(ex.toString(), (Exception)((Object)ex));
        }
    }

    private void attachJar(Path jarFile) {
        this.debug("Attaching bootable jar %s as a project artifact", jarFile);
        this.projectHelper.attachArtifact(this.project, JAR, BOOTABLE_SUFFIX, jarFile.toFile());
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }

    static void deleteDir(Path root) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Path resolveMaven(ArtifactCoordinate coordinate) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact().setGroupId(coordinate.getGroupId()).setArtifactId(coordinate.getArtifactId()).setVersion(coordinate.getVersion()).setExtension(coordinate.getExtension()).setClassifier(coordinate.getClassifier());
        this.artifactResolver.resolve(artifact);
        return artifact.getPath();
    }
}

