/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.wildfly.core.launcher.BootableJarCommandBuilder;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.plugins.bootablejar.maven.common.Utils;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.RUNTIME)
public final class RunBootableJarMojo
extends AbstractMojo {
    @Parameter(alias="jvmArguments")
    public List<String> jvmArguments = new ArrayList<String>();
    @Parameter(alias="arguments")
    public List<String> arguments = new ArrayList<String>();
    @Parameter(property="wildfly.bootable.jvmArguments")
    public String jvmArgumentsProps;
    @Parameter(property="wildfly.bootable.arguments")
    public String argumentsProps;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="wildfly.bootable.run.skip")
    private boolean skip;
    @Parameter(alias="jar-file-name", property="wildfly.bootable.run.jar.file.name")
    String jarFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        StringTokenizer args;
        if (this.skip) {
            this.getLog().debug((CharSequence)String.format("Skipping run of %s:%s", this.project.getGroupId(), this.project.getArtifactId()));
            return;
        }
        if (this.jvmArgumentsProps != null) {
            args = new StringTokenizer(this.jvmArgumentsProps);
            while (args.hasMoreTokens()) {
                this.jvmArguments.add(args.nextToken());
            }
        }
        if (this.argumentsProps != null) {
            args = new StringTokenizer(this.argumentsProps);
            while (args.hasMoreTokens()) {
                this.arguments.add(args.nextToken());
            }
        }
        try {
            BootableJarCommandBuilder commandBuilder = BootableJarCommandBuilder.of((String)Utils.getBootableJarPath(this.jarFileName, this.project, "run")).addJavaOptions(this.jvmArguments).addServerArgument(this.argumentsProps);
            Process process = Launcher.of((CommandBuilder)commandBuilder).launch();
            process.waitFor();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }
}

