/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import org.apache.maven.artifact.Artifact;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugins.bootablejar.maven.goals.AbstractBuildBootableJarMojo;

class CLIExecutor
implements AutoCloseable {
    private final Level level;
    private final Object ctx;
    private final Method handle;
    private final Method terminateSession;
    private final Method getModelControllerClient;
    private final ClassLoader originalCl;
    private final URLClassLoader cliCl;
    private final String origConfig;
    private final AbstractBuildBootableJarMojo mojo;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    CLIExecutor(Path jbossHome, Set<Artifact> cliArtifacts, AbstractBuildBootableJarMojo mojo, boolean resolveExpression) throws Exception {
        this.mojo = mojo;
        this.level = mojo.disableLog();
        Path config = jbossHome.resolve("bin").resolve("jboss-cli.xml");
        this.origConfig = System.getProperty("jboss.cli.config");
        if (Files.exists(config, new LinkOption[0])) {
            System.setProperty("jboss.cli.config", config.toString());
        }
        URL[] cp = new URL[cliArtifacts.size() + 1];
        cp[0] = jbossHome.resolve("jboss-modules.jar").toUri().toURL();
        mojo.getLog().debug((CharSequence)("CLI artifacts " + cliArtifacts));
        Iterator<Artifact> it = cliArtifacts.iterator();
        int i = 1;
        while (it.hasNext()) {
            cp[i] = mojo.resolveArtifact(it.next()).toUri().toURL();
            ++i;
        }
        this.originalCl = Thread.currentThread().getContextClassLoader();
        this.cliCl = new URLClassLoader(cp, this.originalCl);
        Thread.currentThread().setContextClassLoader(this.cliCl);
        Object builder = this.cliCl.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration$Builder").newInstance();
        Method setEchoCommand = builder.getClass().getMethod("setEchoCommand", Boolean.TYPE);
        setEchoCommand.invoke(builder, true);
        Method setResolve = builder.getClass().getMethod("setResolveParameterValues", Boolean.TYPE);
        setResolve.invoke(builder, resolveExpression);
        Method setOutput = builder.getClass().getMethod("setConsoleOutput", OutputStream.class);
        setOutput.invoke(builder, this.out);
        Object ctxConfig = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        Object factory = this.cliCl.loadClass("org.jboss.as.cli.CommandContextFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        Class<?> configClass = this.cliCl.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration");
        this.ctx = factory.getClass().getMethod("newCommandContext", configClass).invoke(factory, ctxConfig);
        this.handle = this.ctx.getClass().getMethod("handle", String.class);
        this.terminateSession = this.ctx.getClass().getMethod("terminateSession", new Class[0]);
        this.getModelControllerClient = this.ctx.getClass().getMethod("getModelControllerClient", new Class[0]);
    }

    void handle(String command) throws Exception {
        this.handle.invoke(this.ctx, command);
    }

    String getOutput() {
        return this.out.toString();
    }

    @Override
    public void close() throws Exception {
        try {
            this.terminateSession.invoke(this.ctx, new Object[0]);
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalCl);
            try {
                this.cliCl.close();
            }
            catch (IOException iOException) {}
            this.mojo.enableLog(this.level);
            if (this.origConfig != null) {
                System.setProperty("jboss.cli.config", this.origConfig);
            }
        }
    }

    ModelControllerClient getModelControllerClient() throws Exception {
        return (ModelControllerClient)this.getModelControllerClient.invoke(this.ctx, new Object[0]);
    }
}

