/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.maven.plugin.util.MavenArtifactRepositoryManager;
import org.jboss.galleon.maven.plugin.util.MvnMessageWriter;
import org.jboss.galleon.repo.RepositoryArtifactResolver;
import org.jboss.galleon.runtime.FeaturePackRuntime;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.ZipUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;
import org.jboss.galleon.xml.ProvisioningXmlWriter;
import org.wildfly.plugins.bootablejar.maven.cli.CLIExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.LocalCLIExecutor;
import org.wildfly.plugins.bootablejar.maven.cli.RemoteCLIExecutor;
import org.wildfly.plugins.bootablejar.maven.common.FeaturePack;
import org.wildfly.plugins.bootablejar.maven.common.LegacyPatchCleaner;
import org.wildfly.plugins.bootablejar.maven.common.MavenRepositoriesEnricher;
import org.wildfly.plugins.bootablejar.maven.goals.BootLoggingConfiguration;
import org.wildfly.plugins.bootablejar.maven.goals.CliSession;
import org.wildfly.security.manager.WildFlySecurityManager;

public class AbstractBuildBootableJarMojo
extends AbstractMojo {
    public static final String BOOTABLE_SUFFIX = "bootable";
    public static final String JAR = "jar";
    public static final String WAR = "war";
    private static final String MODULE_ID_JAR_RUNTIME = "org.wildfly.bootable-jar";
    private static final String BOOT_ARTIFACT_ID = "wildfly-jar-boot";
    @Component
    RepositorySystem repoSystem;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    List<RemoteRepository> repositories;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    MavenSession session;
    @Parameter(alias="plugin-options", required=false)
    Map<String, String> pluginOptions = Collections.emptyMap();
    @Parameter(alias="offline", defaultValue="false")
    boolean offline;
    @Parameter(alias="log-time", defaultValue="false")
    boolean logTime;
    @Parameter(alias="layers", required=false)
    List<String> layers = Collections.emptyList();
    @Parameter(alias="excluded-layers", required=false)
    List<String> excludedLayers = Collections.emptyList();
    @Parameter(alias="record-state", defaultValue="false")
    boolean recordState;
    @Parameter(defaultValue="${project.build.directory}")
    String projectBuildDir;
    @Parameter(alias="context-root", defaultValue="true", property="wildfly.bootable.context.root")
    boolean contextRoot;
    @Parameter(alias="feature-pack-location", required=false, property="wildfly.bootable.fpl")
    String featurePackLocation;
    @Parameter(alias="cli-sessions")
    List<CliSession> cliSessions = Collections.emptyList();
    @Parameter(alias="hollow-jar", property="wildfly.bootable.hollow")
    boolean hollowJar;
    @Parameter(defaultValue="false", property="wildfly.bootable.package.skip")
    boolean skip;
    @Parameter(alias="output-file-name", property="wildfly.bootable.package.output.file.name")
    String outputFileName;
    @Parameter(alias="feature-packs", required=false)
    private List<FeaturePack> featurePacks = Collections.emptyList();
    @Parameter(alias="extra-server-content-dirs", property="wildfly.bootable.package.extra.server.content.dirs")
    List<String> extraServerContent = Collections.emptyList();
    @Parameter(alias="provisioning-file", property="wildfly.bootable.provisioning.file", defaultValue="${project.basedir}/galleon/provisioning.xml")
    private File provisioningFile;
    @Parameter(alias="legacy-patch-cli-script")
    String legacyPatchCliScript;
    @Parameter(alias="legacy-patch-clean-up", defaultValue="false")
    boolean legacyPatchCleanUp;
    @Parameter(alias="display-cli-scripts-output")
    boolean displayCliScriptsOutput;
    @Parameter(alias="boot-logging-config", property="wildfly.bootable.logging.config")
    private File bootLoggingConfig;
    @Parameter(alias="bootable-jar-build-artifacts", property="wildfly.bootable.jar.build.artifacts", defaultValue="bootable-jar-build-artifacts")
    private String bootableJarBuildArtifacts;
    @Inject
    private BootLoggingConfiguration bootLoggingConfiguration;
    private final Set<String> extraLayers = new HashSet<String>();
    private Path wildflyDir;
    private MavenRepoManager artifactResolver;
    private final Set<Artifact> cliArtifacts = new HashSet<Artifact>();
    private boolean forkCli;

    public Path getJBossHome() {
        return this.wildflyDir;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact bootArtifact;
        MavenRepositoriesEnricher.enrich(this.session, this.project, this.repositories);
        MavenArtifactRepositoryManager mavenArtifactRepositoryManager = this.artifactResolver = this.offline ? new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession) : new MavenArtifactRepositoryManager(this.repoSystem, this.repoSession, this.repositories);
        if (this.outputFileName == null) {
            this.outputFileName = this.project.getBuild().getFinalName() + "-" + BOOTABLE_SUFFIX + "." + JAR;
        }
        this.validateProjectFile();
        if (System.getProperty("dev") != null) {
            Path deployments = this.getDeploymentsDir();
            IoUtils.recursiveDelete((Path)deployments);
            try {
                Files.createDirectory(deployments, new FileAttribute[0]);
                this.copyProjectFile(deployments);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Fail creating deployments directory ", (Exception)ex);
            }
            return;
        }
        Path contentRoot = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.bootableJarBuildArtifacts);
        if (Files.exists(contentRoot, new LinkOption[0])) {
            AbstractBuildBootableJarMojo.deleteDir(contentRoot);
        }
        Path jarFile = Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve(this.outputFileName);
        IoUtils.recursiveDelete((Path)contentRoot);
        this.wildflyDir = contentRoot.resolve("wildfly");
        Path contentDir = contentRoot.resolve("jar-content");
        try {
            Files.createDirectories(contentRoot, new FileAttribute[0]);
            Files.createDirectories(contentDir, new FileAttribute[0]);
            Files.deleteIfExists(jarFile);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Packaging wildfly failed", (Exception)ex);
        }
        try {
            bootArtifact = this.provisionServer(this.wildflyDir, contentDir.resolve("provisioning.xml"));
        }
        catch (IOException | XMLStreamException | ProvisioningException ex) {
            throw new MojoExecutionException("Provisioning failed", (Exception)ex);
        }
        try {
            this.forkCli = Boolean.parseBoolean(this.pluginOptions.getOrDefault("jboss-fork-embedded", "false"));
            if (this.forkCli) {
                this.getLog().info((CharSequence)"CLI executions are done in forked process");
            }
            this.legacyPatching();
            this.copyExtraContentInternal(this.wildflyDir, contentDir);
            this.copyExtraContent(this.wildflyDir);
            ArrayList<String> commands = new ArrayList<String>();
            this.deploy(commands);
            ArrayList<String> serverConfigCommands = new ArrayList<String>();
            this.configureCli(serverConfigCommands);
            commands.addAll(serverConfigCommands);
            if (!commands.isEmpty()) {
                this.executeCliScript(this.wildflyDir, commands, null, false, "Server configuration", true);
                if (!serverConfigCommands.isEmpty()) {
                    Path genCliScript = contentRoot.resolve("generated-cli-script.txt");
                    try (BufferedWriter writer = Files.newBufferedWriter(genCliScript, StandardCharsets.UTF_8, new OpenOption[0]);){
                        for (String str : serverConfigCommands) {
                            writer.write(str);
                            writer.newLine();
                        }
                    }
                    this.getLog().info((CharSequence)("Stored CLI script executed to update server configuration in " + genCliScript + " file."));
                }
            }
            this.userScripts(this.wildflyDir, this.cliSessions, true);
            if (this.bootLoggingConfig == null) {
                this.generateLoggingConfig(this.wildflyDir);
            } else {
                Path loggingConfig = this.bootLoggingConfig.toPath();
                if (Files.notExists(loggingConfig, new LinkOption[0])) {
                    throw new MojoExecutionException(String.format("The bootLoggingConfig %s does not exist.", this.bootLoggingConfig));
                }
                Path target = this.getJBossHome().resolve("standalone").resolve("configuration").resolve("logging.properties");
                Files.copy(loggingConfig, target, StandardCopyOption.REPLACE_EXISTING);
            }
            this.cleanupServer(this.wildflyDir);
            AbstractBuildBootableJarMojo.zipServer(this.wildflyDir, contentDir);
            this.buildJar(contentDir, jarFile, bootArtifact);
        }
        catch (Exception ex) {
            if (ex instanceof MojoExecutionException) {
                throw (MojoExecutionException)ex;
            }
            if (ex instanceof MojoFailureException) {
                throw (MojoFailureException)ex;
            }
            throw new MojoExecutionException("Packaging wildfly failed", ex);
        }
        finally {
            System.clearProperty("module.path");
        }
        this.attachJar(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void legacyPatching() throws Exception {
        if (this.legacyPatchCliScript != null) {
            LegacyPatchCleaner patchCleaner = null;
            if (this.legacyPatchCleanUp) {
                patchCleaner = new LegacyPatchCleaner(this.wildflyDir, this.getLog());
            }
            String prop = "jboss.home.dir";
            System.setProperty(prop, this.wildflyDir.toAbsolutePath().toString());
            try {
                ArrayList<CliSession> cliPatchingSessions = new ArrayList<CliSession>();
                ArrayList<String> files = new ArrayList<String>();
                files.add(this.legacyPatchCliScript);
                CliSession patchingSession = new CliSession();
                patchingSession.setResolveExpressions(true);
                patchingSession.setScriptFiles(files);
                cliPatchingSessions.add(patchingSession);
                this.getLog().info((CharSequence)("Patching server with " + this.legacyPatchCliScript + " CLI script."));
                this.userScripts(this.wildflyDir, cliPatchingSessions, false);
                if (patchCleaner != null) {
                    patchCleaner.clean();
                }
            }
            finally {
                System.clearProperty(prop);
            }
        }
    }

    private void copyExtraContent(Path wildflyDir) throws Exception {
        for (String path : this.extraServerContent) {
            Path extraContent = Paths.get(path, new String[0]);
            if (!Files.exists(extraContent, new LinkOption[0])) {
                throw new Exception("Extra content dir " + path + " doesn't exist");
            }
            IoUtils.copy((Path)extraContent, (Path)wildflyDir);
        }
    }

    protected void copyExtraContentInternal(Path wildflyDir, Path contentDir) throws Exception {
    }

    protected void addExtraLayer(String layer) {
        this.extraLayers.add(layer);
    }

    private void copyProjectFile(Path targetDir) throws IOException, MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String fileName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || fileName.endsWith(WAR)) && this.contextRoot) {
            fileName = "ROOT.war";
        }
        Files.copy(f.toPath(), targetDir.resolve(fileName), new CopyOption[0]);
    }

    protected Path getDeploymentsDir() {
        return Paths.get(this.project.getBuild().getDirectory(), new String[0]).resolve("deployments");
    }

    protected void configureCli(List<String> commands) {
    }

    private void cleanupServer(Path jbossHome) throws IOException {
        Path history = jbossHome.resolve("standalone").resolve("configuration").resolve("standalone_xml_history");
        IoUtils.recursiveDelete((Path)history);
        Files.deleteIfExists(jbossHome.resolve("README.txt"));
    }

    protected File validateProjectFile() throws MojoExecutionException {
        File f = this.getProjectFile();
        if (f == null && !this.hollowJar) {
            throw new MojoExecutionException("Cannot package without a primary artifact; please `mvn package` prior to invoking wildfly-jar:package from the command-line");
        }
        return f;
    }

    private void userScripts(Path wildflyDir, List<CliSession> sessions, boolean startEmbedded) throws Exception {
        for (CliSession session : sessions) {
            ArrayList<String> commands = new ArrayList<String>();
            for (String path : session.getScriptFiles()) {
                File f = new File(path);
                if (!f.exists()) {
                    if (!f.isAbsolute()) {
                        f = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(f.toPath()).toFile();
                    }
                    if (!f.exists()) {
                        throw new RuntimeException("Cli script file " + path + " doesn't exist");
                    }
                }
                BufferedReader reader = new BufferedReader(new FileReader(f));
                Throwable throwable = null;
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        commands.add(line.trim());
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
            if (commands.isEmpty()) continue;
            this.executeCliScript(wildflyDir, commands, session.getPropertiesFile(), session.getResolveExpression(), session.toString(), startEmbedded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCliScript(Path jbossHome, List<String> commands, String propertiesFile, boolean resolveExpression, String message, boolean startEmbedded) throws Exception {
        this.getLog().info((CharSequence)("Executing CLI, " + message));
        Properties props = null;
        if (propertiesFile != null) {
            props = this.loadProperties(propertiesFile);
        }
        try {
            this.processCLI(jbossHome, commands, resolveExpression, startEmbedded);
        }
        finally {
            if (props != null) {
                for (String key : props.stringPropertyNames()) {
                    WildFlySecurityManager.clearPropertyPrivileged((String)key);
                }
            }
        }
    }

    private void generateLoggingConfig(Path wildflyDir) throws Exception {
        try (CLIExecutor cmdCtx = this.forkCli ? new RemoteCLIExecutor(wildflyDir, this.getCLIArtifacts(), this, false) : new LocalCLIExecutor(wildflyDir, this.getCLIArtifacts(), this, false, this.bootLoggingConfiguration);){
            try {
                cmdCtx.generateBootLoggingConfig();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)("Failed to generate logging configuration: " + cmdCtx.getOutput()));
                throw e;
            }
        }
    }

    private void processCLI(Path jbossHome, List<String> commands, boolean resolveExpression, boolean startEmbedded) throws Exception {
        ArrayList<String> allCommands = new ArrayList<String>();
        if (startEmbedded) {
            allCommands.add("embed-server --jboss-home=" + jbossHome + " --std-out=discard");
        }
        for (String line : commands) {
            allCommands.add(line.trim());
        }
        if (startEmbedded) {
            allCommands.add("stop-embedded-server");
        }
        try (CLIExecutor executor = this.forkCli ? new RemoteCLIExecutor(jbossHome, this.getCLIArtifacts(), this, resolveExpression) : new LocalCLIExecutor(jbossHome, this.getCLIArtifacts(), this, resolveExpression, this.bootLoggingConfiguration);){
            try {
                executor.execute(allCommands);
            }
            catch (Exception ex) {
                this.getLog().error((CharSequence)("Error executing CLI script " + ex.getLocalizedMessage()));
                this.getLog().error((CharSequence)executor.getOutput());
                throw ex;
            }
            if (this.displayCliScriptsOutput) {
                this.getLog().info((CharSequence)executor.getOutput());
            }
        }
        this.getLog().info((CharSequence)"CLI scripts execution done.");
    }

    private List<Path> getCLIArtifacts() throws MojoExecutionException {
        this.getLog().debug((CharSequence)("CLI artifacts " + this.cliArtifacts));
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(this.wildflyDir.resolve("jboss-modules.jar"));
        for (Artifact a : this.cliArtifacts) {
            paths.add(this.resolveArtifact(a));
        }
        return paths;
    }

    public Level disableLog() {
        Logger l = Logger.getLogger("");
        Level level = l.getLevel();
        if (!this.getLog().isDebugEnabled()) {
            l.setLevel(Level.OFF);
        }
        return level;
    }

    public void enableLog(Level level) {
        Logger l = Logger.getLogger("");
        l.setLevel(level);
    }

    private Properties loadProperties(String propertiesFile) throws Exception {
        File f = new File(propertiesFile);
        if (!f.exists()) {
            if (!f.isAbsolute()) {
                f = Paths.get(this.project.getBasedir().getAbsolutePath(), new String[0]).resolve(f.toPath()).toFile();
            }
            if (!f.exists()) {
                throw new RuntimeException("Cli properties file " + f + " doesn't exist");
            }
        }
        Properties props = new Properties();
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
            props.load(inputStreamReader);
        }
        catch (IOException e) {
            throw new Exception("Failed to load properties from " + propertiesFile + ": " + e.getLocalizedMessage());
        }
        for (String key : props.stringPropertyNames()) {
            WildFlySecurityManager.setPropertyPrivileged((String)key, (String)props.getProperty(key));
        }
        return props;
    }

    private File getProjectFile() {
        if (this.project.getArtifact().getFile() != null) {
            return this.project.getArtifact().getFile();
        }
        String finalName = this.project.getBuild().getFinalName();
        Path candidate = Paths.get(this.projectBuildDir, finalName + "." + this.project.getPackaging());
        if (Files.exists(candidate, new LinkOption[0])) {
            return candidate.toFile();
        }
        return null;
    }

    protected Path getProvisioningFile() {
        return this.provisioningFile.toPath();
    }

    protected boolean hasLayers() {
        return !this.layers.isEmpty();
    }

    protected List<String> getLayers() {
        return this.layers;
    }

    protected List<String> getExcludedLayers() {
        return this.excludedLayers;
    }

    private Artifact provisionServer(Path home, Path outputProvisioningFile) throws ProvisioningException, MojoExecutionException, IOException, XMLStreamException {
        Path provisioningFile = this.getProvisioningFile();
        ProvisioningConfig.Builder state = null;
        try (ProvisioningManager pm = ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver((RepositoryArtifactResolver)this.artifactResolver)).setInstallationHome(home).setMessageWriter((MessageWriter)new MvnMessageWriter(this.getLog())).setLogTime(this.logTime).setRecordState(this.recordState).build();){
            Object defaultConfigId;
            ProvisioningConfig config;
            ConfigModel.Builder configBuilder = null;
            ConfigId defaultConfig = null;
            if (!this.featurePacks.isEmpty()) {
                if (Files.exists(provisioningFile, new LinkOption[0])) {
                    this.getLog().warn((CharSequence)("Feature packs defined in pom.xml override provisioning file located in " + provisioningFile));
                }
                if (this.featurePackLocation != null) {
                    throw new MojoExecutionException("Feature packlocation can't be used with a list of feature-packs");
                }
                state = ProvisioningConfig.builder();
                for (FeaturePack fp : this.featurePacks) {
                    Object fpl;
                    if (fp.getLocation() == null && (fp.getGroupId() == null || fp.getArtifactId() == null) && fp.getNormalizedPath() == null) {
                        throw new MojoExecutionException("Feature-pack location, Maven GAV or feature pack path is missing");
                    }
                    if (fp.getNormalizedPath() != null) {
                        fpl = pm.getLayoutFactory().addLocal(fp.getNormalizedPath(), false);
                    } else if (fp.getGroupId() != null && fp.getArtifactId() != null) {
                        Path path = this.resolveMaven(fp);
                        fpl = pm.getLayoutFactory().addLocal(path, false);
                    } else {
                        fpl = FeaturePackLocation.fromString((String)fp.getLocation());
                    }
                    FeaturePackConfig.Builder fpConfig = FeaturePackConfig.builder((FeaturePackLocation)fpl);
                    fpConfig.setInheritConfigs(false);
                    if (fp.isInheritPackages() != null) {
                        fpConfig.setInheritPackages(fp.isInheritPackages().booleanValue());
                    }
                    if (fp.getIncludedDefaultConfig() != null) {
                        ConfigId configId = new ConfigId("standalone", fp.getIncludedDefaultConfig());
                        fpConfig.includeDefaultConfig(configId);
                        if (defaultConfig == null) {
                            defaultConfig = configId;
                            configBuilder = ConfigModel.builder((String)defaultConfig.getModel(), (String)defaultConfig.getName());
                            configBuilder.setProperty("--server-config", "standalone.xml");
                        } else if (!defaultConfig.getName().equals(fp.getIncludedDefaultConfig())) {
                            throw new ProvisioningException("Feature-packs are not including the same default config");
                        }
                    }
                    if (!fp.getIncludedPackages().isEmpty()) {
                        for (String includedPackage : fp.getIncludedPackages()) {
                            fpConfig.includePackage(includedPackage);
                        }
                    }
                    if (!fp.getExcludedPackages().isEmpty()) {
                        for (String excludedPackage : fp.getExcludedPackages()) {
                            fpConfig.excludePackage(excludedPackage);
                        }
                    }
                    state.addFeaturePackDep(fpConfig.build());
                }
            }
            if (!this.layers.isEmpty() || !this.excludedLayers.isEmpty()) {
                if (this.featurePackLocation == null && state == null) {
                    throw new ProvisioningException("No server feature-pack location to provision layers, you must set a feature-pack-location.");
                }
                if (Files.exists(provisioningFile, new LinkOption[0])) {
                    this.getLog().warn((CharSequence)("Layers defined in pom.xml override provisioning file located in " + provisioningFile));
                }
                if (configBuilder == null) {
                    configBuilder = ConfigModel.builder((String)"standalone", (String)"standalone.xml");
                }
                for (String layer : this.layers) {
                    configBuilder.includeLayer(layer);
                }
                for (String layer : this.extraLayers) {
                    if (this.layers.contains(layer)) continue;
                    configBuilder.includeLayer(layer);
                }
                for (String layer : this.excludedLayers) {
                    configBuilder.excludeLayer(layer);
                }
                if (this.pluginOptions.isEmpty()) {
                    this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
                } else if (!this.pluginOptions.containsKey("optional-packages")) {
                    this.pluginOptions.put("optional-packages", "passive+");
                }
                if (state == null) {
                    state = ProvisioningConfig.builder();
                    FeaturePackConfig dependency = ((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)FeaturePackLocation.fromString((String)this.featurePackLocation)).setInheritPackages(false).setInheritConfigs(false)).build();
                    state.addFeaturePackDep(dependency);
                }
                state.addConfig(configBuilder.build());
            }
            if (state == null) {
                if (Files.exists(provisioningFile, new LinkOption[0])) {
                    config = ProvisioningXmlParser.parse((Path)provisioningFile);
                } else {
                    if (this.featurePackLocation == null) {
                        throw new ProvisioningException("No server feature-pack location to provision microprofile standalone configuration, you must set a feature-pack-location.");
                    }
                    ConfigModel.Builder defaultConfigBuilder = null;
                    defaultConfigId = this.getDefaultConfig();
                    if (!this.extraLayers.isEmpty()) {
                        defaultConfigBuilder = ConfigModel.builder((String)defaultConfigId.getModel(), (String)defaultConfigId.getName());
                        for (String layer : this.extraLayers) {
                            defaultConfigBuilder.includeLayer(layer);
                        }
                    }
                    if (this.pluginOptions.isEmpty()) {
                        this.pluginOptions = Collections.singletonMap("optional-packages", "passive+");
                    } else if (!this.pluginOptions.containsKey("optional-packages")) {
                        this.pluginOptions.put("optional-packages", "passive+");
                    }
                    FeaturePackConfig dependency = ((FeaturePackConfig.Builder)((FeaturePackConfig.Builder)FeaturePackConfig.builder((FeaturePackLocation)FeaturePackLocation.fromString((String)this.featurePackLocation)).setInheritPackages(false).setInheritConfigs(false)).includeDefaultConfig(defaultConfigId.getModel(), defaultConfigId.getName())).build();
                    ProvisioningConfig.Builder provBuilder = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(dependency)).addOptions(this.pluginOptions);
                    if (defaultConfigBuilder == null) {
                        defaultConfigBuilder = ConfigModel.builder((String)defaultConfigId.getModel(), (String)defaultConfigId.getName());
                    }
                    defaultConfigBuilder.setProperty("--server-config", "standalone.xml");
                    provBuilder.addConfig(defaultConfigBuilder.build());
                    config = provBuilder.build();
                }
            } else {
                state.addOptions(this.pluginOptions);
                config = state.build();
            }
            IoUtils.recursiveDelete((Path)home);
            this.getLog().info((CharSequence)("Building server based on " + config.getFeaturePackDeps() + " galleon feature-packs"));
            FileWriter writer = new FileWriter(outputProvisioningFile.toFile());
            defaultConfigId = null;
            try {
                ProvisioningXmlWriter.getInstance().write((Object)config, (Writer)writer);
            }
            catch (Throwable throwable) {
                defaultConfigId = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (defaultConfigId != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)defaultConfigId).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            ProvisioningRuntime rt = pm.getRuntime(config);
            Artifact bootArtifact = null;
            for (FeaturePackRuntime fprt : rt.getFeaturePacks()) {
                Artifact a;
                String value;
                HashMap<String, String> propsMap;
                Path artifactProps;
                if (fprt.getPackage(MODULE_ID_JAR_RUNTIME) != null) {
                    artifactProps = fprt.getResource(new String[]{"wildfly/artifact-versions.properties"});
                    propsMap = new HashMap<String, String>();
                    try {
                        AbstractBuildBootableJarMojo.readProperties(artifactProps, propsMap);
                    }
                    catch (Exception ex) {
                        throw new MojoExecutionException("Error reading artifact versions", ex);
                    }
                    for (Map.Entry entry : propsMap.entrySet()) {
                        value = (String)entry.getValue();
                        a = AbstractBuildBootableJarMojo.getArtifact(value);
                        if (!BOOT_ARTIFACT_ID.equals(a.getArtifactId())) continue;
                        this.getLog().info((CharSequence)("Found boot artifact " + a + " in " + fprt.getFPID()));
                        bootArtifact = a;
                        break;
                    }
                }
                artifactProps = fprt.getResource(new String[]{"wildfly/artifact-versions.properties"});
                propsMap = new HashMap();
                try {
                    AbstractBuildBootableJarMojo.readProperties(artifactProps, propsMap);
                }
                catch (Exception ex) {
                    throw new MojoExecutionException("Error reading artifact versions", ex);
                }
                for (Map.Entry entry : propsMap.entrySet()) {
                    value = (String)entry.getValue();
                    a = AbstractBuildBootableJarMojo.getArtifact(value);
                    if ("wildfly-cli".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.getLog().debug((CharSequence)("Found cli artifact " + a + " in " + fprt.getFPID()));
                        this.cliArtifacts.add((Artifact)new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getVersion(), "provided", JAR, "client", (ArtifactHandler)new DefaultArtifactHandler(JAR)));
                        continue;
                    }
                    if ("wildfly-patching".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.getLog().debug((CharSequence)("Found patching artifact " + a + " in " + fprt.getFPID()));
                        this.cliArtifacts.add(a);
                        continue;
                    }
                    if ("wildfly-controller".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.getLog().debug((CharSequence)("Found controller artifact " + a + " in " + fprt.getFPID()));
                        this.cliArtifacts.add(a);
                        continue;
                    }
                    if ("wildfly-version".equals(a.getArtifactId()) && "org.wildfly.core".equals(a.getGroupId())) {
                        this.getLog().debug((CharSequence)("Found version artifact " + a + " in " + fprt.getFPID()));
                        this.cliArtifacts.add(a);
                    }
                    if (!"vdx-core".equals(a.getArtifactId()) || !"org.projectodd.vdx".equals(a.getGroupId())) continue;
                    this.getLog().debug((CharSequence)("Found vdx-core artifact " + a + " in " + fprt.getFPID()));
                    this.cliArtifacts.add(a);
                }
            }
            if (bootArtifact == null) {
                throw new ProvisioningException("Server doesn't support bootable jar packaging");
            }
            pm.provision(rt.getLayout());
            Iterator iterator = bootArtifact;
            return iterator;
        }
    }

    protected ConfigId getDefaultConfig() {
        return new ConfigId("standalone", "standalone-microprofile.xml");
    }

    static Artifact getArtifact(String str) {
        String[] parts = str.split(":");
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String classifier = parts[3];
        String extension = parts[4];
        return new DefaultArtifact(groupId, artifactId, version, "provided", extension, classifier, (ArtifactHandler)new DefaultArtifactHandler(extension));
    }

    private static void readProperties(Path propsFile, Map<String, String> propsMap) throws Exception {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty() && line.charAt(0) != '#') {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new Exception("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
    }

    private void deploy(List<String> commands) throws MojoExecutionException {
        if (this.hollowJar) {
            this.getLog().info((CharSequence)"Hollow jar, No application deployment added to server.");
            return;
        }
        File f = this.validateProjectFile();
        String runtimeName = f.getName();
        if ((this.project.getPackaging().equals(WAR) || runtimeName.endsWith(WAR)) && this.contextRoot) {
            runtimeName = "ROOT.war";
        }
        commands.add("deploy " + f.getAbsolutePath() + " --name=" + f.getName() + " --runtime-name=" + runtimeName);
    }

    private static void zipServer(Path home, Path contentDir) throws IOException {
        Path target = contentDir.resolve("wildfly.zip");
        ZipUtils.zip((Path)home, (Path)target);
    }

    private void buildJar(Path contentDir, Path jarFile, Artifact artifact) throws MojoExecutionException, IOException {
        Path rtJarFile = this.resolveArtifact(artifact);
        ZipUtils.unzip((Path)rtJarFile, (Path)contentDir);
        ZipUtils.zip((Path)contentDir, (Path)jarFile);
    }

    public String retrievePluginVersion() throws PlexusConfigurationException, MojoExecutionException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/META-INF/maven/plugin.xml");
        if (is == null) {
            throw new MojoExecutionException("Can't retrieve plugin descriptor");
        }
        PluginDescriptorBuilder builder = new PluginDescriptorBuilder();
        PluginDescriptor pluginDescriptor = builder.build((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        return pluginDescriptor.getVersion();
    }

    public Path resolveArtifact(String groupId, String artifactId, String classifier, String version) throws UnsupportedEncodingException, PlexusConfigurationException, MojoExecutionException {
        return this.resolveArtifact((Artifact)new DefaultArtifact(groupId, artifactId, version, "provided", JAR, classifier, (ArtifactHandler)new DefaultArtifactHandler(JAR)));
    }

    Path resolveArtifact(Artifact artifact) throws MojoExecutionException {
        MavenArtifact mavenArtifact = new MavenArtifact();
        mavenArtifact.setGroupId(artifact.getGroupId());
        mavenArtifact.setArtifactId(artifact.getArtifactId());
        mavenArtifact.setVersion(artifact.getVersion());
        mavenArtifact.setClassifier(artifact.getClassifier());
        mavenArtifact.setExtension(artifact.getType());
        try {
            this.artifactResolver.resolve(mavenArtifact);
            return mavenArtifact.getPath();
        }
        catch (MavenUniverseException ex) {
            throw new MojoExecutionException(ex.toString(), (Exception)((Object)ex));
        }
    }

    private void attachJar(Path jarFile) {
        this.debug("Attaching bootable jar %s as a project artifact", jarFile);
        this.projectHelper.attachArtifact(this.project, JAR, BOOTABLE_SUFFIX, jarFile.toFile());
    }

    private void debug(String msg, Object ... args) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)String.format(msg, args));
        }
    }

    static void deleteDir(Path root) {
        if (root == null || !Files.exists(root, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                    if (e != null) {
                        throw e;
                    }
                    try {
                        Files.delete(dir);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Path resolveMaven(ArtifactCoordinate coordinate) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact().setGroupId(coordinate.getGroupId()).setArtifactId(coordinate.getArtifactId()).setVersion(coordinate.getVersion()).setExtension(coordinate.getExtension()).setClassifier(coordinate.getClassifier());
        this.artifactResolver.resolve(artifact);
        return artifact.getPath();
    }
}

