/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.dmr.ValueExpression;

class Expression {
    private static final int INITIAL = 0;
    private static final int GOT_DOLLAR = 1;
    private static final int GOT_OPEN_BRACE = 2;
    private static final int RESOLVED = 3;
    private static final int DEFAULT = 4;
    private final List<String> keys;
    private final String defaultValue;

    private Expression(Collection<String> keys, String defaultValue) {
        this.keys = new ArrayList<String>(keys);
        this.defaultValue = defaultValue;
    }

    static Collection<Expression> parse(ValueExpression value) {
        return Expression.parseExpression(value.getExpressionString());
    }

    static Collection<Expression> parse(String expression) {
        return Expression.parseExpression(expression);
    }

    List<String> getKeys() {
        return Collections.unmodifiableList(this.keys);
    }

    boolean hasDefault() {
        return this.defaultValue != null;
    }

    String getDefaultValue() {
        return this.defaultValue;
    }

    void appendTo(StringBuilder builder) {
        builder.append("${");
        Iterator<String> iter = this.keys.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(',');
        }
        if (this.hasDefault()) {
            builder.append(':').append(this.defaultValue);
        }
        builder.append('}');
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendTo(builder);
        return builder.toString();
    }

    private static Collection<Expression> parseExpression(String expression) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder key = new StringBuilder();
        String defaultValue = null;
        char[] chars = expression.toCharArray();
        int len = chars.length;
        int state = 0;
        int start = -1;
        int nameStart = -1;
        block10: for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            switch (state) {
                case 0: {
                    if (ch != '$') continue block10;
                    state = 1;
                    continue block10;
                }
                case 1: {
                    if (ch == '{') {
                        nameStart = start = i + 1;
                        state = 2;
                        continue block10;
                    }
                    state = 0;
                    continue block10;
                }
                case 2: {
                    switch (ch) {
                        case ',': 
                        case ':': 
                        case '}': {
                            String name = expression.substring(nameStart, i).trim();
                            if ("/".equals(name)) {
                                state = ch == '}' ? 0 : 3;
                                break;
                            }
                            if (":".equals(name)) {
                                state = ch == '}' ? 0 : 3;
                                break;
                            }
                            key.append(name);
                            if (ch == '}') {
                                state = 0;
                                if (key.length() > 0) {
                                    keys.add(key.toString());
                                    key.setLength(0);
                                }
                                result.add(new Expression(keys, defaultValue));
                                defaultValue = null;
                                keys.clear();
                                break;
                            }
                            if (ch == ',') {
                                if (key.length() > 0) {
                                    keys.add(key.toString());
                                    key.setLength(0);
                                }
                                nameStart = i + 1;
                                break;
                            }
                            start = i + 1;
                            state = 4;
                            if (key.length() <= 0) continue block10;
                            keys.add(key.toString());
                            key.setLength(0);
                            break;
                        }
                    }
                    continue block10;
                }
                case 3: {
                    if (ch != '}') continue block10;
                    state = 0;
                    if (keys.size() <= 0) continue block10;
                    result.add(new Expression(keys, defaultValue));
                    defaultValue = null;
                    keys.clear();
                    continue block10;
                }
                case 4: {
                    if (ch != '}') continue block10;
                    state = 0;
                    defaultValue = expression.substring(start, i);
                    if (key.length() > 0) {
                        keys.add(key.toString());
                        key.setLength(0);
                    }
                    if (keys.size() <= 0) continue block10;
                    result.add(new Expression(keys, defaultValue));
                    defaultValue = null;
                    keys.clear();
                    continue block10;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if (key.length() > 0) {
            keys.add(key.toString());
            result.add(new Expression(keys, defaultValue));
        }
        return result;
    }
}

