/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.cli;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.plugins.bootablejar.maven.goals.BootLoggingConfiguration;

public class CLIWrapper
implements AutoCloseable {
    private final Object ctx;
    private final Method handle;
    private final Method terminateSession;
    private final Method getModelControllerClient;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final String origConfig;
    private final Path jbossHome;
    private final BootLoggingConfiguration bootLoggingConfiguration;

    public CLIWrapper(Path jbossHome, boolean resolveExpression, ClassLoader loader) throws Exception {
        this(jbossHome, resolveExpression, loader, null);
    }

    public CLIWrapper(Path jbossHome, boolean resolveExpression, ClassLoader loader, BootLoggingConfiguration bootLoggingConfiguration) throws Exception {
        this.jbossHome = jbossHome;
        Path config = jbossHome.resolve("bin").resolve("jboss-cli.xml");
        this.origConfig = System.getProperty("jboss.cli.config");
        if (Files.exists(config, new LinkOption[0])) {
            System.setProperty("jboss.cli.config", config.toString());
        }
        Object builder = loader.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration$Builder").newInstance();
        Method setEchoCommand = builder.getClass().getMethod("setEchoCommand", Boolean.TYPE);
        setEchoCommand.invoke(builder, true);
        Method setResolve = builder.getClass().getMethod("setResolveParameterValues", Boolean.TYPE);
        setResolve.invoke(builder, resolveExpression);
        Method setOutput = builder.getClass().getMethod("setConsoleOutput", OutputStream.class);
        setOutput.invoke(builder, this.out);
        Object ctxConfig = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        Object factory = loader.loadClass("org.jboss.as.cli.CommandContextFactory").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        Class<?> configClass = loader.loadClass("org.jboss.as.cli.impl.CommandContextConfiguration");
        this.ctx = factory.getClass().getMethod("newCommandContext", configClass).invoke(factory, ctxConfig);
        this.handle = this.ctx.getClass().getMethod("handle", String.class);
        this.terminateSession = this.ctx.getClass().getMethod("terminateSession", new Class[0]);
        this.getModelControllerClient = this.ctx.getClass().getMethod("getModelControllerClient", new Class[0]);
        this.bootLoggingConfiguration = bootLoggingConfiguration;
    }

    public void handle(String command) throws Exception {
        this.handle.invoke(this.ctx, command);
    }

    public String getOutput() {
        return this.out.toString();
    }

    @Override
    public void close() throws Exception {
        try {
            this.terminateSession.invoke(this.ctx, new Object[0]);
        }
        finally {
            if (this.origConfig != null) {
                System.setProperty("jboss.cli.config", this.origConfig);
            }
        }
    }

    private ModelControllerClient getModelControllerClient() throws Exception {
        return (ModelControllerClient)this.getModelControllerClient.invoke(this.ctx, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateBootLoggingConfig() throws Exception {
        Objects.requireNonNull(this.bootLoggingConfiguration);
        Exception toThrow = null;
        try {
            this.handle("embed-server --jboss-home=" + this.jbossHome + " --std-out=discard");
            ModelControllerClient client = this.getModelControllerClient();
            Path configDir = this.jbossHome.resolve("standalone").resolve("configuration");
            this.bootLoggingConfiguration.generate(configDir, client);
        }
        catch (Exception e) {
            toThrow = e;
        }
        finally {
            try {
                this.handle("stop-embedded-server");
            }
            catch (Exception e) {
                if (toThrow != null) {
                    e.addSuppressed(toThrow);
                }
                toThrow = e;
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }
}

