/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.goals;

import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.wildfly.plugins.bootablejar.maven.common.OverriddenArtifact;

final class MavenProjectArtifactVersions {
    private static final String TEST_JAR = "test-jar";
    private static final String SYSTEM = "system";
    private final Map<String, Artifact> artifactVersions = new TreeMap<String, Artifact>();
    private final Map<String, Artifact> fpVersions = new TreeMap<String, Artifact>();

    static MavenProjectArtifactVersions getInstance(MavenProject project) {
        return new MavenProjectArtifactVersions(project);
    }

    private MavenProjectArtifactVersions(MavenProject project) {
        for (Artifact artifact : project.getArtifacts()) {
            if (TEST_JAR.equals(artifact.getType()) || SYSTEM.equals(artifact.getScope())) continue;
            this.put(artifact);
        }
    }

    public Artifact getArtifact(OverriddenArtifact artifact) {
        String key = MavenProjectArtifactVersions.getKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier());
        Artifact a = this.artifactVersions.get(key);
        return a;
    }

    public Artifact getFeaturePackArtifact(String groupId, String artifactId, String classifier) {
        String key = MavenProjectArtifactVersions.getKey(groupId, artifactId, classifier);
        return this.fpVersions.get(key);
    }

    private static String getKey(String groupId, String artifactId, String classifier) {
        StringBuilder buf = new StringBuilder(groupId).append(':').append(artifactId);
        if (classifier != null && !classifier.isEmpty()) {
            buf.append("::").append(classifier);
        }
        return buf.toString();
    }

    private void put(Artifact artifact) {
        String key = MavenProjectArtifactVersions.getKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier());
        if ("zip".equals(artifact.getType())) {
            this.fpVersions.put(key, artifact);
        } else {
            this.artifactVersions.put(key, artifact);
        }
    }
}

