/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugins.bootablejar.maven.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.wildfly.plugins.bootablejar.maven.common.FeaturePack;

public class Utils {
    private static final String HEALTH = "health";
    private static final String MP_HEALTH = "microprofile-health";
    public static final String NO_COLOR_OPTION = "-Dorg.jboss.logmanager.nocolor=true";
    private static final Pattern WHITESPACE_IF_NOT_QUOTED = Pattern.compile("(\\S+\"[^\"]+\")|\\S+");

    public static String getBootableJarPath(String jarFileName, MavenProject project, String goal) throws MojoExecutionException {
        String path;
        String jarName = jarFileName;
        if (jarName == null) {
            String finalName = project.getBuild().getFinalName();
            jarName = finalName + "-" + "bootable" + "." + "jar";
        }
        if (!Files.exists(Paths.get(path = project.getBuild().getDirectory() + File.separator + jarName, new String[0]), new LinkOption[0])) {
            throw new MojoExecutionException("Cannot " + goal + " without a bootable jar; please `mvn wildfly-jar:package` prior to invoking wildfly-jar:run from the command-line");
        }
        return path;
    }

    public static String getWildFlyPath(String serverDir, MavenProject project, String goal) throws MojoExecutionException {
        Path path = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(serverDir);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException("Cannot " + goal + " without a server; please `mvn wildfly-jar:package` prior to invoking wildfly-jar:run from the command-line");
        }
        return path.toString();
    }

    public static Path getWildFlyLauncherPath(String serverDir, MavenProject project, String launchScript, String goal) throws MojoExecutionException {
        Path path = Paths.get(project.getBuild().getDirectory(), new String[0]).resolve(serverDir).resolve("bin").resolve(launchScript);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new MojoExecutionException("The provided server launch script " + path + " doesn't exist.");
        }
        return path;
    }

    public static List<String> splitArguments(CharSequence arguments) {
        ArrayList<String> args = new ArrayList<String>();
        Matcher m = WHITESPACE_IF_NOT_QUOTED.matcher(arguments);
        while (m.find()) {
            String value = m.group();
            if (value.isEmpty()) continue;
            args.add(value);
        }
        return args;
    }

    public static ProvisioningSpecifics getSpecifics(List<FeaturePack> fps, ProvisioningManager pm) throws ProvisioningException, IOException {
        return new ProvisioningSpecifics(Utils.getAllLayers(fps, pm));
    }

    private static Set<String> getAllLayers(List<FeaturePack> fps, ProvisioningManager pm) throws ProvisioningException, IOException {
        HashSet<String> allLayers = new HashSet<String>();
        for (FeaturePack fp : fps) {
            FeaturePackLocation fpl;
            if (fp.getNormalizedPath() != null) {
                fpl = pm.getLayoutFactory().addLocal(fp.getNormalizedPath(), false);
            } else if (fp.getGroupId() != null && fp.getArtifactId() != null) {
                String coords = fp.getMavenCoords();
                fpl = FeaturePackLocation.fromString((String)coords);
            } else {
                fpl = FeaturePackLocation.fromString((String)fp.getLocation());
            }
            ProvisioningConfig pConfig = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(FeaturePackConfig.builder((FeaturePackLocation)fpl).build())).build();
            ProvisioningLayout layout = pm.getLayoutFactory().newConfigLayout(pConfig);
            Throwable throwable = null;
            try {
                allLayers.addAll(Utils.getAllLayers((ProvisioningLayout<FeaturePackLayout>)layout));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (layout == null) continue;
                if (throwable != null) {
                    try {
                        layout.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                layout.close();
            }
        }
        return allLayers;
    }

    private static Set<String> getAllLayers(ProvisioningLayout<FeaturePackLayout> pLayout) throws ProvisioningException, IOException {
        HashSet<String> layers = new HashSet<String>();
        for (FeaturePackLayout fp : pLayout.getOrderedFeaturePacks()) {
            for (ConfigId layer : fp.loadLayers()) {
                layers.add(layer.getName());
            }
        }
        return layers;
    }

    public static class ProvisioningSpecifics {
        private final boolean isMicroprofile;
        private final String healthLayer;

        ProvisioningSpecifics(Set<String> allLayers) {
            if (allLayers.contains(Utils.MP_HEALTH)) {
                this.healthLayer = Utils.MP_HEALTH;
                this.isMicroprofile = true;
            } else {
                this.healthLayer = allLayers.contains(Utils.HEALTH) ? Utils.HEALTH : null;
                this.isMicroprofile = false;
            }
        }

        public String getHealthLayer() {
            return this.healthLayer;
        }
    }
}

